(function ( $ ) {
	'use strict';

	// This case is important when theme is not active
	if ( typeof qodef !== 'object' ) {
		window.qodef = {};
	}

	window.qodefCore                = {};
	qodefCore.shortcodes            = {};
	qodefCore.listShortcodesScripts = {
		qodefSwiper: qodef.qodefSwiper,
		qodefPagination: qodef.qodefPagination,
		qodefFilter: qodef.qodefFilter,
		qodefMasonryLayout: qodef.qodefMasonryLayout,
		qodefJustifiedGallery: qodef.qodefJustifiedGallery,
		qodefCustomCursor: qodefCore.qodefCustomCursor,
	};

	qodefCore.body         = $( 'body' );
	qodefCore.html         = $( 'html' );
	qodefCore.windowWidth  = $( window ).width();
	qodefCore.windowHeight = $( window ).height();
	qodefCore.scroll       = 0;

	$( document ).ready(
		function () {
			qodefCore.scroll = $( window ).scrollTop();
			qodefInlinePageStyle.init();
			qodefRevolutioinSlider.init();
		}
	);

	$( window ).resize(
		function () {
			qodefCore.windowWidth  = $( window ).width();
			qodefCore.windowHeight = $( window ).height();
		}
	);

	$( window ).scroll(
		function () {
			qodefCore.scroll = $( window ).scrollTop();
		}
	);

	$( window ).load(
		function () {
			qodefParallaxItem.init();
			qodefAppear.init();
			qodefDrawSvg.init();
			qodefBackgroundOverlay.init();
			qodefParticles.init();
		}
	);

	/**
	 * Check element to be in the viewport
	 */
	var qodefIsInViewport = {
		check: function ( $element, callback, onlyOnce, callbackOnExit ) {
			if ( $element.length ) {
				var offset = typeof $element.data( 'viewport-offset' ) !== 'undefined' ? $element.data( 'viewport-offset' ) : 0.15; // When item is 15% in the viewport

				var observer = new IntersectionObserver(
					function ( entries ) {
						// isIntersecting is true when element and viewport are overlapping
						// isIntersecting is false when element and viewport don't overlap
						if ( entries[0].isIntersecting === true ) {
							callback.call( $element );

							// Stop watching the element when it's initialize
							if ( onlyOnce !== false ) {
								observer.disconnect();
							}
						} else if ( callbackOnExit && onlyOnce === false ) {
							callbackOnExit.call( $element );
						}
					},
					{ threshold: [offset] }
				);

				observer.observe( $element[0] );
			}
		},
	};

	qodefCore.qodefIsInViewport = qodefIsInViewport;

	var qodefScroll = {
		disable: function () {
			if ( window.addEventListener ) {
				window.addEventListener(
					'wheel',
					qodefScroll.preventDefaultValue,
					{ passive: false }
				);
			}

			// window.onmousewheel = document.onmousewheel = qodefScroll.preventDefaultValue;
			document.onkeydown = qodefScroll.keyDown;
		},
		enable: function () {
			if ( window.removeEventListener ) {
				window.removeEventListener(
					'wheel',
					qodefScroll.preventDefaultValue,
					{ passive: false }
				);
			}
			window.onmousewheel = document.onmousewheel = document.onkeydown = null;
		},
		preventDefaultValue: function ( e ) {
			e = e || window.event;
			if ( e.preventDefault ) {
				e.preventDefault();
			}
			e.returnValue = false;
		},
		keyDown: function ( e ) {
			var keys = [37, 38, 39, 40];
			for ( var i = keys.length; i--; ) {
				if ( e.keyCode === keys[i] ) {
					qodefScroll.preventDefaultValue( e );
					return;
				}
			}
		}
	};

	qodefCore.qodefScroll = qodefScroll;

	var qodefPerfectScrollbar = {
		init: function ( $holder ) {
			if ( $holder.length ) {
				qodefPerfectScrollbar.qodefInitScroll( $holder );
			}
		},
		qodefInitScroll: function ( $holder ) {
			var $defaultParams = {
				wheelSpeed: 0.6,
				suppressScrollX: true
			};

			var $ps = new PerfectScrollbar(
				$holder[0],
				$defaultParams
			);

			$( window ).resize(
				function () {
					$ps.update();
				}
			);
		}
	};

	qodefCore.qodefPerfectScrollbar = qodefPerfectScrollbar;

	var qodefInlinePageStyle = {
		init: function () {
			this.holder = $( '#leroux-core-page-inline-style' );

			if ( this.holder.length ) {
				var style = this.holder.data( 'style' );

				if ( style.length ) {
					$( 'head' ).append( '<style type="text/css">' + style + '</style>' );
				}
			}
		}
	};

	/**
	 * Init parallax item
	 */
	var qodefParallaxItem = {
		init: function () {
			var $items = $( '.qodef-parallax-item' );

			if ( $items.length ) {
				$items.each(
					function () {
						var $currentItem = $( this ),
							$y           = Math.floor( Math.random() * (-100 - (-25)) + (-25) );

						if ( $currentItem.hasClass( 'qodef-grid-item' ) ) {
							$currentItem.children( '.qodef-e-inner' ).attr(
								'data-parallax',
								'{"y": ' + $y + ', "smoothness": ' + '30' + '}'
							);
						} else {
							$currentItem.attr(
								'data-parallax',
								'{"y": ' + $y + ', "smoothness": ' + '30' + '}'
							);
						}
					}
				);
			}

			qodefParallaxItem.initParallax();
		},
		initParallax: function () {
			var parallaxInstances = $( '[data-parallax]' );

			if ( parallaxInstances.length && ! qodefCore.html.hasClass( 'touchevents' ) && typeof ParallaxScroll === 'object' ) {
				ParallaxScroll.init(); //initialization removed from plugin js file to have it run only on non-touch devices
			}
		},
	};

	qodefCore.qodefParallaxItem = qodefParallaxItem;

	/**
	 * Init animation on appear
	 */
	var qodefAppear = {
		init: function () {
			this.holder = $( '.qodef--has-appear:not(.qodef--appeared), .qodef--custom-appear:not(.qodef--appeared)' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						var holder      = $( this ),
							randomNum   = gsap.utils.random(
								10,
								500,
								100
							),
							appearDelay = $( this ).attr( 'data-appear-delay' );

						appearDelay = appearDelay ? appearDelay : randomNum;

						qodefCore.qodefIsInViewport.check(
							holder,
							() => {
								qodef.qodefWaitForImages.check(
									holder,
									function () {
										setTimeout(
											function () {
												holder.addClass( 'qodef--appeared' );
											},
											appearDelay
										);
									}
								);
							}
						);
					}
				);
			}
		},
	};

	qodefCore.qodefAppear = qodefAppear;

	/**
	 * Init svg path draw animation
	 */
	var qodefDrawSvg = {
		init: function () {
			this.holder = $( '.qodef--has-svg-appear, .qodef-thumbnail-slider .qodef-m-thumb-image, .qodef-counter.qodef-layout--simple' );

			if ( this.holder.length ) {
				gsap.registerPlugin( DrawSVGPlugin );

				this.holder.each(
					function () {
						let randomDelay = gsap.utils.random(
							0,
							.8,
							.15
						);

						// randomDelay = 0;

						qodefDrawSvg.initItem(
							$( this ),
							randomDelay
						);
					}
				);
			}
		},
		initItem: function ( $holder, delay = 0 ) {

			let tl = qodefDrawSvg.initDraw(
				$holder,
				delay
			);

			qodefCore.qodefIsInViewport.check(
				$holder,
				function () {
					tl.play( 0 );
				},
			);
		},
		initDraw: function ( $holder, delay, animDuration = .8 ) {
			let $svg        = $holder.find( 'svg' ),
				$paths      = $svg.find( 'path' ),
				$otherElems = $svg.find( 'ellipse, line, circle, rect' ),
				lengths     = [];

			let tl = gsap.timeline(
				{
					paused: true,
					onStart: () => {
						$holder.addClass( 'qodef--appeared' );
					},
					delay: delay,
				}
			);

			tl
			.from(
				$otherElems,
				{
					opacity: 0,
					scale: .7,
					duration: .5,
					stagger: .2,
				}
			);

			gsap.set(
				$paths,
				{
					opacity: 0,
				},
			);

			if ( $paths.length ) {
				$paths.each(
					function ( i, e ) {
						lengths[i] = Math.ceil( e.getTotalLength() );
					}
				);
			}

			let maxLenght = Math.max( ...lengths );

			if ( $paths.length ) {
				$paths.each(
					function ( i, $path ) {

						let childTl = gsap.timeline();

						let modifiedDuration = lengths[i] / maxLenght < .5 ? animDuration * .4 : animDuration;

						childTl
						.fromTo(
							$path,
							{
								drawSVG: '50% 50%',
							},
							{
								drawSVG: '100%',
								ease: 'power3.inOut',
								duration: modifiedDuration,
							}
						)
						//hide gsap stroke calc bug
						.fromTo(
							$path,
							{
								opacity: 0,
							},
							{
								opacity: 1,
								duration: .2,
							},
							`<.2`
						);

						tl.add(
							childTl,
							`${i * .2}`
						);
					}
				);
			}

			return tl;
		},
	};

	qodefCore.qodefDrawSvg = qodefDrawSvg;

	/**
	 * Init svg path draw animation
	 */
	var qodefBackgroundOverlay = {
		init: function () {
			this.holder = $( '.qodef--bg-overlay-fade-out, .qodef--bg-overlay-fade-in' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {

						qodefBackgroundOverlay.initItem( $( this ) );
					}
				);
			}

			$( window ).on(
				'elementor/frontend/init',
				() => {
					setTimeout(
						() => {
							qodefBackgroundOverlay.init();
						},
						5000
					);
				}
			);

		},
		initItem: function ( $holder ) {

			let $overlay      = $holder.find( '.elementor-background-overlay' )[0],
				shouldFadeOut = $holder.hasClass( 'qodef--bg-overlay-fade-out' ),
				startPosition = 'top bottom',
				endPosition   = '+=80%';

			let holderTopPosition = $holder.offset().top,
				pageHeight        = $( document ).height(),
				isOnPageTop       = holderTopPosition < qodefCore.windowHeight,
				isOnPageBottom    = holderTopPosition > pageHeight - qodefCore.windowHeight;

			if ( isOnPageTop ) {
				startPosition = 'top top';
			}

			if ( isOnPageBottom ) {
				startPosition = 'top bottom';
				endPosition   = 'max';
			}

			var tl = gsap.timeline(
				{
					paused: true,
					scrollTrigger: {
						trigger: $holder,
						scrub: 1.3,
						start: startPosition,
						end: endPosition,
						// markers: true,//only used for development
					}
				}
			);

			if ( shouldFadeOut ) {
				tl
				.to(
					$overlay,
					{
						opacity: 0,
					},
				);
			} else {
				let startOpacity = $( $overlay ).css( 'opacity' );

				tl
				.fromTo(
					$overlay,
					{
						opacity: 0,
					},
					{
						opacity: startOpacity,
					},
				);
			}
		},
	};

	qodefCore.qodefBackgroundOverlay = qodefBackgroundOverlay;

	/**
	 * Init Svg Particles
	 */
	var qodefParticles = {
		init: function () {
			this.holder = $( '.qodef--particles-holder' );

			if ( this.holder.length && ! qodefCore.html.hasClass( 'touchevents' ) ) {
				this.holder.each(
					function () {
						let $thisHolder = $( this );

						qodefParticles.checkHTML( $thisHolder );
					}
				);
			}
		},
		checkHTML: function ( $holder ) {

			let $svg = '<svg class="qodef--particles-svg" xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="0 0 100 100">\n' +
				'\t<g class="qodef-group">\n' +
				'\t\t<path d="m 131.6 148.4 l 16.8 -2.8 l -8.4 19.6 l -8.4 -8.4 z"></path>\n' +
				'\t\t<path d="m 188 212 l 24 -4 l -12 28 l -12 -12 z"></path>\n' +
				'\t\t<path d="m 94 106 l 12 -2 l -6 14 l -6 -6 z"></path>\n' +
				'\t</g>\n' +
				'\t<g class="qodef-group">\n' +
				'\t\t<path d="m 94 106 l 12 -2 l -6 14 l -6 -6 z"></path>\n' +
				'\t\t<path d="m 188 212 l 24 -4 l -12 28 l -12 -12 z"></path>\n' +
				'\t\t<path d="m 131.6 148.4 l 16.8 -2.8 l -8.4 19.6 l -8.4 -8.4 z"></path>\n' +
				'\t</g>\n' +
				'\t<g class="qodef-group">\n' +
				'\t\t<path d="m 188 212 l 24 -4 l -12 28 l -12 -12 z"></path>\n' +
				'\t\t<path d="m 131.6 148.4 l 16.8 -2.8 l -8.4 19.6 l -8.4 -8.4 z"></path>\n' +
				'\t\t<path d="m 94 106 l 12 -2 l -6 14 l -6 -6 z"></path>\n' +
				'\t</g>\n' +
				'\t<g class="qodef-group">\n' +
				'\t\t<path d="m 131.6 148.4 l 16.8 -2.8 l -8.4 19.6 l -8.4 -8.4 z"></path>\n' +
				'\t\t<path d="m 188 212 l 24 -4 l -12 28 l -12 -12 z"></path>\n' +
				'\t\t<path d="m 94 106 l 12 -2 l -6 14 l -6 -6 z"></path>\n' +
				'\t</g>\n' +
				'\t<g class="qodef-group">\n' +
				'\t\t<path d="m 131.6 148.4 l 16.8 -2.8 l -8.4 19.6 l -8.4 -8.4 z"></path>\n' +
				'\t\t<path d="m 188 212 l 24 -4 l -12 28 l -12 -12 z"></path>\n' +
				'\t\t<path d="m 94 106 l 12 -2 l -6 14 l -6 -6 z"></path>\n' +
				'\t</g>\n' +
				'\t<g class="qodef-group">\n' +
				'\t\t<path d="m 131.6 148.4 l 16.8 -2.8 l -8.4 19.6 l -8.4 -8.4 z"></path>\n' +
				'\t\t<path d="m 188 212 l 24 -4 l -12 28 l -12 -12 z"></path>\n' +
				'\t\t<path d="m 94 106 l 12 -2 l -6 14 l -6 -6 z"></path>\n' +
				'\t</g>\n' +
				'\t<g class="qodef-group">\n' +
				'\t\t<path d="m 131.6 148.4 l 16.8 -2.8 l -8.4 19.6 l -8.4 -8.4 z"></path>\n' +
				'\t\t<path d="m 188 212 l 24 -4 l -12 28 l -12 -12 z"></path>\n' +
				'\t\t<path d="m 94 106 l 12 -2 l -6 14 l -6 -6 z"></path>\n' +
				'\t</g>\n' +
				'</svg>';

			if ( ! $( '.qodef--particles-svg' ).length ) {
				$holder.append( $svg );
			}

			qodefParticles.initEffect( $holder );
		},
		initEffect: function ( $holder, isInPreloader = false) {
			let $svg         = $holder.find( 'svg' ),
				paths        = $svg.find( 'path' ),
				groups       = $svg.find( '.qodef-group' ),
				baseDuration = 20,
				modifier     = isInPreloader ? 3 : 2.2,
				revHolder = $holder.closest('rs-module');

			let tl = gsap.timeline(
				{
					paused: true,
					onStart: () => {
						$holder.addClass( 'qodef--init' );
					},
				}
			);

			var selectedRandom = gsap.utils.random(
				[-35, 15, -20, 44, -27, 32, -18, 7, -21, 25, 47, -32, 14, -38, 29, -23, 9, -33, 30, -40, 36, -28, 22, -45, -18, 21, -29, 38, -26, 10, 27, -34, 17, -31, 11, 34, -37, 40, -30, 24, -41, 42, -39, 28, 37, -36, 23, -42, 39, -25],
				true
			);

			paths.each(
				( i, e ) => {
					let randomOpacity = gsap.utils.random( [.25, .5, .75, 1, .9, .85, .92, .94, .3, .5] );

					let xRand      = selectedRandom(),
						yRand      = selectedRandom(),
						rotateRand = selectedRandom() * 5;

					$( e ).css(
						{
							'--qode-opacity': randomOpacity,
							'transform': `translateX(${xRand * modifier}vW) translateY(${yRand * modifier}vH) rotate(${rotateRand}deg)`,
						}
					);
				}
			);

			groups.each(
				( i, e ) => {
					let xRand = selectedRandom(),
						yRand = selectedRandom();

					$( e ).css(
						{
							'transform': `translateX(${xRand * modifier}vW) translateY(${yRand * modifier}vH)`,
						}
					);
				}
			);

			tl
			.from(
				paths,
				{
					'--qode-opacity': 0,
					duration: 1,
					stagger: {
						amount: 3
					},
				},
			)
			.to(
				groups,
				{
					x: () => {
						let moveXRandom = selectedRandom();

						return `${moveXRandom * qodefCore.windowWidth * .01}`;
					},
					y: () => {
						let moveYRandom = selectedRandom();

						return `${moveYRandom * qodefCore.windowHeight * .01}`;
					},
					ease: 'none',
					duration: baseDuration,
				},
				'<'
			)
			.from(
				paths,
				{
					x: () => {
						let moveXRandom = selectedRandom();

						return `${moveXRandom * qodefCore.windowWidth * .01}`;
					},
					y: () => {
						let moveYRandom = selectedRandom();

						return `${moveYRandom * qodefCore.windowHeight * .01}`;
					},
					ease: 'none',
					yoyo: true,
					repeat: -1,
					duration: () => {
						return baseDuration * .75;
					},
				},
				'<'
			);

			if ( !isInPreloader && revHolder.length == 0) {
				qodefCore.qodefIsInViewport.check(
					$holder,
					function () {
						tl.play();
					},
					false,
					function () {
						tl.pause();
					}
				);
			} else if(!isInPreloader && revHolder.length !== 0){

				qodefCore.qodefIsInViewport.check(
					revHolder,
					function () {
						tl.play();
					},
					false,
					function () {
						tl.pause();
					}
				);
			} else {

				return tl;

			}
		},
	};

	qodefCore.qodefParticles = qodefParticles;

	/**
	 * Init Revolution Slider Adjustments
	 */
	var qodefRevolutioinSlider = {
		init: function () {
			this.holder = $( 'rs-module' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						let revapi = $( this );

						qodefRevolutioinSlider.initItem( revapi );
					}
				);
			}
		},
		initItem: function ( revapi ) {
			revapi.bind(
				'revolution.slide.onloaded',
				function () {
					qodefRevolutioinSlider.fixVideoBackgroundSource( revapi );
					qodefRevolutioinSlider.initParticles( revapi );
					qodefRevolutioinSlider.initCustomProgressData( revapi );
				}
			);
		},
		fixVideoBackgroundSource: function ( revapi ) {
			let videoBackground = revapi.find( 'rs-bgvideo video' ),
				isSafari        = qodefCore.body.hasClass( 'qodef-browser--safari' );

			if ( videoBackground.length && isSafari ) {
				let videoBackgroundSource     = videoBackground.find( 'source' ),
					videoBackgroundSourceSrc  = videoBackgroundSource[0].src,
					videoBackgroundSourceType = videoBackgroundSource[0].type;

				setTimeout(
					() => {
						videoBackground[0].src        = `${videoBackgroundSourceSrc}`;
						videoBackground.get( 0 ).type = `${videoBackgroundSourceType}`;
					},
					150
				);
			}
		},
		initParticles: function ( revapi ) {
			let particlesHolder = revapi.find( '.qodef--particles-holder-rev' );

			if ( particlesHolder.length && ! qodefCore.html.hasClass( 'touchevents' ) ) {

				particlesHolder.each(
					function () {
						let $thisHolder = $( this );

						qodefCore.qodefParticles.checkHTML( $thisHolder );
					}
				);
			}
		},
		initCustomProgressData: function ( revapi ) {
			let $progressBar = revapi.find( 'rs-progress' );

			if( $progressBar.length ) {

				$progressBar.append('<span class="qodef-progress-number"></span>');
				$progressBar.append('<div class="qodef-progress-data"><div class="qodef-progress-buttons"><a href="#" class="qodef-progress-button qodef-progress-button-one"></a><a href="#" class="qodef-progress-button qodef-progress-button-two"></a></div><div class="qodef-progress-title"></div></div>');

				var api = revapi.bind("revolution.slide.onbeforeswap",function (e,data) {
					var slides = api.find('rs-slide'),
						slideNumber = data.nextslide.data('originalindex'),
						progressBar = api.find('rs-progress'),
						slideNumberHolder = api.find('.qodef-progress-number'),
						slideButtonOneHolder = api.find( '.qodef-progress-button-one' ),
						slideButtonTwoHolder = api.find( '.qodef-progress-button-two' ),
						slideTitleHolder = api.find( '.qodef-progress-title' ),
						activeSlide = slides.eq(slideNumber - 1);


					if( slideNumber < 10 ) {
						slideNumber = '0' + (slideNumber);
					} else {
						slideNumber = slideNumber;
					}

					slideNumber += '.';

					slideNumberHolder.html( slideNumber );

					if( activeSlide.length ) {
						if( 'undefined' !== typeof activeSlide.data('button-one') ) {
							slideButtonOneHolder.html( activeSlide.data('button-one') )
						}

						if( 'undefined' !== typeof activeSlide.data('button-two') ) {
							slideButtonTwoHolder.html( activeSlide.data('button-two') )
						}

						if( 'undefined' !== typeof activeSlide.data('custom-title') ) {
							slideTitleHolder.html( activeSlide.data('custom-title') )
						}
					}

					progressBar.addClass('qodef--loaded');
				});
			};
		},
	};

	qodefCore.qodefRevolutioinSlider = qodefRevolutioinSlider;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefBackToTop.init();
		}
	);

	var qodefBackToTop = {
		init: function () {
			this.holder = $( '#qodef-back-to-top' );

			if ( this.holder.length ) {
				// Scroll To Top
				this.holder.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefBackToTop.animateScrollToTop();
					}
				);

				qodefBackToTop.showHideBackToTop();
			}
		},
		animateScrollToTop: function () {
			var startPos = qodef.scroll,
				newPos   = qodef.scroll,
				step     = .9,
				animationFrameId;

			var startAnimation = function () {
				if ( newPos === 0 ) {
					return;
				}

				newPos < 0.0001 ? newPos = 0 : null;

				var ease = qodefBackToTop.easingFunction( (startPos - newPos) / startPos );
				$( 'html, body' ).scrollTop( startPos - (startPos - newPos) * ease );
				newPos = newPos * step;

				animationFrameId = requestAnimationFrame( startAnimation );
			};

			startAnimation();

			$( window ).one(
				'wheel touchstart',
				function () {
					cancelAnimationFrame( animationFrameId );
				}
			);
		},
		easingFunction: function ( n ) {
			return 0 == n ? 0 : Math.pow( 1024, n - 1 );
		},
		showHideBackToTop: function () {
			$( window ).scroll(
				function () {
					var $thisItem = $( this ),
						b         = $thisItem.scrollTop(),
						c         = $thisItem.height(),
						d;

					if ( b > 0 ) {
						d = b + c / 2;
					} else {
						d = 1;
					}

					if ( d < 1e3 ) {
						qodefBackToTop.addClass( 'off' );
					} else {
						qodefBackToTop.addClass( 'on' );
					}
				}
			);
		},
		addClass: function ( a ) {
			this.holder.removeClass( 'qodef--off qodef--on' );

			if ( a === 'on' ) {
				this.holder.addClass( 'qodef--on' );
			} else {
				this.holder.addClass( 'qodef--off' );
			}
		}
	};

})( jQuery );

(function ($) {
	"use strict";

	$( window ).on(
		'load',
		function () {
			qodefBackgroundText.init();
		}
	);

	$( window ).resize(
		function () {
			qodefBackgroundText.init();
		}
	);

	var qodefBackgroundText = {
		init                    : function () {
			var $holder = $( '.qodef-background-text' );

			if ($holder.length) {
				$holder.each(
					function () {
						qodefBackgroundText.responsiveOutputHandler( $( this ) );
					}
				);
			}
		},
		responsiveOutputHandler : function ($holder) {
			var breakpoints = {
				3840: 1441,
				1440: 1367,
				1366: 1025,
				1024: 1
			};

			$.each(
				breakpoints,
				function (max, min) {
					if (qodef.windowWidth <= max && qodef.windowWidth >= min) {
						qodefBackgroundText.generateResponsiveOutput( $holder, max );
					}
				}
			);
		},
		generateResponsiveOutput: function ($holder, width) {
			var $textHolder = $holder.find( '.qodef-m-background-text' );

			if ($textHolder.length) {
				$textHolder.css(
					{
						'font-size': $textHolder.data( 'size-' + width ) + 'px',
						'top'      : $textHolder.data( 'vertical-offset-' + width ) + 'px',
					}
				);
			}
		},
	};

	window.qodefBackgroundText = qodefBackgroundText;
})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefContentSide.init();
		}
	);

	var qodefContentSide = {
		init: function () {
			this.holder = $( '#qodef-content-side' );

			if ( this.holder.length ) {

				var $navMenu = this.holder.find( '.widget_nav_menu' );

				if ( $navMenu.length ) {

					var $contentInner = this.holder.find( '#qodef-content-side-inner' );

					$contentInner.append('<div class="qodef-menu-item-indicator"></div>');
					var $indicator = $contentInner.find( '.qodef-menu-item-indicator' );

					var $menuItems = $navMenu.find('li');

					if ( $menuItems.length ) {

						var firstItem =  $($menuItems[0]);
						firstItem.addClass( 'qodef-active' );

						var firstItemHeight = firstItem.outerHeight(),
							firstItemPosition = firstItem.position();

						$indicator.css({
							'height': firstItemHeight,
							'top': firstItemPosition.top
						});

						$menuItems.each(
							function () {

								var thisItem = $( this );

								var menuItemHeight = thisItem.outerHeight(),
									menuItemPosition = thisItem.position();

								thisItem.on( 'click', function () {
									$menuItems.removeClass('qodef-active');
									thisItem.addClass( 'qodef-active' );

									$indicator.css({
										'height': menuItemHeight,
										'top': menuItemPosition.top
									});
								});

								thisItem.on( 'mouseenter', function () {
									$indicator.css({
										'height': menuItemHeight,
										'top': menuItemPosition.top
									});
								});

								thisItem.on( 'mouseleave', function () {
									var activeItem = $navMenu.find('.qodef-active'),
										activeItemHeight = activeItem.outerHeight(),
										activeItemPosition = activeItem.position();

									$indicator.css({
										'height': activeItemHeight,
										'top': activeItemPosition.top
									});
								});
							}
						);
					}
				}
			}
		},
	};

})( jQuery );

(function ($) {
	'use strict';

	$(document).ready(function () {
		qodefCustomCursor.init();
	});

	$(window).on(
		'elementor/frontend/init',
		function () {
			qodefCustomCursor.init();
		}
	);

	var qodefCustomCursor = {
		cursorApended: false,
		init         : function () {
			const $dragSelectors = $('.qodef--drag-cursor');

			if ($dragSelectors.length) {
				const customCursor = qodefGlobal.vars.dragCursor;

				if (false === qodefCustomCursor.cursorApended) {
					qodefCore.html.append('<div class="qodef-m-custom-cursor qodef-m"><div class="qodef-m-custom-cursor-inner">' + customCursor + '</div></div>');
					qodefCustomCursor.cursorApended = true;
				}
				const $cursorHolder = $('.qodef-m-custom-cursor');

				if (!qodefCore.html.hasClass('touchevents')) {
					function handleMoveCursor(event) {
						$cursorHolder.css(
							{
								top : event.clientY - 60, // half of svg height
								left: event.clientX - 60, // half of svg width
							}
						);
					}

					document.addEventListener('pointermove', handleMoveCursor);

					// reset cursor selectors
					const resetCursorSelectors =
							'.qodef--drag-cursor .swiper-button-prev,' +
							'.qodef--drag-cursor .swiper-button-next,' +
							'.qodef--drag-cursor .swiper-pagination,' +
							'.qodef--drag-cursor .qodef-e-media-image a,' + // port/blog list link around image
							'.qodef--drag-cursor a:not(.woocommerce-loop-product__link),' + // product list link around image
							'.qodef--drag-cursor .qodef-e-post-link,' + // port/blog/product list link overlay
							'.qodef--drag-cursor .qodef-e-hotspot',
						$resetCursorSelectors = $(resetCursorSelectors);

					$resetCursorSelectors.css(
						{
							cursor: 'pointer',
						}
					);

					$(document).on(
						'mouseenter',
						resetCursorSelectors,
						function () {
							$cursorHolder.addClass('qodef--hide');
						}
					).on(
						'mouseleave',
						resetCursorSelectors,
						function () {
							$cursorHolder.removeClass('qodef--hide');
						}
					);

					// drag cursor selectors
					const dragSelectors = '.qodef--drag-cursor';

					$(document).on(
						'mouseenter',
						dragSelectors,
						function () {
							$cursorHolder.addClass('qodef--show');
						}
					).on(
						'mouseleave',
						dragSelectors,
						function () {
							$cursorHolder.removeClass('qodef--show');
						}
					);
				}
			}
		},
	};

	qodefCore.qodefCustomCursor = qodefCustomCursor;

})(jQuery);

(function ( $ ) {
	'use strict';

	$( window ).on(
		'load',
		function () {
			qodefUncoverFooter.init();
		}
	);

	var qodefUncoverFooter = {
		holder: '',
		init: function () {
			this.holder = $( '#qodef-page-footer.qodef--uncover' );

			if ( this.holder.length && ! qodefCore.html.hasClass( 'touchevents' ) ) {
				qodefUncoverFooter.addClass();
				qodefUncoverFooter.setHeight( this.holder );

				$( window ).resize(
					function () {
						qodefUncoverFooter.setHeight( qodefUncoverFooter.holder );
					}
				);
			}
		},
		setHeight: function ( $holder ) {
			$holder.css( 'height', 'auto' );

			var footerHeight = $holder.outerHeight();

			if ( footerHeight > 0 ) {
				$( '#qodef-page-outer' ).css(
					{
						'margin-bottom': footerHeight,
						'background-color': qodefCore.body.css( 'backgroundColor' )
					}
				);

				$holder.css( 'height', footerHeight );
			}
		},
		addClass: function () {
			qodefCore.body.addClass( 'qodef-page-footer--uncover' );
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefFullscreenMenu.init();
		}
	);

	$( window ).on(
		'resize',
		function () {
			qodefFullscreenMenu.handleHeaderWidth( 'resize' );
		}
	);

	var qodefFullscreenMenu = {
		init: function () {
			var $fullscreenMenuOpener = $( 'a.qodef-fullscreen-menu-opener' ),
				$menuItems            = $( '#qodef-fullscreen-area nav ul li a' );

			if ( $fullscreenMenuOpener.length ) {
				// prevent header changing width when fullscreen menu is open
				qodefFullscreenMenu.handleHeaderWidth( 'init' );

				// open popup menu
				$fullscreenMenuOpener.on(
					'click',
					function ( e ) {
						e.preventDefault();
						var $thisOpener = $( this );

						if ( ! qodefCore.body.hasClass( 'qodef-fullscreen-menu--opened' ) ) {
							qodefFullscreenMenu.openFullscreen( $thisOpener );

							$( document ).keyup(
								function ( e ) {
									if ( e.keyCode === 27 ) {
										qodefFullscreenMenu.closeFullscreen( $thisOpener );
									}
								}
							);
						} else {
							qodefFullscreenMenu.closeFullscreen( $thisOpener );
						}
					}
				);

				// open dropdowns
				$menuItems.on(
					'tap click',
					function ( e ) {
						var $thisItem = $( this );

						if ( $thisItem.parent().hasClass( 'menu-item-has-children' ) ) {
							e.preventDefault();
							qodefFullscreenMenu.clickItemWithChild( $thisItem );
						} else if ( $thisItem.attr( 'href' ) !== 'http://#' && $thisItem.attr( 'href' ) !== '#' ) {
							qodefFullscreenMenu.closeFullscreen( $fullscreenMenuOpener );
						}
					}
				);
			}
		},
		openFullscreen: function ( $opener ) {
			$opener.addClass( 'qodef--opened' );
			qodefCore.body.removeClass( 'qodef-fullscreen-menu-animate--out' ).addClass( 'qodef-fullscreen-menu--opened qodef-fullscreen-menu-animate--in' );
			qodefCore.qodefScroll.disable();
		},
		closeFullscreen: function ( $opener ) {
			$opener.removeClass( 'qodef--opened' );
			qodefCore.body.removeClass( 'qodef-fullscreen-menu--opened qodef-fullscreen-menu-animate--in' ).addClass( 'qodef-fullscreen-menu-animate--out' );
			qodefCore.qodefScroll.enable();
			$( 'nav.qodef-fullscreen-menu ul.sub_menu' ).slideUp( 200 );
		},
		clickItemWithChild: function ( thisItem ) {
			var $thisItemParent  = thisItem.parent(),
				$thisItemSubMenu = $thisItemParent.find( '.sub-menu' ).first();

			if ( $thisItemSubMenu.is( ':visible' ) ) {
				$thisItemSubMenu.slideUp( 300 );
				$thisItemParent.removeClass( 'qodef--opened' );
			} else {
				$thisItemSubMenu.slideDown( 300 );
				$thisItemParent.addClass( 'qodef--opened' ).siblings().find( '.sub-menu' ).slideUp( 400 );
			}
		},
		handleHeaderWidth: function ( state ) {
			var $header               = $( '#qodef-page-header' );
			var $fullscreenMenuOpener = $( 'a.qodef-fullscreen-menu-opener' );

			if ( $header.length && $fullscreenMenuOpener.length ) {
				// if desktop device
				if ( qodefCore.windowWidth > 1024 ) {
					// if page height is greater than window height, scroll bar is visible
					if ( qodefCore.body.height() > qodefCore.windowHeight ) {
						// on resize reset previously set inline width
						if ( 'resize' === state ) {
							$header.css( { 'width': '' } );
						}
						$header.width( $header.width() );
					}
				} else {
					// reset previously set inline width
					$header.css( { 'width': '' } );
				}
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefHeaderScrollAppearance.init();
		}
	);

	var qodefHeaderScrollAppearance = {
		appearanceType: function () {
			return qodefCore.body.attr( 'class' ).indexOf( 'qodef-header-appearance--' ) !== -1 ? qodefCore.body.attr( 'class' ).match( /qodef-header-appearance--([\w]+)/ )[1] : '';
		},
		init: function () {
			var appearanceType = this.appearanceType();

			if ( appearanceType !== '' && appearanceType !== 'none' ) {
				qodefCore[appearanceType + 'HeaderAppearance']();
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
	    function () {
            qodefMobileHeaderAppearance.init();
        }
	);

	/*
	 **	Init mobile header functionality
	 */
	var qodefMobileHeaderAppearance = {
		init: function () {
			if ( qodefCore.body.hasClass( 'qodef-mobile-header-appearance--sticky' ) ) {

				var docYScroll1   = qodefCore.scroll,
					displayAmount = qodefGlobal.vars.mobileHeaderHeight + qodefGlobal.vars.adminBarHeight,
					$pageOuter    = $( '#qodef-page-outer' );

				qodefMobileHeaderAppearance.showHideMobileHeader( docYScroll1, displayAmount, $pageOuter );

				$( window ).scroll(
				    function () {
                        qodefMobileHeaderAppearance.showHideMobileHeader( docYScroll1, displayAmount, $pageOuter );
                        docYScroll1 = qodefCore.scroll;
                    }
				);

				$( window ).resize(
				    function () {
                        $pageOuter.css( 'padding-top', 0 );
                        qodefMobileHeaderAppearance.showHideMobileHeader( docYScroll1, displayAmount, $pageOuter );
                    }
				);
			}
		},
		showHideMobileHeader: function ( docYScroll1, displayAmount, $pageOuter ) {
			if ( qodefCore.windowWidth <= 1024 ) {
				if ( qodefCore.scroll > displayAmount * 2 ) {
					//set header to be fixed
					qodefCore.body.addClass( 'qodef-mobile-header--sticky' );

					//add transition to it
					setTimeout(
						function () {
							qodefCore.body.addClass( 'qodef-mobile-header--sticky-animation' );
						},
						300
					); //300 is duration of sticky header animation

					//add padding to content so there is no 'jumping'
					$pageOuter.css( 'padding-top', qodefGlobal.vars.mobileHeaderHeight );
				} else {
					//unset fixed header
					qodefCore.body.removeClass( 'qodef-mobile-header--sticky' );

					//remove transition
					setTimeout(
						function () {
							qodefCore.body.removeClass( 'qodef-mobile-header--sticky-animation' );
						},
						300
					); //300 is duration of sticky header animation

					//remove padding from content since header is not fixed anymore
					$pageOuter.css( 'padding-top', 0 );
				}

				if ( (qodefCore.scroll > docYScroll1 && qodefCore.scroll > displayAmount) || (qodefCore.scroll < displayAmount * 3) ) {
					//show sticky header
					qodefCore.body.removeClass( 'qodef-mobile-header--sticky-display' );
				} else {
					//hide sticky header
					qodefCore.body.addClass( 'qodef-mobile-header--sticky-display' );
				}
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefNavMenu.init();
		}
	);

	var qodefNavMenu = {
		init: function () {
			qodefNavMenu.dropdownBehavior();
			qodefNavMenu.wideDropdownPosition();
			qodefNavMenu.dropdownPosition();
		},
		dropdownBehavior: function () {
			var $menuItems = $( '.qodef-header-navigation > ul > li' );

			$menuItems.each(
				function () {
					var $thisItem = $( this );

					if ( $thisItem.find( '.qodef-drop-down-second' ).length ) {
						qodef.qodefWaitForImages.check(
							$thisItem,
							function () {
								var $dropdownHolder      = $thisItem.find( '.qodef-drop-down-second' ),
									$dropdownMenuItem    = $dropdownHolder.find( '.qodef-drop-down-second-inner ul' ),
									dropDownHolderHeight = $dropdownMenuItem.outerHeight();

								if ( navigator.userAgent.match( /(iPod|iPhone|iPad)/ ) ) {
									$thisItem.on(
										'touchstart mouseenter',
										function () {
											$dropdownHolder.css(
												{
													'height': dropDownHolderHeight,
													'overflow': 'visible',
													'visibility': 'visible',
													'opacity': '1',
												}
											);
										}
									).on(
										'mouseleave',
										function () {
											$dropdownHolder.css(
												{
													'height': '0px',
													'overflow': 'hidden',
													'visibility': 'hidden',
													'opacity': '0',
												}
											);
										}
									);
								} else {
									if ( qodefCore.body.hasClass( 'qodef-drop-down-second--animate-height' ) ) {
										var animateConfig = {
											interval: 0,
											over: function () {
												setTimeout(
													function () {
														$dropdownHolder.addClass( 'qodef-drop-down--start' ).css(
															{
																'visibility': 'visible',
																'height': '0',
																'opacity': '1',
															}
														);
														$dropdownHolder.stop().animate(
															{
																'height': dropDownHolderHeight,
															},
															400,
															'linear',
															function () {
																$dropdownHolder.css( 'overflow', 'visible' );
															}
														);
													},
													100
												);
											},
											timeout: 100,
											out: function () {
												$dropdownHolder.stop().animate(
													{
														'height': '0',
														'opacity': 0,
													},
													100,
													function () {
														$dropdownHolder.css(
															{
																'overflow': 'hidden',
																'visibility': 'hidden',
															}
														);
													}
												);

												$dropdownHolder.removeClass( 'qodef-drop-down--start' );
											}
										};

										$thisItem.hoverIntent( animateConfig );
									} else {
										var config = {
											interval: 0,
											over: function () {
												setTimeout(
													function () {
														$dropdownHolder.addClass( 'qodef-drop-down--start' ).stop().css( { 'height': dropDownHolderHeight } );
													},
													150
												);
											},
											timeout: 150,
											out: function () {
												$dropdownHolder.stop().css( { 'height': '0' } ).removeClass( 'qodef-drop-down--start' );
											}
										};

										$thisItem.hoverIntent( config );
									}
								}
							}
						);
					}
				}
			);
		},
		wideDropdownPosition: function () {
			var $menuItems = $( '.qodef-header-navigation > ul > li.qodef-menu-item--wide' );

			if ( $menuItems.length ) {
				$menuItems.each(
					function () {
						var $menuItem        = $( this );
						var $menuItemSubMenu = $menuItem.find( '.qodef-drop-down-second' );

						if ( $menuItemSubMenu.length ) {
							$menuItemSubMenu.css( 'left', 0 );

							var leftPosition = $menuItemSubMenu.offset().left;

							if ( qodefCore.body.hasClass( 'qodef--boxed' ) ) {
								//boxed layout case
								var boxedWidth = $( '.qodef--boxed #qodef-page-wrapper' ).outerWidth();
								leftPosition   = leftPosition - (qodefCore.windowWidth - boxedWidth) / 2;
								$menuItemSubMenu.css( { 'left': -leftPosition, 'width': boxedWidth } );

							} else if ( qodefCore.body.hasClass( 'qodef-drop-down-second--full-width' ) ) {
								//wide dropdown full width case
								$menuItemSubMenu.css( { 'left': -leftPosition, 'width': qodefCore.windowWidth } );
							} else {
								//wide dropdown in grid case
								$menuItemSubMenu.css( { 'left': -leftPosition + (qodefCore.windowWidth - $menuItemSubMenu.width()) / 2 } );
							}
						}
					}
				);
			}
		},
		dropdownPosition: function () {
			var $menuItems = $( '.qodef-header-navigation > ul > li.qodef-menu-item--narrow.menu-item-has-children' );

			if ( $menuItems.length ) {
				$menuItems.each(
					function () {
						var $thisItem         = $( this ),
							menuItemPosition  = $thisItem.offset().left,
							$dropdownHolder   = $thisItem.find( '.qodef-drop-down-second' ),
							$dropdownMenuItem = $dropdownHolder.find( '.qodef-drop-down-second-inner ul' ),
							dropdownMenuWidth = $dropdownMenuItem.outerWidth(),
							menuItemFromLeft  = $( window ).width() - menuItemPosition;

						if ( qodef.body.hasClass( 'qodef--boxed' ) ) {
							//boxed layout case
							var boxedWidth   = $( '.qodef--boxed #qodef-page-wrapper' ).outerWidth();
							menuItemFromLeft = boxedWidth - menuItemPosition;
						}

						var dropDownMenuFromLeft;

						if ( $thisItem.find( 'li.menu-item-has-children' ).length > 0 ) {
							dropDownMenuFromLeft = menuItemFromLeft - dropdownMenuWidth;
						}

						$dropdownHolder.removeClass( 'qodef-drop-down--right' );
						$dropdownMenuItem.removeClass( 'qodef-drop-down--right' );
						if ( menuItemFromLeft < dropdownMenuWidth || dropDownMenuFromLeft < dropdownMenuWidth ) {
							$dropdownHolder.addClass( 'qodef-drop-down--right' );
							$dropdownMenuItem.addClass( 'qodef-drop-down--right' );
						}
					}
				);
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( window ).on(
		'load',
		function () {
			qodefParallaxBackground.init();
		}
	);

	/**
	 * Init global parallax background functionality
	 */
	var qodefParallaxBackground = {
		init: function ( settings ) {
			this.$sections = $( '.qodef-parallax' );

			// Allow overriding the default config
			$.extend(
				this.$sections,
				settings
			);

			if ( this.$sections.length ) {
				this.$sections.each(
					function () {
						if (!$( this ).hasClass('qodef-parallax--init')){//added from elementor js
							qodefParallaxBackground.ready($( this ));
						}
					}
				);
			}
		},
		ready: function ( $section ) {
			qodef.qodefWaitForImages.check(
				$section,
				function () {
					qodefParallaxBackground.animateParallax( $section );
				}
			);
		},
		animateParallax: function ( $section ) {
			var isInTitleArea = $section.closest('.qodef-page-title').length;
			var $parallaxHolder = isInTitleArea ? $section.find('.qodef-m-inner') : $section.find('.qodef-parallax-row-holder'),
				$parallaxHolderInner = $section.find('.qodef-parallax-img-holder');

			if (! qodefCore.html.hasClass( 'touchevents' )){

				var maxY =  $parallaxHolderInner.outerHeight() - $parallaxHolder.outerHeight();

				gsap.registerPlugin(ScrollTrigger);

				gsap.to(
					$parallaxHolderInner,
					{
						opacity: 1,
					}
				)

				const tl = gsap.timeline({
					scrollTrigger: {
						trigger: $section,
						scrub: 1.5,
						start: () => {
							if (isInTitleArea){
								return "top top"
							} else {
								return "top bottom"
							}
						},
						end: () => {
							return "bottom top";
						},
						// markers: true,
					}
				});

				tl
				.to(
					$parallaxHolderInner,
					{
						y: -maxY,
					}
				)
			}
		}
	};

	qodefCore.qodefParallaxBackground = qodefParallaxBackground;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefReview.init();
		}
	);

	var qodefReview = {
		init: function () {
			var ratingHolder = $( '#qodef-page-comments-form .qodef-rating-inner' );

			var addActive = function ( stars, ratingValue ) {
				for ( var i = 0; i < stars.length; i++ ) {
					var star = stars[i];

					if ( i < ratingValue ) {
						$( star ).addClass( 'active' );
					} else {
						$( star ).removeClass( 'active' );
					}
				}
			};

			ratingHolder.each(
				function () {
					var thisHolder  = $( this ),
						ratingInput = thisHolder.find( '.qodef-rating' ),
						ratingValue = ratingInput.val(),
						stars       = thisHolder.find( '.qodef-star-rating' );

					addActive( stars, ratingValue );

					stars.on(
						'click',
						function () {
							ratingInput.val( $( this ).data( 'value' ) ).trigger( 'change' );
						}
					);

					ratingInput.change(
						function () {
							ratingValue = ratingInput.val();

							addActive( stars, ratingValue );
						}
					);
				}
			);
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSideArea.init();
		}
	);

	var qodefSideArea = {
		init: function () {
			var $sideAreaOpener = $( 'a.qodef-side-area-opener' ),
				$sideAreaClose  = $( '#qodef-side-area-close' ),
				$sideArea       = $( '#qodef-side-area' );

			qodefSideArea.openerHoverColor( $sideAreaOpener );

			// Open Side Area
			$sideAreaOpener.on(
				'click',
				function ( e ) {
					e.preventDefault();

					if ( ! qodefCore.body.hasClass( 'qodef-side-area--opened' ) ) {
						qodefSideArea.openSideArea();

						$( document ).keyup(
							function ( e ) {
								if ( e.keyCode === 27 ) {
									qodefSideArea.closeSideArea();
								}
							}
						);
					} else {
						qodefSideArea.closeSideArea();
					}
				}
			);

			$sideAreaClose.on(
				'click',
				function ( e ) {
					e.preventDefault();
					qodefSideArea.closeSideArea();
				}
			);

			if ( $sideArea.length && typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
				qodefCore.qodefPerfectScrollbar.init( $sideArea );
			}
		},
		openSideArea: function () {
			var $wrapper      = $( '#qodef-page-wrapper' );
			var currentScroll = $( window ).scrollTop();

			$( '.qodef-side-area-cover' ).remove();
			$wrapper.prepend( '<div class="qodef-side-area-cover"/>' );
			qodefCore.body.removeClass( 'qodef-side-area-animate--out' ).addClass( 'qodef-side-area--opened qodef-side-area-animate--in' );

			$( '.qodef-side-area-cover' ).on(
				'click',
				function ( e ) {
					e.preventDefault();
					qodefSideArea.closeSideArea();
				}
			);

			$( window ).scroll(
				function () {
					if ( Math.abs( qodefCore.scroll - currentScroll ) > 400 ) {
						qodefSideArea.closeSideArea();
					}
				}
			);
		},
		closeSideArea: function () {
			qodefCore.body.removeClass( 'qodef-side-area--opened qodef-side-area-animate--in' ).addClass( 'qodef-side-area-animate--out' );
		},
		openerHoverColor: function ( $opener ) {
			if ( typeof $opener.data( 'hover-color' ) !== 'undefined' ) {
				var hoverColor    = $opener.data( 'hover-color' );
				var originalColor = $opener.css( 'color' );

				$opener.on(
					'mouseenter',
					function () {
						$opener.css( 'color', hoverColor );
					}
				).on(
					'mouseleave',
					function () {
						$opener.css( 'color', originalColor );
					}
				);
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function() {
			qodefSpinner.init();
		}
	);

	$( window ).on(
		'load',
		function () {
			qodefSpinner.windowLoaded = true;

			if (document.visibilityState === 'visible') {
				qodefSpinner.fadeOutLoader();
			} else {
				document.addEventListener("visibilitychange", function() {
					if (document.visibilityState === 'visible') {
						qodefSpinner.fadeOutLoader();
					}
				});
			}
		}
	);

	$( window ).on(
		'elementor/frontend/init',
		function () {
			var isEditMode = Boolean( elementorFrontend.isEditMode() );

			if ( isEditMode ) {
				qodefSpinner.init( isEditMode );
			}
		}
	);

	var qodefSpinner = {
		holder: '',
		windowLoaded: false,
		init: function ( isEditMode ) {
			this.holder = $( '#qodef-page-spinner:not(.qodef--custom-spinner):not(.qodef-layout--textual)' );

			if ( this.holder.length ) {
				qodefSpinner.animateSpinner( isEditMode );
				qodefSpinner.fadeOutAnimation();
			}
		},
		animateSpinner: function ( isEditMode ) {

			if ( isEditMode ) {
				qodefSpinner.fadeOutLoader();
			}
		},
		fadeOutLoader: function ( speed, delay, easing ) {
			var $holder = qodefSpinner.holder.length ? qodefSpinner.holder : $( '#qodef-page-spinner:not(.qodef--custom-spinner):not(.qodef-layout--textual)' );

			speed  = speed ? speed : 600;
			delay  = delay ? delay : 0;
			easing = easing ? easing : 'swing';

			$holder.delay( delay ).fadeOut( speed, easing );

			$( window ).on(
				'bind',
				'pageshow',
				function ( event ) {
					if ( event.originalEvent.persisted ) {
						$holder.fadeOut( speed, easing );
					}
				}
			);
		},
		fadeOutAnimation: function () {

			// Check for fade out animation
			if ( qodefCore.body.hasClass( 'qodef-spinner--fade-out' ) ) {
				var $pageHolder = $( '#qodef-page-wrapper' ),
					$linkItems  = $( 'a' );

				// If back button is pressed, then show content to avoid state where content is on display:none
				window.addEventListener(
					'pageshow',
					function ( event ) {
						var historyPath = event.persisted || (typeof window.performance !== 'undefined' && window.performance.navigation.type === 2);
						if ( historyPath && ! $pageHolder.is( ':visible' ) ) {
							$pageHolder.show();
						}
					}
				);

				$linkItems.on(
					'click',
					function ( e ) {
						var $clickedLink = $( this );

						if (
							e.which === 1 && // check if the left mouse button has been pressed
							$clickedLink.attr( 'href' ).indexOf( window.location.host ) >= 0 && // check if the link is to the same domain
							! $clickedLink.hasClass( 'remove' ) && // check is WooCommerce remove link
							$clickedLink.parent( '.product-remove' ).length <= 0 && // check is WooCommerce remove link
							$clickedLink.parents( '.woocommerce-product-gallery__image' ).length <= 0 && // check is product gallery link
							typeof $clickedLink.data( 'rel' ) === 'undefined' && // check pretty photo link
							typeof $clickedLink.attr( 'rel' ) === 'undefined' && // check VC pretty photo link
							! $clickedLink.hasClass( 'lightbox-active' ) && // check is lightbox plugin active
							(typeof $clickedLink.attr( 'target' ) === 'undefined' || $clickedLink.attr( 'target' ) === '_self') && // check if the link opens in the same window
							$clickedLink.attr( 'href' ).split( '#' )[0] !== window.location.href.split( '#' )[0] // check if it is an anchor aiming for a different page
						) {
							e.preventDefault();

							$pageHolder.fadeOut(
								600,
								'easeOutSine',
								function () {
									window.location = $clickedLink.attr( 'href' );
								}
							);
						}
					}
				);
			}
		}
	};

	qodefCore.qodefSpinner = qodefSpinner;

})( jQuery );

(function ($) {
    "use strict";

    // $(window).on('load',function () {
    //     qodefStickyColumn.init('init');
    // });
    //
    // $(window).resize(function () {
    //     qodefStickyColumn.init('resize');
    // });
    //
    // $( document ).on(
    //     'leroux_core_trigger_initiated_progress_bar',
    //     function () {
    //         qodefStickyColumn.init('resize');
    //     }
    // );

    var qodefStickyColumn = {
        pageOffset: '',
        scrollAmount: '',
        init: function (state) {
            var $holder = $('.qodef-sticky-column'),
                editor = $holder.hasClass('wpb_column') ? 'wp_bakery' : 'elementor';

            if ($holder.length) {
                $holder.each(function () {
                    qodefStickyColumn.calculateVars($(this), state, editor);
                });
            }
        },
        calculateVars: function ($column, state, editor) {
            var columnVars = {};

            if ('wp_bakery' === editor) {
                columnVars.$columnInner = $column.find('.vc_column-inner');
            } else {
                columnVars.$columnInner = $column.find('> .elementor-widget-wrap');
            }

            columnVars.columnTopEdgePosition = $column.offset().top;
            columnVars.columnLeftEdgePosition = $column.offset().left;
            columnVars.columnWidth = $column.outerWidth(true);
            columnVars.columnHeight = columnVars.$columnInner.outerHeight(true);

            if ('wp_bakery' === editor) {
                columnVars.$row = $column.closest('.vc_row');
            } else {
                columnVars.$row = $column.closest('.elementor-section');
            }

            columnVars.rowTopEdgePosition = columnVars.$row.offset().top;
            columnVars.rowHeight = columnVars.$row.outerHeight(true);
            columnVars.rowBottomEdgePosition = columnVars.rowTopEdgePosition + columnVars.rowHeight;
            qodefStickyColumn.scrollAmount = qodef.scroll;

            qodefStickyColumn.checkPosition(columnVars);

            $(window).scroll(function () {
                if ('init' === state) {
                    var scrollDirection = qodefStickyColumn.checkScrollDirection();
                }

                qodefStickyColumn.checkPosition(columnVars, scrollDirection);
            });
        },
        checkPosition: function (columnVars, direction) {
            if (qodef.windowWidth > 1024) {
                qodefStickyColumn.calculateOffset();

                if ((qodef.scroll + qodefStickyColumn.pageOffset) <= columnVars.columnTopEdgePosition) {
                    qodefStickyColumn.setPosition(columnVars, 'relative');
                }

                if (((qodef.scroll + qodefStickyColumn.pageOffset) >= columnVars.columnTopEdgePosition) && ((qodef.scroll + qodefStickyColumn.pageOffset + columnVars.columnHeight) < columnVars.rowBottomEdgePosition)) {
                    qodefStickyColumn.setPosition(columnVars, 'fixed', direction);
                } else if ((qodef.scroll + qodefStickyColumn.pageOffset + columnVars.columnHeight) >= columnVars.rowBottomEdgePosition) {
                    qodefStickyColumn.setPosition(columnVars, 'absolute');
                }
            } else {
                qodefStickyColumn.setPosition(columnVars, 'relative');
            }
        },
        calculateOffset: function () {
            qodefStickyColumn.pageOffset = 0;

            if ($('body').hasClass('admin-bar')) {
                qodefStickyColumn.pageOffset += 32;
            }

            if ($('body').hasClass('qodef-header--sticky-display')) {
                qodefStickyColumn.pageOffset += parseInt($('.qodef-header-sticky').outerHeight(true));
            }

            if ($('body').hasClass('qodef-header--fixed-display')) {
                qodefStickyColumn.pageOffset += parseInt($('#qodef-page-header').outerHeight(true));
                qodefStickyColumn.pageOffset += parseInt($('#qodef-page-header').css('margin-top'));
            }
        },
        checkScrollDirection: function () {
            var scrollDirection = (qodef.scroll > qodefStickyColumn.scrollAmount) ? 'down' : 'up';

            qodefStickyColumn.scrollAmount = qodef.scroll;

            return scrollDirection;
        },
        setPosition: function (columnVars, position, direction) {
            if ('relative' === position) {
                columnVars.$columnInner.css({
                    'bottom': 'auto',
                    'left': 'auto',
                    'position': 'relative',
                    'top': 'auto',
                    'width': columnVars.columnWidth,
                    'transform': 'translateY(0)',
                    'transition': 'none'
                });
            }
            if ('fixed' === position) {
                if ($('body').hasClass('qodef-header--sticky-display')) {
                    var transitionValue = ('up' === direction) ? 'none' : 'transform .5s ease';
                }

                columnVars.$columnInner.css({
                    'bottom': 'auto',
                    'left': columnVars.columnLeftEdgePosition,
                    'position': 'fixed',
                    'top': 0,
                    'width': columnVars.columnWidth,
                    'transform': 'translateY(' + qodefStickyColumn.pageOffset + 'px)',
                    'transition': transitionValue
                });
            }
            if ('absolute' === position) {
                columnVars.$columnInner.css({
                    'bottom': -columnVars.rowHeight,
                    'left': '0',
                    'position': 'absolute',
                    'top': 'auto',
                    'width': columnVars.columnWidth,
                    'transform': 'translateY(0)',
                    'transition': 'none'
                });
            }
        }
    };

    window.qodefStickyColumn = qodefStickyColumn;
})(jQuery);

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_accordion = {};

	$( document ).ready(
		function () {
			qodefAccordion.init();
		}
	);

	var qodefAccordion = {
		init: function () {
			var $holder = $( '.qodef-accordion' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						qodefAccordion.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			if ( $currentItem.hasClass( 'qodef-behavior--accordion' ) ) {
				qodefAccordion.initAccordion( $currentItem );
			}

			if ( $currentItem.hasClass( 'qodef-behavior--toggle' ) ) {
				qodefAccordion.initToggle( $currentItem );
			}

			$currentItem.addClass( 'qodef--init' );
		},
		initAccordion: function ( $accordion ) {
			$accordion.accordion(
				{
					animate: 'swing',
					collapsible: true,
					active: 0,
					icons: '',
					heightStyle: 'content',
				}
			);
		},
		initToggle: function ( $toggle ) {
			var $toggleAccordionTitle = $toggle.find( '.qodef-accordion-title' );

			$toggleAccordionTitle.off().on(
				'mouseenter',
				function () {
					$( this ).addClass( 'ui-state-hover' );
				}
			).on(
				'mouseleave',
				function () {
					$( this ).removeClass( 'ui-state-hover' );
				}
			).on(
				'click',
				function ( e ) {
					e.preventDefault();
					e.stopImmediatePropagation();

					var $thisTitle = $( this );

					if ( $thisTitle.hasClass( 'ui-state-active' ) ) {
						$thisTitle.removeClass( 'ui-state-active' );
						$thisTitle.next().removeClass( 'ui-accordion-content-active' ).slideUp( 300 );
					} else {
						$thisTitle.addClass( 'ui-state-active' );
						$thisTitle.next().addClass( 'ui-accordion-content-active' ).slideDown( 400 );
					}
				}
			);
		}
	};

	qodefCore.shortcodes.leroux_core_accordion.qodefAccordion = qodefAccordion;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_advanced_image_slider = {};

	qodefCore.shortcodes.leroux_core_advanced_image_slider.qodefSwiper = qodef.qodefSwiper;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_button = {};

	$( document ).ready(
		function () {
			qodefButton.init();
		}
	);

	var qodefButton = {
		init: function () {
			this.buttons = $( '.qodef-button' );

			if ( this.buttons.length ) {
				this.buttons.each(
					function () {
						qodefButton.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			qodefButton.buttonHoverColor( $currentItem );
			qodefButton.buttonHoverBgColor( $currentItem );
			qodefButton.buttonHoverBorderColor( $currentItem );
		},
		buttonHoverColor: function ( $button ) {
			if ( typeof $button.data( 'hover-color' ) !== 'undefined' ) {
				var hoverColor    = $button.data( 'hover-color' );
				var originalColor = $button.css( 'color' );

				$button.on(
					'mouseenter touchstart',
					function () {
						qodefButton.changeColor( $button, 'color', hoverColor );
					}
				);
				$button.on(
					'mouseleave touchend',
					function () {
						qodefButton.changeColor( $button, 'color', originalColor );
					}
				);
			}
		},
		buttonHoverBgColor: function ( $button ) {
			if ( typeof $button.data( 'hover-background-color' ) !== 'undefined' ) {
				var hoverBackgroundColor    = $button.data( 'hover-background-color' );
				var originalBackgroundColor = $button.css( 'background-color' );

				$button.on(
					'mouseenter touchstart',
					function () {
						qodefButton.changeColor( $button, 'background-color', hoverBackgroundColor );
					}
				);
				$button.on(
					'mouseleave touchend',
					function () {
						qodefButton.changeColor( $button, 'background-color', originalBackgroundColor );
					}
				);
			}
		},
		buttonHoverBorderColor: function ( $button ) {
			if ( typeof $button.data( 'hover-border-color' ) !== 'undefined' ) {
				var hoverBorderColor    = $button.data( 'hover-border-color' );
				var originalBorderColor = $button.css( 'borderTopColor' );

				$button.on(
					'mouseenter touchstart',
					function () {
						qodefButton.changeColor( $button, 'border-color', hoverBorderColor );
					}
				);
				$button.on(
					'mouseleave touchend',
					function () {
						qodefButton.changeColor( $button, 'border-color', originalBorderColor );
					}
				);
			}
		},
		changeColor: function ( $button, cssProperty, color ) {
			$button.css( cssProperty, color );
		}
	};

	qodefCore.shortcodes.leroux_core_button.qodefButton = qodefButton;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_charts = {};

	$( document ).ready( function () {
		qodefCharts.init();
	} );

	var qodefCharts = {
		init: function () {
			this.charts = $( '.qodef-charts' );

			if ( this.charts.length ) {
				this.charts.each( function () {
					var thisChartHolder   = $( this ),
						thisChartCanvasId = thisChartHolder.find( 'canvas' ).attr( 'id' );

					qodefCharts.generateOptions(
						thisChartHolder,
						thisChartCanvasId
					);
				} );
			}
		},
		generateOptions: function ( thisChartHolder, thisChartCanvasId ) {
			var chartSize = false;
			if( 'undefined' !== typeof thisChartHolder.data('size') && '' !== thisChartHolder.data('size') ) {
				chartSize = thisChartHolder.data('size');
			}
			
			if( ! chartSize ) {
				if ( qodef.windowWidth < 600 ) {
					thisChartHolder.height( thisChartHolder.width() );
				} else {
					thisChartHolder.height( thisChartHolder.width() / 2 );
				}
			}

			var noOfDatasets     = thisChartHolder.data( 'no_of_used_datasets' );
			var pointGroupLabels = thisChartHolder.data( 'point_group_labels' );

			var pointGroupColors = '',
				dataset_1,
				dataset_1_color,
				dataset_2,
				dataset_2_color,
				dataset_3,
				dataset_3_color,
				datasets;

			if ( thisChartHolder.data( 'color_scheme' ) === 'dataset' ) {
				dataset_1_color = thisChartHolder.data( 'dataset_1_color' );
			} else {
				dataset_1_color = thisChartHolder.data( 'point_group_colors' ).split( ',' );
			}

			var lineTension = thisChartHolder.data( 'line_tension' );
			if ( lineTension !== undefined && lineTension === 'sharp' ) {
				lineTension = 0;
			} else {
				lineTension = 0.3;
			}

			var fillShape = thisChartHolder.data( 'fill_shape' );
			if ( fillShape !== undefined && fillShape === 'no' ) {
				fillShape = false;
			} else {
				fillShape = true;
			}

			dataset_1 = {
				label: thisChartHolder.data( 'dataset_1_label' ),
				backgroundColor: dataset_1_color,
				borderColor: dataset_1_color,
				fill: fillShape,
				lineTension: lineTension,
				data: thisChartHolder.data( 'dataset_1' ).split( ',' ),
				pointStyle: 'circle',
				pointHoverBackgroundColor: dataset_1_color,
				pointHoverBorderColor: dataset_1_color,
				radius: 0,
				borderWidth: 0,
			};

			datasets = [dataset_1];

			if ( noOfDatasets >= 2 ) {
				if ( thisChartHolder.data( 'color_scheme' ) === 'dataset' ) {
					dataset_2_color = thisChartHolder.data( 'dataset_2_color' );
				} else {
					dataset_2_color = thisChartHolder.data( 'point_group_colors' ).split( ',' );
				}

				dataset_2 = {
					label: thisChartHolder.data( 'dataset_2_label' ),
					backgroundColor: dataset_2_color,
					borderColor: dataset_2_color,
					fill: fillShape,
					lineTension: lineTension,
					data: thisChartHolder.data( 'dataset_2' ).split( ',' ),
					pointStyle: 'circle',
					pointHoverBackgroundColor: dataset_2_color,
					pointHoverBorderColor: dataset_2_color,
					radius: 0,
					borderWidth: 0,
				};

				datasets = [dataset_1, dataset_2];
			}

			if ( noOfDatasets >= 3 ) {
				if ( thisChartHolder.data( 'color_scheme' ) === 'dataset' ) {
					dataset_3_color = thisChartHolder.data( 'dataset_3_color' );
				} else {
					dataset_3_color = thisChartHolder.data( 'point_group_colors' ).split( ',' );
				}

				dataset_3 = {
					label: thisChartHolder.data( 'dataset_3_label' ),
					backgroundColor: dataset_3_color,
					borderColor: dataset_3_color,
					fill: fillShape,
					lineTension: lineTension,
					data: thisChartHolder.data( 'dataset_3' ).split( ',' ),
					pointStyle: 'circle',
					pointHoverBackgroundColor: dataset_3_color,
					pointHoverBorderColor: dataset_3_color,
					radius: 0,
					borderWidth: 0
				};

				datasets = [dataset_1, dataset_2, dataset_3];
			}

			var thisChartParams = {
				labels: pointGroupLabels.split( ',' ),
				datasets: datasets,
			};

			var ctx = document.getElementById( thisChartCanvasId ).getContext( '2d' );

			qodefCharts.chartAppear(
				thisChartHolder,
				ctx,
				thisChartParams
			);
		},
		chartAppear: function ( holder, ctx, thisChartParams ) {
			var legendPosition = holder.data( 'legend_position' ),
				chartType      = holder.data( 'type' ),
				hidexAxes      = holder.data( 'hide_xaxes' ),
				hideyAxes      = holder.data( 'hide_yaxes' ),
				hidexLegend    = holder.data( 'hide_legend' ),
				skin      	   = holder.data( 'skin' ),
				startAtZero    = '',
				padding        = 32,
				boxWidth       = 55,
				fontSize       = 13,
				fontFamily     = 'Sora, sans-serif',
				fontColor      = '#20313a',
				gridLinesColor = '#cacaca';

			hidexAxes 	= 'yes' === hidexAxes ? false : true;
			hideyAxes 	= 'yes' === hideyAxes ? false : true;
			hidexLegend = 'yes' === hidexLegend ? false : true;

			if ( qodef.windowWidth < 600 ) {
				legendPosition = 'bottom';
			}

			if ( chartType == 'line' || chartType == 'horizontalBar' || chartType == 'bar' ) {
				startAtZero = {
					yAxes: [{
						ticks: {
							beginAtZero: true
						}
					}],
					xAxes: [{
						ticks: {
							beginAtZero: true
						}
					}]
				};
			}

			if ( chartType == 'bar' ) {
				padding = 25,
				boxWidth = 25,
				fontSize = 12,
				fontFamily = 'Sora, sans-serif',
				fontColor = '#707070';
			}

			if ( skin !== undefined && skin === 'light' ) {
				fontColor      = '#fff';
				gridLinesColor = '#fff';
			}

			qodefCore.qodefIsInViewport.check(
				holder,
				function () {
					holder.addClass( 'qodef-appeared' );

					window.myBar = new Chart(
						ctx,
						{
							type: chartType,
							borderAlign: 'inner',
							borderWidth: 2,
							borderColor: '#fff',
							data: thisChartParams,
							options: {
								responsive: true,
								maintainAspectRatio: false,
								legend: {
									display: hidexLegend,
									position: legendPosition,
									labels: { // legent circles
										usePointStyle: true,
										padding: padding,
										boxWidth: boxWidth,
										fontSize: fontSize,
										fontFamily: fontFamily,
										fontColor: fontColor,
									}
								},
								scales: {
									xAxes: [{
										display: hidexAxes,
										ticks: {
											fontSize: 12,
											fontColor: '#707070',
										},
										categoryPercentage: 0.5,
										barPercentage: 0.7,
										gridLines: {
											display: false
										},
									}],
									yAxes: [{
										display: hideyAxes,
										ticks: {
											beginAtZero: true,
											fontSize: 12,
											padding: 10,
											fontColor: '#707070',
											stepSize: 10 // <----- This prop sets the stepSize
										},
										gridLines: {
											color: gridLinesColor,
											zeroLineColor: gridLinesColor,
										},
									}],
								},
							},
						}
					);
				},
				false
			);
		}
	};

	qodefCore.shortcodes.leroux_core_charts.qodefCharts = qodefCharts;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_countdown = {};

	$( document ).ready(
		function () {
			qodefCountdown.init();
		}
	);

	var qodefCountdown = {
		init: function () {
			this.countdowns = $( '.qodef-countdown' );

			if ( this.countdowns.length ) {
				this.countdowns.each(
					function () {
						qodefCountdown.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			var $countdownElement = $currentItem.find( '.qodef-m-date' ),
				dateFormats       = ['week', 'day', 'hour', 'minute', 'second'],
				options           = qodefCountdown.generateOptions( $currentItem, dateFormats );

			qodefCountdown.initCountdown( $countdownElement, options, dateFormats );
		},
		generateOptions: function ( $countdown, dateFormats ) {
			var options = {};

			options.date = typeof $countdown.data( 'date' ) !== 'undefined' ? $countdown.data( 'date' ) : null;

			for ( var i = 0; i < dateFormats.length; i++ ) {
				var label       = dateFormats[i] + 'Label',
					labelPlural = dateFormats[i] + 'LabelPlural';

				options[label]       = typeof $countdown.data( dateFormats[i] + '-label' ) !== 'undefined' ? $countdown.data( dateFormats[i] + '-label' ) : '';
				options[labelPlural] = typeof $countdown.data( dateFormats[i] + '-label-plural' ) !== 'undefined' ? $countdown.data( dateFormats[i] + '-label-plural' ) : '';
			}

			return options;
		},
		initCountdown: function ( $countdownElement, options, dateFormats ) {
			var countDownDate = new Date( options.date ).getTime();

			// Update the count down every 1 second
			var x = setInterval(
				function () {

					// Get today's date and time
					var now = new Date().getTime();

					// Find the distance between now and the count down date
					var distance = countDownDate - now;

					// Time calculations for days, hours, minutes and seconds
					this.weeks   = Math.floor( distance / (1000 * 60 * 60 * 24 * 7) );
					this.days    = Math.floor( (distance % (1000 * 60 * 60 * 24 * 7)) / (1000 * 60 * 60 * 24) );
					this.hours   = Math.floor( (distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60) );
					this.minutes = Math.floor( (distance % (1000 * 60 * 60)) / (1000 * 60) );
					this.seconds = Math.floor( (distance % (1000 * 60)) / 1000 );

					for ( var i = 0; i < dateFormats.length; i++ ) {
						var dateName = dateFormats[i] + 's';
						qodefCountdown.initiateDate( $countdownElement, this[dateName], dateFormats[i], options );
					}

					// If the count down is finished, write some text
					if ( distance < 0 ) {
						clearInterval( x );
						qodefCountdown.afterClearInterval( $countdownElement, dateFormats, options );
					}
				},
				1000
			);
		},
		initiateDate: function ( $countdownElement, date, dateFormat, options ) {
			var $holder = $countdownElement.find( '.qodef-' + dateFormat + 's' );

			$holder.find( '.qodef-label' ).html( ( 1 === date ) ? options[dateFormat + 'Label'] : options[dateFormat + 'LabelPlural'] );

			date = (date < 10) ? '0' + date : date;

			$holder.find( '.qodef-digit' ).html( date );
		},
		afterClearInterval: function( $countdownElement, dateFormats, options ) {
			for ( var i = 0; i < dateFormats.length; i++ ) {
				var $holder = $countdownElement.find( '.qodef-' + dateFormats[i] + 's' );

				$holder.find( '.qodef-label' ).html( options[dateFormats[i] + 'LabelPlural'] );
				$holder.find( '.qodef-digit' ).html( '00' );
			}
		}
	};

	qodefCore.shortcodes.leroux_core_countdown.qodefCountdown = qodefCountdown;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_counter = {};

	$( document ).ready(
		function () {
			qodefCounter.init();
		}
	);

	var qodefCounter = {
		init: function () {
			this.counters = $( '.qodef-counter' );

			if ( this.counters.length ) {
				this.counters.each(
					function () {
						qodefCounter.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			var $counterElement = $currentItem.find( '.qodef-m-digit' ),
				options         = qodefCounter.generateOptions( $currentItem );

			qodefCore.qodefIsInViewport.check(
				$currentItem,
				function () {
					qodefCounter.counterScript(
						$counterElement,
						options
					);
				},
			);
		},
		generateOptions: function ( $counter ) {
			var options = {};
			options.start = typeof $counter.data( 'start-digit' ) !== 'undefined' && $counter.data( 'start-digit' ) !== '' ? $counter.data( 'start-digit' ) : 0;
			options.end = typeof $counter.data( 'end-digit' ) !== 'undefined' && $counter.data( 'end-digit' ) !== '' ? $counter.data( 'end-digit' ) : null;
			options.step = typeof $counter.data( 'step-digit' ) !== 'undefined' && $counter.data( 'step-digit' ) !== '' ? $counter.data( 'step-digit' ) : 1;
			options.delay = typeof $counter.data( 'step-delay' ) !== 'undefined' && $counter.data( 'step-delay' ) !== '' ? parseInt(
				$counter.data( 'step-delay' ),
				10
			) : 100;
			options.txt = typeof $counter.data( 'digit-label' ) !== 'undefined' && $counter.data( 'digit-label' ) !== '' ? $counter.data( 'digit-label' ) : '';

			return options;
		},
		counterScript: function ( $counterElement, options ) {
			var defaults = {
				start: 0,
				end: null,
				step: 1,
				delay: 50,
				txt: '',
			};

			var settings = $.extend(
				defaults,
				options || {}
			);
			var nb_start = settings.start;
			var nb_end   = settings.end;

			$counterElement.text( nb_start + settings.txt );

			// Timer
			// Launches every "settings.delay"
			var counterInterval = setInterval(
				function () {
					// Definition of conditions of arrest
					if ( nb_end !== null && nb_start >= nb_end ) {
						return;
					}

					// incrementation
					nb_start = nb_start + settings.step;

					// Check is ended
					if ( nb_start >= nb_end ) {
						nb_start = nb_end;

						clearInterval( counterInterval );
					}

					// display
					$counterElement.text( nb_start + settings.txt );
				},
				settings.delay
			);
		}
	};

	qodefCore.shortcodes.leroux_core_counter.qodefCounter = qodefCounter;
	qodefCore.shortcodes.leroux_core_counter.qodefDrawSvg = qodefCore.qodefDrawSvg;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_google_map = {};

	$( document ).ready(
		function () {
			qodefGoogleMap.init();
		}
	);

	var qodefGoogleMap = {
		init: function () {
			this.holder = $( '.qodef-google-map' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefGoogleMap.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			if ( typeof window.qodefGoogleMap !== 'undefined' ) {
				window.qodefGoogleMap.init( $currentItem.find( '.qodef-m-map' ) );
			}
		},
	};

	qodefCore.shortcodes.leroux_core_google_map.qodefGoogleMap = qodefGoogleMap;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_horizontal_accordion_showcase = {};

	$( document ).ready(
		function () {
			qodefHorizontalAccordionShowcase.init();
			qodefHorizontalAccordionShowcaseResponsive.init();
		}
	);

	var qodefHorizontalAccordionShowcase = {

		init: function () {
			const holder = $( '.qodef-horizontal-accordion-showcase' );

			if ( holder.length ) {
				holder.each( function () {
					const $thisHolder = $( this );
					qodefHorizontalAccordionShowcase.tabItemStyle( $thisHolder );
					qodefHorizontalAccordionShowcase.initTab( $thisHolder );
				} );
			}
		},

		initTab: function ( $holder ) {
			const tab = $holder.find( '.qodef-m-header' );

			if ( tab.length ) {
				tab.each( function ( index ) {
					const currentTab  = $( this ),
						  currentItem = currentTab.parent(),
						  appearsCustom = currentItem.find('.elementor-widget'),//custom layout
					      appears = currentItem.find('.qodef-m-content-left-top, .qodef-m-description, .qodef-m-button'),//predefined layout
					      appearsImages = currentItem.find('.qodef-m-content-right .qodef-m-image');//predefined layout


					const tl = gsap.timeline(
						{
							paused: true,
						}
					);

					tl
						.from (
							appearsCustom,
							{
								y: 0,
								opacity: 0,
								duration: 1.5,
								stagger: .2,
							},
						)
						.from (
							appears,
							{
								y: 50,
								opacity: 0,
								duration: .8,
								stagger: .28,
							},
							'0'
						)
						.from (
							appearsImages,
							{
								scale: .92,
								y: 50,
								opacity: 0,
								duration: 1,
							},
							'<.3'
						);


					if ( ! currentItem.hasClass( 'active' ) && index === 0 ) {
						currentItem.addClass( 'active' );
						tl.play(0);
					}

					currentTab.on(
						'click',
						function () {
							if ( currentItem.hasClass( 'active' ) && currentItem.index() !== index ) {
								currentItem.removeClass( 'active' );
							} else {
								if( ! currentItem.hasClass( 'active' ) ) {
									currentItem.addClass( 'active' );
									tl.play(0);
								}
							}
							currentItem.siblings( '.active' ).removeClass( 'active' );
						}
					);
				} );
			}
		},

		tabItemStyle: function ( $holder ) {
			const item = $holder.find( '.qodef-m-item' );

			if ( item.length ) {
				item.each( function ( i ) {

					i++;

					const itemTab = $( this ).find( '.qodef-m-header' );

					qodefHorizontalAccordionShowcase.tabItemStyleDesktop(
						$( this ),
						item,
						itemTab,
						i
					);

					if( i === item.length ){
						$holder.addClass('qodef--init');
					}
				} );
			}
		},

		tabItemStyleDesktop: function ( current, item, tab, index ) {

			const itemTabWidth = tab.outerWidth(),
				  leftPosition = itemTabWidth * ( index - 1);

			current.css( {
				'width': 'calc(100% - ' + item.length + ' * ' + itemTabWidth + 'px)',
				'left': leftPosition + 'px',
				'z-index': 10 - index
			} );
		},
	};

	qodefCore.shortcodes.leroux_core_horizontal_accordion_showcase.qodefHorizontalAccordionShowcase = qodefHorizontalAccordionShowcase;


	var qodefHorizontalAccordionShowcaseResponsive = {
		init () {
			this.holder = $( '.qodef-horizontal-accordion-showcase-responsive' );

			if ( this.holder.length ) {
				this.holder.each(
					( index, element ) => {
						const $thisShortcode = $( element );
						qodefHorizontalAccordionShowcaseResponsive.itemInit( $thisShortcode );
					}
				);
			}
		},
		itemInit ( $currentItem ) {
			$currentItem.accordion(
				{
					animate: 'swing',
					collapsible: true,
					active: 0,
					icons: '',
					heightStyle: 'content',
				}
			);
		}
	};

	qodefCore.shortcodes.leroux_core_horizontal_accordion_showcase.qodefHorizontalAccordionShowcaseResponsive = qodefHorizontalAccordionShowcaseResponsive;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_horizontal_showcase = {};

	$( document ).ready(
		function () {
		}
	);

	$( window ).on(
		'load',
		function () {
			qodefCustomHorizontalSlider.init();
		}
	);

	var qodefCustomHorizontalSlider = {
		currentHolder: '',
		currentScrollBackHolder: '',
		scrollBackAppearAfter: 10,
		myScrollbar: '',
		init: function () {
			var holder = $( '.qodef-custom-horizontal-slider' );

			if ( qodef.windowWidth > 1024 ) {
				if ( holder.length ) {
					qodef.body.addClass( 'qodef-with-custom-horizontal-slider' );

					holder.each(
						function () {
							qodefCustomHorizontalSlider.currentHolder           = $( this );
							qodefCustomHorizontalSlider.currentScrollBackHolder = $( this ).find( '.qodef-scroll--back' );

							qodefCustomHorizontalSlider.animateSlider( $( this ) );
							qodefCustomHorizontalSlider.initParallax( $( this ) );
						}
					);
				}
			} else {
				if ( holder.length ) {
					holder.each(
						function () {
							var $thisHolder  = $( this ),
								$itemsHolder = $thisHolder.find( '.qodef-slides-holder' ),
								$items       = $itemsHolder.find( '.qodef-horizontal-slide' );

							$thisHolder.addClass( 'qodef--init' );

							$items.each(
								function ( i ) {
									var thisItem = $( this );

									setTimeout(
										function () {
											thisItem.addClass( 'qodef--appear' );
										},
										i * 200
									);
								}
							);
						}
					);
				}
			}
		},
		animateSlider: function ( $thisHolder ) {
			var $itemsHolder         = $thisHolder.find( '.qodef-slides-holder' ),
				$items               = $itemsHolder.find( '.qodef-horizontal-slide' ),
				scrollItemOffset     = 50,
				scrollInitItemOffset = 50;

			if ( qodef.windowWidth < 1025 ) {

				var mobileHeader       = $( '#qodef-page-mobile-header' ),
					mobileHeaderHeight = mobileHeader.length ? mobileHeader.height() : 0;

				$thisHolder.height( qodef.windowHeight - mobileHeaderHeight );
			}

			if ( qodef.windowWidth < 769 ) {
				scrollItemOffset     = (qodef.windowWidth / 2) * -1;
				scrollInitItemOffset = 350;
			}

			var Scrollbar = window.Scrollbar;

			Scrollbar.use( HorizontalScrollPlugin );
			Scrollbar.use( window.OverscrollPlugin );

			qodefCustomHorizontalSlider.myScrollbar = Scrollbar.init(
				document.querySelector( '.qodef-custom-horizontal-slider .qodef-slides-holder' ),
				{
					damping: 0.05,
					plugins: {
						overscroll: {
							damping: 0.1,
							maxOverscroll: 0
						}
					}
				}
			);

			qodefCustomHorizontalSlider.myScrollbar.track.yAxis.element.remove();

			/*add class for first item*/
			setTimeout(
				function () {
					$items.first().addClass( 'qodef--appear' );
				},
				200
			);

			if ( qodefCustomHorizontalSlider.currentScrollBackHolder.length ) {
				qodefCustomHorizontalSlider.currentScrollBackHolder.bind(
					'click',
					function () {
						qodefCustomHorizontalSlider.myScrollbar.scrollTo(
							0,
							0,
							1500
						);
					}
				);
			}

			$thisHolder.addClass( 'qodef--init' );
		},
		initParallax: function ( $thisHolder ) {
			const $parallaxImages      = $thisHolder.find( '.qodef-e-item-intro-image' ),
				  imagesOffsetLeft     = [],
				  imagesWidth          = [],
				  imagesProgress       = [],
				  imagesProgressSmooth = [],
				  imagesBoundLeft      = [],
				  imagesBoundRight     = [];

			$parallaxImages.each( function ( i ) {
				var $thisItem = $( this );

				imagesProgress[i]       = 0;
				imagesProgressSmooth[i] = 0;
				imagesOffsetLeft[i]     = $thisItem.offset().left;
				imagesWidth[i]          = $thisItem.outerWidth();
				imagesBoundLeft[i]      = imagesOffsetLeft[i] - qodefCore.windowWidth;
				imagesBoundRight[i]     = imagesOffsetLeft[i] + imagesWidth[i];
			} );

			function animate() {
				$parallaxImages.each( function ( i, e ) {
						if ( qodefCustomHorizontalSlider.myScrollbar.offset.x > imagesBoundLeft[i] && qodefCustomHorizontalSlider.myScrollbar.offset.x < imagesBoundRight[i] ) {
							imagesProgress[i] = gsap.utils.mapRange(
								imagesBoundLeft[i],
								imagesBoundRight[i],
								0,
								1,
								qodefCustomHorizontalSlider.myScrollbar.offset.x
							);

							$(e).css(
								'--progress',
								imagesProgress[i]
							);
						}
					}
				);

				requestAnimationFrame( animate );
			}

			animate();
		}
	};

	qodefCore.shortcodes.leroux_core_horizontal_showcase.qodefCustomHorizontalSlider = qodefCustomHorizontalSlider;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_icon = {};

	$( document ).ready(
		function () {
			qodefIcon.init();
		}
	);

	var qodefIcon = {
		init: function () {
			this.icons = $( '.qodef-icon-holder' );

			if ( this.icons.length ) {
				this.icons.each(
					function () {
						qodefIcon.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			qodefIcon.iconHoverColor( $currentItem );
			qodefIcon.iconHoverBgColor( $currentItem );
			qodefIcon.iconHoverBorderColor( $currentItem );
		},
		iconHoverColor: function ( $iconHolder ) {
			if ( typeof $iconHolder.data( 'hover-color' ) !== 'undefined' ) {
				var spanHolder    = $iconHolder.find( 'span' ).length ? $iconHolder.find( 'span' ) : $iconHolder;
				var originalColor = spanHolder.css( 'color' );
				var hoverColor    = $iconHolder.data( 'hover-color' );

				$iconHolder.on(
					'mouseenter',
					function () {
						qodefIcon.changeColor(
							spanHolder,
							'color',
							hoverColor
						);
					}
				);
				$iconHolder.on(
					'mouseleave',
					function () {
						qodefIcon.changeColor(
							spanHolder,
							'color',
							originalColor
						);
					}
				);
			}
		},
		iconHoverBgColor: function ( $iconHolder ) {
			if ( typeof $iconHolder.data( 'hover-background-color' ) !== 'undefined' ) {
				var hoverBackgroundColor    = $iconHolder.data( 'hover-background-color' );
				var originalBackgroundColor = $iconHolder.css( 'background-color' );

				$iconHolder.on(
					'mouseenter',
					function () {
						qodefIcon.changeColor(
							$iconHolder,
							'background-color',
							hoverBackgroundColor
						);
					}
				);
				$iconHolder.on(
					'mouseleave',
					function () {
						qodefIcon.changeColor(
							$iconHolder,
							'background-color',
							originalBackgroundColor
						);
					}
				);
			}
		},
		iconHoverBorderColor: function ( $iconHolder ) {
			if ( typeof $iconHolder.data( 'hover-border-color' ) !== 'undefined' ) {
				var hoverBorderColor    = $iconHolder.data( 'hover-border-color' );
				var originalBorderColor = $iconHolder.css( 'borderTopColor' );

				$iconHolder.on(
					'mouseenter',
					function () {
						qodefIcon.changeColor(
							$iconHolder,
							'border-color',
							hoverBorderColor
						);
					}
				);
				$iconHolder.on(
					'mouseleave',
					function () {
						qodefIcon.changeColor(
							$iconHolder,
							'border-color',
							originalBorderColor
						);
					}
				);
			}
		},
		changeColor: function ( iconElement, cssProperty, color ) {
			iconElement.css(
				cssProperty,
				color
			);
		}
	};

	qodefCore.shortcodes.leroux_core_icon.qodefIcon = qodefIcon;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_icon_with_text = {};

	qodefCore.shortcodes.leroux_core_icon_with_text.qodefAppear = qodefCore.qodefAppear;

	qodefCore.shortcodes.leroux_core_icon_with_text.qodefDrawSvg = qodefCore.qodefDrawSvg;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_image_gallery                    = {};
	qodefCore.shortcodes.leroux_core_image_gallery.qodefSwiper        = qodef.qodefSwiper;
	qodefCore.shortcodes.leroux_core_image_gallery.qodefMasonryLayout = qodef.qodefMasonryLayout;
	qodefCore.shortcodes.leroux_core_image_gallery.qodefMagnificPopup = qodef.qodefMagnificPopup;
	qodefCore.shortcodes.leroux_core_image_gallery.qodefCustomCursor  = qodefCore.qodefCustomCursor;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_image_hotspots = {};

	$( document ).ready(
		function () {
			qodefImageHotspots.init();
		}
	);

	var qodefImageHotspots = {
		init: function () {
			this.holder = $( '.qodef-image-hotspots' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefImageHotspots.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {

			qodefCore.qodefIsInViewport.check(
				$currentItem,
				function () {
					$currentItem.addClass( 'qodef--appeared' );

					var $items = $currentItem.find( '.qodef-m-items .qodef-e-item' );

					$items.each( function ( i ) {
						var $item = $( this ),
							$svgHolder = $item.find('.qodef-m-svg'),
							tl = qodefCore.qodefDrawSvg.initDraw($svgHolder);

						setTimeout(
							function () {
								$item.addClass( 'qodef--appeared' );
								tl.play();
							},
							500 * i
						);
					} );
				}
			);
		},

	};

	qodefCore.shortcodes.leroux_core_image_hotspots.qodefImageHotspots = qodefImageHotspots;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_image_with_text                    = {};
	qodefCore.shortcodes.leroux_core_image_with_text.qodefMagnificPopup = qodef.qodefMagnificPopup;
	qodefCore.shortcodes.leroux_core_image_with_text.qodefAppear        = qodefCore.qodefAppear;

})( jQuery );

(function($) {
	'use strict';

	qodefCore.shortcodes.leroux_core_interactive_banner = {};

	$(document).ready(function () {
		qodefInteractiveBanner.init();
	});

	var qodefInteractiveBanner = {
		init: function () {
			this.holder = $('.qodef-interactive-banners');

			if (this.holder.length) {
				this.holder.each(function () {
					var $thisHolder = $(this),
						$imagesHolder = $thisHolder.find('.qodef-ib-images-holder');

					$imagesHolder.css('background-image', $imagesHolder.find('.qodef-ib-image-holder').first().css('background-image'));
					qodefInteractiveBanner.mouseEnter($thisHolder, $imagesHolder);
				});
			}
		},
		mouseEnter: function ($holder, $images) {
			var $imagesHolderItem = $images.find('.qodef-ib-image-holder'),
				$items = $holder.find('.qodef-ib-item'),
				$activeItemIndex = 0;

			if( $items.length ) {
				$items.on("mouseenter", function () {
					$items.removeClass('qodef-active');
					$(this).addClass('qodef-active');
					$activeItemIndex = $(this).index();
					setTimeout( function() {
						$imagesHolderItem.removeClass('qodef-active');
						$images.find('.qodef-ib-image-holder').eq($activeItemIndex).addClass('qodef-active');
					}, 350);
				});

				$items.each( function() {
					var $thisItem = $(this),
						titleHolder = $thisItem.find( '.qodef-ib-item-title' ),
						subtitleHolder = $thisItem.find( '.qodef-ib-item-subtitle' ),
						$offset = 0,
						$titleAdjuster = 10;

					if( titleHolder.length && subtitleHolder.length ) {
						$offset = subtitleHolder.outerHeight( true );
						titleHolder.css( { '--qode-offset':  `${$offset - $titleAdjuster}px` } );
					}

					$holder.addClass('qodef--init');
				} )
			}
		}
	};

	qodefCore.shortcodes.leroux_core_interactive_banner.qodefInteractiveBanner = qodefInteractiveBanner;

})(jQuery);

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_progress_bar = {};

	$( document ).ready(
		function () {
			qodefProgressBar.init();
		}
	);

	/**
	 * Init progress bar shortcode functionality
	 */
	var qodefProgressBar = {
		init: function () {
			this.holder = $( '.qodef-progress-bar' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefProgressBar.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			var layout = $currentItem.data( 'layout' );

			qodefCore.qodefIsInViewport.check(
				$currentItem,
				function () {
					$currentItem.addClass( 'qodef--init' );

					var $container = $currentItem.find( '.qodef-m-canvas' ),
						data       = qodefProgressBar.generateBarData( $currentItem, layout ),
						number     = $currentItem.data( 'number' ) / 100;

					switch (layout) {
						case 'circle':
							qodefProgressBar.initCircleBar( $container, data, number );
							break;
						case 'semi-circle':
							qodefProgressBar.initSemiCircleBar( $container, data, number );
							break;
						case 'line':
							data = qodefProgressBar.generateLineData( $currentItem, number );
							qodefProgressBar.initLineBar( $container, data );
							break;
						case 'custom':
							qodefProgressBar.initCustomBar( $container, data, number );
							break;
					}
					
					qodef.body.trigger('leroux_core_trigger_initiated_progress_bar' );
				},
				false
			);
		},
		generateBarData: function ( thisBar, layout ) {
			var activeWidth   = thisBar.data( 'active-line-width' );
			var activeColor   = thisBar.data( 'active-line-color' );
			var inactiveWidth = thisBar.data( 'inactive-line-width' );
			var inactiveColor = thisBar.data( 'inactive-line-color' );
			var easing        = 'linear';
			var duration      = typeof thisBar.data( 'duration' ) !== 'undefined' && thisBar.data( 'duration' ) !== '' ? parseInt( thisBar.data( 'duration' ), 10 ) : 1600;
			var textColor     = thisBar.data( 'text-color' );

			return {
				strokeWidth: activeWidth,
				color: activeColor,
				trailWidth: inactiveWidth,
				trailColor: inactiveColor,
				easing: easing,
				duration: duration,
				svgStyle: {
					width: '100%',
					height: '100%'
				},
				text: {
					style: {
						color: textColor
					},
					autoStyleContainer: false
				},
				from: {
					color: inactiveColor
				},
				to: {
					color: activeColor
				},
				step: function ( state, bar ) {
					if ( layout !== 'custom' ) {
						bar.setText( Math.round( bar.value() * 100 ) + '%' );
					}
				},
			};
		},
		generateLineData: function ( thisBar, number ) {
			var height         = thisBar.data( 'active-line-width' );
			var activeColor    = thisBar.data( 'active-line-color' );
			var inactiveHeight = thisBar.data( 'inactive-line-width' );
			var inactiveColor  = thisBar.data( 'inactive-line-color' );
			var duration       = typeof thisBar.data( 'duration' ) !== 'undefined' && thisBar.data( 'duration' ) !== '' ? parseInt( thisBar.data( 'duration' ), 10 ) : 1600;
			var textColor      = thisBar.data( 'text-color' );

			return {
				percentage: number * 100,
				duration: duration,
				fillBackgroundColor: activeColor,
				backgroundColor: inactiveColor,
				height: height,
				inactiveHeight: inactiveHeight,
				followText: thisBar.hasClass( 'qodef-percentage--floating' ),
				textColor: textColor,
			};
		},
		initCircleBar: function ( $container, data, number ) {
			if ( qodefProgressBar.checkBar( $container ) ) {
				var $bar = new ProgressBar.Circle( $container[0], data );

				$bar.animate( number );
			}
		},
		initSemiCircleBar: function ( $container, data, number ) {
			if ( qodefProgressBar.checkBar( $container ) ) {
				var $bar = new ProgressBar.SemiCircle( $container[0], data );

				$bar.animate( number );
			}
		},
		initCustomBar: function ( $container, data, number ) {
			if ( qodefProgressBar.checkBar( $container ) ) {
				var $bar = new ProgressBar.Path( $container[0], data );

				$bar.set( 0 );
				$bar.animate( number );
			}
		},
		initLineBar: function ( $container, data ) {
			$container.LineProgressbar( data );
		},
		checkBar: function ( $container ) {
			// check if svg is already in container, elementor fix
			return ! $container.find( 'svg' ).length;
		}
	};

	qodefCore.shortcodes.leroux_core_progress_bar.qodefProgressBar = qodefProgressBar;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_simple_slider = {};

	qodefCore.shortcodes.leroux_core_simple_slider.qodefSwiper = qodef.qodefSwiper;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_single_image = {};

	qodefCore.shortcodes.leroux_core_single_image.qodefAppear       = qodefCore.qodefAppear;
	qodefCore.shortcodes.leroux_core_single_image.qodefParallaxItem = qodefCore.qodefParallaxItem;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_stacked_images = {};

	$( document ).ready(
		function () {
			qodefStackedImages.init();
		}
	);

	var qodefStackedImages = {
		init: function () {
			var holder = $( '.qodef-stacked-images' );

			if ( holder.length ) {
				holder.each(
					function () {
						var images = $( this ).find('.qodef-m-image');

						if ( images.length ) {
							images.each(
								function ( i ) {
									var image = $( this );

									setTimeout(
										function () {
											image.addClass( 'qodef--appeared' );
										},
										500 * i
									);
								}
							);
						}
					}
				);
			}
		},
	};

	qodefCore.shortcodes.leroux_core_stacked_images.qodefStackedImages = qodefStackedImages;

})( jQuery );

(function ($) {
	'use strict';

	qodefCore.shortcodes.leroux_core_tabbed_info = {};

	// $(document).ready(
	// 	function () {
	// 		qodefTabbedInfo.init();
	// 	}
	// );
	
	$(window).on(
		'load',
		function () {
			qodefTabbedInfo.init();
		}
	);

	$(window).resize(
		function () {
			qodefTabbedInfo.init();
		}
	);

	const qodefTabbedInfo = {
		init () {
			this.holder = $('.qodef-m.qodef-tabbed-info:not(.qodef-button)');

			if ( this.holder.length ) {
				this.holder.each(
					( index, element ) => {
						const $thisShortcode = $( element );

						qodefTabbedInfo.itemInit( $thisShortcode );
						qodefTabbedInfo.setHeight( $thisShortcode );
					}
				);
			}
		},
		itemInit ( $currentItem ) {
			$currentItem.children('.qodef-m-content').each(
				function (index) {
					index = index + 1;

					var $that = $(this),
						link = $that.attr('id'),
						$navItem = $that.parent().find('.qodef-m-navigation li:nth-child(' + index + ') a'),
						navLink = $navItem.attr('href');

					link = '#' + link;

					if (link.indexOf(navLink) > -1) {
						$navItem.attr(
							'href',
							link
						);
					}
				}
			);

			$currentItem.addClass('qodef--init').tabs();
		},
		setHeight ( $holder ) {
			const $navigation = $holder.find('.qodef-m-navigation');
			const $content    = $holder.find('.qodef-m-content');
			let   navHeight,
				  contentHeight,
				  maxContentHeight = 0;

			if ( $navigation.length ) {
				navHeight = $navigation.outerHeight(true);
			}

			if ( $content.length ) {
				$content.each(
					( index, element ) => {
						contentHeight = $( element ).outerHeight(true);
						maxContentHeight = contentHeight > maxContentHeight ? contentHeight : maxContentHeight;
					}
				)
			}

			$holder.height(navHeight + maxContentHeight);
		}
	};

	qodefCore.shortcodes.leroux_core_tabbed_info.qodefTabbedInfo = qodefTabbedInfo;

})(jQuery);

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_tabs = {};

	$( document ).ready(
		function () {
			qodefTabs.init();
		}
	);

	var qodefTabs = {
		init: function () {
			this.holder = $( '.qodef-tabs' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefTabs.initItem( $( this ) );
						qodefTabs.adjustCounters( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			$currentItem.children( '.qodef-tabs-content' ).each(
				function ( index ) {
					index = index + 1;

					var $that    = $( this ),
						link     = $that.attr( 'id' ),
						$navItem = $that.parent().find( '.qodef-tabs-navigation li:nth-child(' + index + ') a' ),
						navLink  = $navItem.attr( 'href' );

					link = '#' + link;

					if ( link.indexOf( navLink ) > -1 ) {
						$navItem.attr(
							'href',
							link
						);
					}
				}
			);

			$currentItem.addClass( 'qodef--init' ).tabs();
		},
		setHeight ( $holder ) {
			var $navigation      = $holder.find( '.qodef-tabs-navigation' ),
				$content         = $holder.find( '.qodef-tabs-content' ),
				navHeight,
				contentHeight,
				maxContentHeight = 0;

			if ( $navigation.length ) {
				navHeight = $navigation.outerHeight( true );
			}

			if ( $content.length ) {
				$content.each(
					function () {
						contentHeight = $( this ).outerHeight( true );
						maxContentHeight = contentHeight > maxContentHeight ? contentHeight : maxContentHeight;
					}
				)
			}

			$holder.height(navHeight + maxContentHeight);
		}
	};

	qodefCore.shortcodes.leroux_core_tabs.qodefTabs = qodefTabs;
	qodefCore.shortcodes.leroux_core_tabs.qodefCharts = qodefCore.shortcodes.leroux_core_charts.qodefCharts;

})( jQuery );

(function ($) {
	'use strict';

	qodefCore.shortcodes.leroux_core_text_marquee = {};

	$(document).ready(
		function () {
			qodefTextMarquee.init();
		}
	);

	$(window).resize(
		function () {
			qodefTextMarquee.init();
		}
	);

	var qodefTextMarquee = {
		init               : function () {
			this.holder = $('.qodef-text-marquee');

			if (this.holder.length) {
				this.holder.each(
					function () {
						qodefTextMarquee.prepareContent($(this));
						qodefTextMarquee.calculateWidthRatio($(this));
					}
				);
			}
		},
		prepareContent     : function ($currentItem) {
			var $contentInnerCopy = $currentItem.find('.qodef--copy');

			// remove holder init class
			$currentItem.removeClass('qodef--init');

			// remove duplicated content
			if ($contentInnerCopy.length) {
				$contentInnerCopy.remove();
			}
		},
		calculateWidthRatio: function ($currentItem) {
			var $content = $currentItem.find('.qodef-m-content'),
				$contentInner = $content.find('.qodef-m-content-inner'),
				multiplyCoef = Math.ceil($content.outerWidth() / $contentInner.outerWidth()),
				i;

			// duplicate content at least once
			for (i = 0; i < multiplyCoef; i++) {
				qodefTextMarquee.duplicateContent($content, $contentInner);
			}

			// add holder init class
			$currentItem.addClass('qodef--init');
		},
		duplicateContent   : function ($content, $contentInner) {
			$contentInner.clone().appendTo($content).addClass('qodef--copy');
		},
	};

	qodefCore.shortcodes.leroux_core_text_marquee.qodefTextMarquee = qodefTextMarquee;

})(jQuery);

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_video_button                    = {};
	qodefCore.shortcodes.leroux_core_video_button.qodefMagnificPopup = qodef.qodefMagnificPopup;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( window ).on(
		'load',
		function () {
			qodefStickySidebar.init();
		}
	);

	var qodefStickySidebar = {
		init: function () {
			var info = $( '.widget_leroux_core_sticky_sidebar' );

			if ( info.length && qodefCore.windowWidth > 1024 ) {
				info.wrapper = info.parents( '#qodef-page-sidebar' );
				info.offsetM = info.offset().top - info.wrapper.offset().top;
				info.adj     = 15;

				qodefStickySidebar.callStack( info );

				$( window ).on(
					'resize',
					function () {
						if ( qodefCore.windowWidth > 1024 ) {
							qodefStickySidebar.callStack( info );
						}
					}
				);

				$( window ).on(
					'scroll',
					function () {
						if ( qodefCore.windowWidth > 1024 ) {
							qodefStickySidebar.infoPosition( info );
						}
					}
				);
			}
		},
		calc: function ( info ) {
			var content = $( '.qodef-page-content-section' ),
				headerH = qodefCore.body.hasClass( 'qodef-header-appearance--none' ) ? 0 : parseInt( qodefGlobal.vars.headerHeight, 10 );

			// If posts not found set content to have the same height as the sidebar
			if ( qodefCore.windowWidth > 1024 && content.height() < 100 ) {
				content.css( 'height', info.wrapper.height() - content.height() );
			}

			info.start = content.offset().top;
			info.end   = content.outerHeight();
			info.h     = info.wrapper.height();
			info.w     = info.outerWidth();
			info.left  = info.offset().left;
			info.top   = headerH + qodefGlobal.vars.adminBarHeight - info.offsetM;
			info.data( 'state', 'top' );
		},
		infoPosition: function ( info ) {
			if ( qodefCore.scroll < info.start - info.top && qodefCore.scroll + info.h && info.data( 'state' ) !== 'top' ) {
				gsap.to(
					info.wrapper,
					.1,
					{
						y: 5,
					}
				);
				gsap.to(
					info.wrapper,
					.3,
					{
						y: 0,
						delay: .1,
					}
				);
				info.data( 'state', 'top' );
				info.wrapper.css(
					{
						'position': 'static',
					}
				);
			} else if ( qodefCore.scroll >= info.start - info.top && qodefCore.scroll + info.h + info.adj <= info.start + info.end &&
				info.data( 'state' ) !== 'fixed' ) {
				var c = info.data( 'state' ) === 'top' ? 1 : -1;
				info.data( 'state', 'fixed' );
				info.wrapper.css(
					{
						'position': 'fixed',
						'top': info.top,
						'left': info.left,
						'width': info.w,
					}
				);
				gsap.fromTo(
					info.wrapper,
					.2,
					{
						y: 0
					},
					{
						y: c * 10,
						ease: Power4.easeInOut
					}
				);
				gsap.to(
					info.wrapper,
					.2,
					{
						y: 0,
						delay: .2,
					}
				);
			} else if ( qodefCore.scroll + info.h + info.adj > info.start + info.end && info.data( 'state' ) !== 'bottom' ) {
				info.data( 'state', 'bottom' );
				info.wrapper.css(
					{
						'position': 'absolute',
						'top': info.end - info.h - info.adj,
						'left': 'auto',
						'width': info.w,
					}
				);
				gsap.fromTo(
					info.wrapper,
					.1,
					{
						y: 0
					},
					{
						y: -5,
					}
				);
				gsap.to(
					info.wrapper,
					.3,
					{
						y: 0,
						delay: .1,
					}
				);
			}
		},
		callStack: function ( info ) {
			this.calc( info );
			this.infoPosition( info );
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	var shortcode = 'leroux_core_blog_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

	qodefCore.shortcodes[shortcode].qodefResizeIframes = qodef.qodefResizeIframes;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
	    function () {
            qodefVerticalSlidingNavMenu.init();
        }
	);

	/**
	 * Function object that represents vertical menu area.
	 * @returns {{init: Function}}
	 */
	var qodefVerticalSlidingNavMenu = {
		openedScroll: 0,

		initNavigation: function ( $verticalSlidingMenuObject ) {
			var $verticalSlidingNavObject = $verticalSlidingMenuObject.find( '.qodef-header-vertical-sliding-navigation' );

			if ( $verticalSlidingNavObject.hasClass( 'qodef-vertical-sliding-drop-down--below' ) ) {
				qodefVerticalSlidingNavMenu.dropdownClickToggle( $verticalSlidingNavObject );
			} else if ( $verticalSlidingNavObject.hasClass( 'qodef-vertical-sliding-drop-down--side' ) ) {
				qodefVerticalSlidingNavMenu.dropdownFloat( $verticalSlidingNavObject );
			}
		},
		dropdownClickToggle: function ( $verticalSlidingNavObject ) {
			var $menuItems = $verticalSlidingNavObject.find( 'ul li.menu-item-has-children' );

			$menuItems.each(
				function () {
					var $elementToExpand = $( this ).find( ' > .qodef-drop-down-second, > ul' );
					var menuItem         = this;
					var $dropdownOpener  = $( this ).find( '> a' );
					var slideUpSpeed     = 'fast';
					var slideDownSpeed   = 'slow';

					$dropdownOpener.on(
						'click tap',
						function ( e ) {
							e.preventDefault();
							e.stopPropagation();

							if ( $elementToExpand.is( ':visible' ) ) {
								$( menuItem ).removeClass( 'qodef-menu-item--open' );
								$elementToExpand.slideUp( slideUpSpeed );
							} else if ( $dropdownOpener.parent().parent().children().hasClass( 'qodef-menu-item--open' ) && $dropdownOpener.parent().parent().parent().hasClass( 'qodef-vertical-menu' ) ) {
								$( this ).parent().parent().children().removeClass( 'qodef-menu-item--open' );
								$( this ).parent().parent().children().find( ' > .qodef-drop-down-second' ).slideUp( slideUpSpeed );

								$( menuItem ).addClass( 'qodef-menu-item--open' );
								$elementToExpand.slideDown( slideDownSpeed );
							} else {

								if ( ! $( this ).parents( 'li' ).hasClass( 'qodef-menu-item--open' ) ) {
									$menuItems.removeClass( 'qodef-menu-item--open' );
									$menuItems.find( ' > .qodef-drop-down-second, > ul' ).slideUp( slideUpSpeed );
								}

								if ( $( this ).parent().parent().children().hasClass( 'qodef-menu-item--open' ) ) {
									$( this ).parent().parent().children().removeClass( 'qodef-menu-item--open' );
									$( this ).parent().parent().children().find( ' > .qodef-drop-down-second, > ul' ).slideUp( slideUpSpeed );
								}

								$( menuItem ).addClass( 'qodef-menu-item--open' );
								$elementToExpand.slideDown( slideDownSpeed );
							}
						}
					);
				}
			);
		},
		dropdownFloat: function ( $verticalSlidingNavObject ) {
			var $menuItems = $verticalSlidingNavObject.find( 'ul li.menu-item-has-children' );
			var $allDropdowns = $menuItems.find( ' > .qodef-drop-down-second > .qodef-drop-down-second-inner > ul, > ul' );

			$menuItems.each(
				function () {
					var $elementToExpand = $( this ).find( ' > .qodef-drop-down-second > .qodef-drop-down-second-inner > ul, > ul' );
					var menuItem         = this;

					if ( Modernizr.touch ) {
						var $dropdownOpener = $( this ).find( '> a' );

						$dropdownOpener.on(
							'click tap',
							function ( e ) {
								e.preventDefault();
								e.stopPropagation();

								if ( $elementToExpand.hasClass( 'qodef-float--open' ) ) {
									$elementToExpand.removeClass( 'qodef-float--open' );
									$( menuItem ).removeClass( 'qodef-menu-item--open' );
								} else {
									if ( ! $( this ).parents( 'li' ).hasClass( 'qodef-menu-item--open' ) ) {
										$menuItems.removeClass( 'qodef-menu-item--open' );
										$allDropdowns.removeClass( 'qodef-float--open' );
									}

									$elementToExpand.addClass( 'qodef-float--open' );
									$( menuItem ).addClass( 'qodef-menu-item--open' );
								}
							}
						);
					} else {
						//must use hoverIntent because basic hover effect doesn't catch dropdown
						//it doesn't start from menu item's edge
						$( this ).hoverIntent(
							{
								over: function () {
									$elementToExpand.addClass( 'qodef-float--open' );
									$( menuItem ).addClass( 'qodef-menu-item--open' );
								},
								out: function () {
									$elementToExpand.removeClass( 'qodef-float--open' );
									$( menuItem ).removeClass( 'qodef-menu-item--open' );
								},
								timeout: 300
							}
						);
					}
				}
			);
		},
		verticalSlidingAreaScrollable: function ( $verticalSlidingMenuObject ) {
			return $verticalSlidingMenuObject.hasClass( 'qodef-with-scroll' );
		},
		initVerticalSlidingAreaScroll: function ( $verticalSlidingMenuObject ) {
			if ( qodefVerticalSlidingNavMenu.verticalSlidingAreaScrollable( $verticalSlidingMenuObject ) && typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
				qodefCore.qodefPerfectScrollbar.init( $verticalSlidingMenuObject );
			}
		},
		verticalSlidingAreaShowHide: function ( $verticalSlidingMenuObject ) {
			var $verticalSlidingMenuOpener = $verticalSlidingMenuObject.find( '.qodef-vertical-sliding-menu-opener' );

			$verticalSlidingMenuOpener.on(
				'click',
				function ( e ) {
					e.preventDefault();

					var $thisOpener = $( this );

					if ( ! $verticalSlidingMenuObject.hasClass( 'qodef-vertical-sliding-menu--opened' ) ) {
						$thisOpener.addClass( 'qodef--opened' );
						$verticalSlidingMenuObject.addClass( 'qodef-vertical-sliding-menu--opened' );
						qodefVerticalSlidingNavMenu.openedScroll = qodef.window.scrollTop();
					} else {
						$thisOpener.removeClass( 'qodef--opened' );
						$verticalSlidingMenuObject.removeClass( 'qodef-vertical-sliding-menu--opened' );
					}
				}
			);
		},
		verticalSlidingAreaCloseOnScroll: function ( $verticalSlidingMenuObject ) {
			qodef.window.on(
				'scroll',
				function () {
					if ( $verticalSlidingMenuObject.hasClass( 'qodef-vertical-sliding-menu--opened' ) && Math.abs( qodef.scroll - qodefVerticalSlidingNavMenu.openedScroll ) > 400 ) {
						$verticalSlidingMenuObject.find( '.qodef-vertical-sliding-menu-opener' ).removeClass( 'qodef--opened' );
						$verticalSlidingMenuObject.removeClass( 'qodef-vertical-sliding-menu--opened' );
					}
				}
			);
		},
		init: function () {
			var $verticalSlidingMenuObject = $( '.qodef-header--vertical-sliding #qodef-page-header' );

			if ( $verticalSlidingMenuObject.length ) {
				qodefVerticalSlidingNavMenu.verticalSlidingAreaShowHide( $verticalSlidingMenuObject );
				qodefVerticalSlidingNavMenu.verticalSlidingAreaCloseOnScroll( $verticalSlidingMenuObject );
				qodefVerticalSlidingNavMenu.initNavigation( $verticalSlidingMenuObject );
				qodefVerticalSlidingNavMenu.initVerticalSlidingAreaScroll( $verticalSlidingMenuObject );
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	var fixedHeaderAppearance = {
		showHideHeader: function ( $pageOuter, $header ) {
			if ( qodefCore.windowWidth > 1024 ) {
				if ( qodefCore.scroll <= 0 ) {
					qodefCore.body.removeClass( 'qodef-header--fixed-display' );
					$pageOuter.css( 'padding-top', '0' );
					$header.css( 'margin-top', '0' );
				} else {
					qodefCore.body.addClass( 'qodef-header--fixed-display' );
					$pageOuter.css( 'padding-top', parseInt( qodefGlobal.vars.headerHeight + qodefGlobal.vars.topAreaHeight ) + 'px' );
					$header.css( 'margin-top', parseInt( qodefGlobal.vars.topAreaHeight ) + 'px' );
				}
			}
		},
		init: function () {

			if ( ! qodefCore.body.hasClass( 'qodef-header--vertical' ) ) {
				var $pageOuter = $( '#qodef-page-outer' ),
					$header    = $( '#qodef-page-header' );

				fixedHeaderAppearance.showHideHeader( $pageOuter, $header );

				$( window ).scroll(
					function () {
						fixedHeaderAppearance.showHideHeader( $pageOuter, $header );
					}
				);

				$( window ).resize(
					function () {
						$pageOuter.css( 'padding-top', '0' );
						fixedHeaderAppearance.showHideHeader( $pageOuter, $header );
					}
				);
			}
		}
	};

	qodefCore.fixedHeaderAppearance = fixedHeaderAppearance.init;

})( jQuery );

(function ( $ ) {
	'use strict';

	var stickyHeaderAppearance = {
		header: '',
		docYScroll: 0,
		init: function () {
			var displayAmount = stickyHeaderAppearance.displayAmount();

			// Set variables
			stickyHeaderAppearance.header 	  = $( '.qodef-header-sticky' );
			stickyHeaderAppearance.docYScroll = $( document ).scrollTop();

			// Set sticky visibility
			stickyHeaderAppearance.setVisibility( displayAmount );

			$( window ).scroll(
				function () {
					stickyHeaderAppearance.setVisibility( displayAmount );
				}
			);
		},
		displayAmount: function () {
			if ( qodefGlobal.vars.qodefStickyHeaderScrollAmount !== 0 ) {
				return parseInt( qodefGlobal.vars.qodefStickyHeaderScrollAmount, 10 );
			} else {
				return parseInt( qodefGlobal.vars.headerHeight + qodefGlobal.vars.adminBarHeight, 10 );
			}
		},
		setVisibility: function ( displayAmount ) {
			var isStickyHidden = qodefCore.scroll < displayAmount;

			if ( stickyHeaderAppearance.header.hasClass( 'qodef-appearance--up' ) ) {
				var currentDocYScroll = $( document ).scrollTop();

				isStickyHidden = (currentDocYScroll > stickyHeaderAppearance.docYScroll && currentDocYScroll > displayAmount) || (currentDocYScroll < displayAmount);

				stickyHeaderAppearance.docYScroll = $( document ).scrollTop();
			}

			stickyHeaderAppearance.showHideHeader( isStickyHidden );
		},
		showHideHeader: function ( isStickyHidden ) {
			if ( isStickyHidden ) {
				qodefCore.body.removeClass( 'qodef-header--sticky-display' );
			} else {
				qodefCore.body.addClass( 'qodef-header--sticky-display' );
			}
		},
	};

	qodefCore.stickyHeaderAppearance = stickyHeaderAppearance.init;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSideAreaMobileHeader.init();
		}
	);

	var qodefSideAreaMobileHeader = {
		init: function () {
			var $holder = $( '#qodef-side-area-mobile-header' );

			if ( $holder.length && qodefCore.body.hasClass( 'qodef-mobile-header--side-area' ) ) {
				var $navigation = $holder.find( '.qodef-m-navigation' );

				qodefSideAreaMobileHeader.initOpenerTrigger( $holder, $navigation );
				qodefSideAreaMobileHeader.initNavigationClickToggle( $navigation );

				if ( typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
					qodefCore.qodefPerfectScrollbar.init( $holder );
				}
			}
		},
		initOpenerTrigger: function ( $holder, $navigation ) {
			var $openerIcon = $( '.qodef-side-area-mobile-header-opener' ),
				$closeIcon  = $holder.children( '.qodef-m-close' );

			if ( $openerIcon.length && $navigation.length ) {
				$openerIcon.on(
					'tap click',
					function ( e ) {
						e.stopPropagation();
						e.preventDefault();

						if ( $holder.hasClass( 'qodef--opened' ) ) {
							$holder.removeClass( 'qodef--opened' );
						} else {
							$holder.addClass( 'qodef--opened' );
						}
					}
				);
			}

			$closeIcon.on(
				'tap click',
				function ( e ) {
					e.stopPropagation();
					e.preventDefault();

					if ( $holder.hasClass( 'qodef--opened' ) ) {
						$holder.removeClass( 'qodef--opened' );
					}
				}
			);
		},
		initNavigationClickToggle: function ( $navigation ) {
			var $menuItems = $navigation.find( 'ul li.menu-item-has-children' );

			$menuItems.each(
				function () {
					var $thisItem        = $( this ),
						$elementToExpand = $thisItem.find( ' > .qodef-drop-down-second, > ul' ),
						$dropdownOpener  = $thisItem.find( '> .qodef-menu-item-arrow' ),
						slideUpSpeed     = 'fast',
						slideDownSpeed   = 'slow';

					$dropdownOpener.on(
						'click tap',
						function ( e ) {
							e.preventDefault();
							e.stopPropagation();

							if ( $elementToExpand.is( ':visible' ) ) {
								$thisItem.removeClass( 'qodef-menu-item--open' );
								$elementToExpand.slideUp( slideUpSpeed );
							} else if ( $dropdownOpener.parent().parent().children().hasClass( 'qodef-menu-item--open' ) && $dropdownOpener.parent().parent().parent().hasClass( 'qodef-vertical-menu' ) ) {
								$thisItem.parent().parent().children().removeClass( 'qodef-menu-item--open' );
								$thisItem.parent().parent().children().find( ' > .qodef-drop-down-second' ).slideUp( slideUpSpeed );

								$thisItem.addClass( 'qodef-menu-item--open' );
								$elementToExpand.slideDown( slideDownSpeed );
							} else {

								if ( ! $thisItem.parents( 'li' ).hasClass( 'qodef-menu-item--open' ) ) {
									$menuItems.removeClass( 'qodef-menu-item--open' );
									$menuItems.find( ' > .qodef-drop-down-second, > ul' ).slideUp( slideUpSpeed );
								}

								if ( $thisItem.parent().parent().children().hasClass( 'qodef-menu-item--open' ) ) {
									$thisItem.parent().parent().children().removeClass( 'qodef-menu-item--open' );
									$thisItem.parent().parent().children().find( ' > .qodef-drop-down-second, > ul' ).slideUp( slideUpSpeed );
								}

								$thisItem.addClass( 'qodef-menu-item--open' );
								$elementToExpand.slideDown( slideDownSpeed );
							}
						}
					);
				}
			);
		},
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSearchCoversHeader.init();
		}
	);

	var qodefSearchCoversHeader = {
		init: function () {
			var $searchOpener = $( 'a.qodef-search-opener' ),
				$searchForm   = $( '.qodef-search-cover-form' ),
				$searchClose  = $searchForm.find( '.qodef-m-close' );

			if ( $searchOpener.length && $searchForm.length ) {
				$searchOpener.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefSearchCoversHeader.openCoversHeader( $searchForm );
					}
				);
				$searchClose.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefSearchCoversHeader.closeCoversHeader( $searchForm );
					}
				);
			}
		},
		openCoversHeader: function ( $searchForm ) {
			qodefCore.body.addClass( 'qodef-covers-search--opened qodef-covers-search--fadein' );
			qodefCore.body.removeClass( 'qodef-covers-search--fadeout' );

			setTimeout(
				function () {
					$searchForm.find( '.qodef-m-form-field' ).focus();
				},
				600
			);
		},
		closeCoversHeader: function ( $searchForm ) {
			qodefCore.body.removeClass( 'qodef-covers-search--opened qodef-covers-search--fadein' );
			qodefCore.body.addClass( 'qodef-covers-search--fadeout' );

			setTimeout(
				function () {
					$searchForm.find( '.qodef-m-form-field' ).val( '' );
					$searchForm.find( '.qodef-m-form-field' ).blur();
					qodefCore.body.removeClass( 'qodef-covers-search--fadeout' );
				},
				300
			);
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSearchFullscreen.init();
		}
	);

	var qodefSearchFullscreen = {
		init: function () {
			var $searchOpener = $( 'a.qodef-search-opener' ),
				$searchHolder = $( '.qodef-fullscreen-search-holder' ),
				$searchClose  = $searchHolder.find( '.qodef-m-close' );

			if ( $searchOpener.length && $searchHolder.length ) {
				$searchOpener.on(
					'click',
					function ( e ) {
						e.preventDefault();
						if ( qodefCore.body.hasClass( 'qodef-fullscreen-search--opened' ) ) {
							qodefSearchFullscreen.closeFullscreen( $searchHolder );
						} else {
							qodefSearchFullscreen.openFullscreen( $searchHolder );
						}
					}
				);
				$searchClose.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefSearchFullscreen.closeFullscreen( $searchHolder );
					}
				);

				//Close on escape
				$( document ).keyup(
					function ( e ) {
						if ( e.keyCode === 27 && qodefCore.body.hasClass( 'qodef-fullscreen-search--opened' ) ) { //KeyCode for ESC button is 27
							qodefSearchFullscreen.closeFullscreen( $searchHolder );
						}
					}
				);
			}
		},
		openFullscreen: function ( $searchHolder ) {
			qodefCore.body.removeClass( 'qodef-fullscreen-search--fadeout' );
			qodefCore.body.addClass( 'qodef-fullscreen-search--opened qodef-fullscreen-search--fadein' );

			setTimeout(
				function () {
					$searchHolder.find( '.qodef-m-form-field' ).focus();
				},
				900
			);

			qodefCore.qodefScroll.disable();
		},
		closeFullscreen: function ( $searchHolder ) {
			qodefCore.body.removeClass( 'qodef-fullscreen-search--opened qodef-fullscreen-search--fadein' );
			qodefCore.body.addClass( 'qodef-fullscreen-search--fadeout' );

			setTimeout(
				function () {
					$searchHolder.find( '.qodef-m-form-field' ).val( '' );
					$searchHolder.find( '.qodef-m-form-field' ).blur();
					qodefCore.body.removeClass( 'qodef-fullscreen-search--fadeout' );
				},
				300
			);

			qodefCore.qodefScroll.enable();
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSearch.init();
		}
	);

	var qodefSearch = {
		init: function () {
			this.search = $( 'a.qodef-search-opener' );

			if ( this.search.length ) {
				this.search.each(
					function () {
						var $thisSearch = $( this );

						qodefSearch.searchHoverColor( $thisSearch );
					}
				);
			}
		},
		searchHoverColor: function ( $searchHolder ) {
			if ( typeof $searchHolder.data( 'hover-color' ) !== 'undefined' ) {
				var hoverColor    = $searchHolder.data( 'hover-color' ),
					originalColor = $searchHolder.css( 'color' );

				$searchHolder.on(
					'mouseenter',
					function () {
						$searchHolder.css( 'color', hoverColor );
					}
				).on(
					'mouseleave',
					function () {
						$searchHolder.css( 'color', originalColor );
					}
				);
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefPredefinedSpinner.init();
		}
	);

	$( window ).on(
		'elementor/frontend/init',
		function () {
			const isEditMode = Boolean( elementorFrontend.isEditMode() );

			if ( isEditMode ) {
				qodefPredefinedSpinner.init( isEditMode );
			}
		}
	);

	const qodefPredefinedSpinner = {
		init( isEditMode ) {
			const $holder = $( '#qodef-page-spinner.qodef-layout--predefined' );

			if ( $holder.length ) {
				if ( isEditMode ) {
				} else {
					qodefPredefinedSpinner.animateSpinner( $holder );
				}
			}
		},
		animateSpinner( $holder ) {
			let tl               = qodefCore.qodefParticles.initEffect(
					$holder,
					true
				),
				checkInterval    = 3,
				$svg             = $holder.find( 'svg' ),
				tlOutStarted     = false,
				$backgroundImage = $holder.find( '.qodef-m-spinner-background-image' );

			let $page = $( '#qodef-page-wrapper' );

			let tlOut = gsap.timeline(
				{
					paused: true,
					onStart: () => {
						window.scrollTo(
							0,
							0
						);
						tlOutStarted = true;
						$holder.addClass( 'qodef--animation-out-started' );
					},
					onComplete: () => {
						$holder.addClass( 'qodef--finished' );
						tl.kill();
						$svg.remove();
						qodefCore.qodefBackgroundOverlay.init();
					},
				}
			);

			let childTl = gsap.timeline(
				{
					paused: true,
					onComplete: () => {
						if ( qodefCore.qodefSpinner.windowLoaded && ! tlOutStarted ) {
							tlOut.play();
						} else {
							childTl.restart();
						}
					},
				}
			);

			childTl
			.to(
				$holder,
				{
					duration: checkInterval,
				}
			);

			tl.add(
				childTl.play(),
				'0'
			);

			tlOut
			.to(
				$backgroundImage,
				{
					opacity: 0,
					duration: 2,
					ease: 'power2.out'
				},
			)
			.to(
				$page,
				{
					y: 0,
					duration: 1.4,
					ease: 'power2.out',
				},
				'<.1'
			)
			.to(
				$backgroundImage,
				{
					duration: .5,
					onComplete: ()=>{
						var mainRevHolder = $( '#qodef-main-rev-holder' );

						mainRevHolder.length && mainRevHolder.find( 'rs-module' ).revstart();
					}
				},
				'<'
			);

			qodef.qodefWaitForImages.check(
				$holder,
				function () {
					tl.play();
				}
			);
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function() {
			qodefProgressBarSpinner.init();
		}
	);

	$( window ).on(
		'load',
		function () {
			qodefProgressBarSpinner.windowLoaded = true;
			qodefProgressBarSpinner.completeAnimation();
		}
	);

	$( window ).on(
		'elementor/frontend/init',
		function () {
			var isEditMode = Boolean( elementorFrontend.isEditMode() );

			if ( isEditMode ) {
				qodefProgressBarSpinner.init( isEditMode );
			}
		}
	);

	var qodefProgressBarSpinner = {
		holder: '',
		windowLoaded: false,
		percentNumber: 0,
		init: function ( isEditMode ) {
			this.holder = $( '#qodef-page-spinner.qodef-layout--progress-bar' );

			if ( this.holder.length ) {
				qodefProgressBarSpinner.animateSpinner( this.holder, isEditMode );
			}
		},
		animateSpinner: function ( $holder, isEditMode ) {
			var $numberHolder = $holder.find( '.qodef-m-spinner-number-label' ),
				$spinnerLine  = $holder.find( '.qodef-m-spinner-line-front' );

			$spinnerLine.animate(
				{ 'width': '100%' },
				10000,
				'linear'
			);

			var numberInterval = setInterval(
				function () {
					qodefProgressBarSpinner.animatePercent( $numberHolder, qodefProgressBarSpinner.percentNumber );

					if ( qodefProgressBarSpinner.windowLoaded ) {
						clearInterval( numberInterval );
					}
				},
				100
			);

			if ( isEditMode ) {
				qodefProgressBarSpinner.fadeOutLoader( $holder );
			}
		},
		completeAnimation: function () {
			var $holder = qodefProgressBarSpinner.holder.length ? qodefProgressBarSpinner.holder : $( '#qodef-page-spinner.qodef-layout--progress-bar' );

			var numberIntervalFastest = setInterval(
				function () {

					if ( qodefProgressBarSpinner.percentNumber >= 100 ) {
						clearInterval( numberIntervalFastest );

						$holder.find( '.qodef-m-spinner-line-front' ).stop().animate(
							{ 'width': '100%' },
							500
						);

						$holder.addClass( 'qodef--finished' );

						setTimeout(
							function () {
								qodefProgressBarSpinner.fadeOutLoader( $holder );
							},
							600
						);
					} else {
						qodefProgressBarSpinner.animatePercent(
							$holder.find( '.qodef-m-spinner-number-label' ),
							qodefProgressBarSpinner.percentNumber
						);
					}
				},
				6
			);
		},
		animatePercent: function ( $numberHolder, percentNumber ) {
			if ( percentNumber < 100 ) {
				percentNumber += 5;
				$numberHolder.text( percentNumber );

				qodefProgressBarSpinner.percentNumber = percentNumber;
			}
		},
		fadeOutLoader: function ( $holder, speed, delay, easing ) {
			speed  = speed ? speed : 600;
			delay  = delay ? delay : 0;
			easing = easing ? easing : 'swing';

			$holder.delay( delay ).fadeOut( speed, easing );

			$( window ).on(
				'bind',
				'pageshow',
				function ( event ) {
					if ( event.originalEvent.persisted ) {
						$holder.fadeOut( speed, easing );
					}
				}
			);
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefTextualSpinner.init();
		}
	);

	$( window ).on(
		'load',
		function () {
			qodefTextualSpinner.windowLoaded = true;
		}
	);

	$( window ).on(
		'elementor/frontend/init',
		function () {
			var isEditMode = Boolean( elementorFrontend.isEditMode() );

			if ( isEditMode ) {
				qodefTextualSpinner.init( isEditMode );
			}
		}
	);

	var qodefTextualSpinner = {
		init ( isEditMode ) {
			var $holder = $( '#qodef-page-spinner.qodef-layout--textual' );

			if ( $holder.length ) {
				if ( isEditMode ) {
					qodefTextualSpinner.fadeOutLoader( $holder );
				} else {
					qodefTextualSpinner.splitText( $holder );
				}
			}
		},
		splitText ( $holder ) {
			var $textHolder = $holder.find( '.qodef-m-text' );

			if ( $textHolder.length ) {
				var text     = $textHolder.text().trim(),
					chars    = text.split( '' ),
					cssClass = '';

				$textHolder.empty();

				chars.forEach(
					( element ) => {
						cssClass = (element === ' ' ? 'qodef-m-empty-char' : ' ');
						$textHolder.append( '<span class="qodef-m-char ' + cssClass + '">' + element + '</span>' );
					}
				);

				setTimeout(
					() => {
						qodefTextualSpinner.animateSpinner( $holder );
					}, 100
				);
			}
		},
		animateSpinner ( $holder ) {
			$holder.addClass( 'qodef--init' );

			function animationLoop ( animationProps ) {
				var $chars      = $holder.find( '.qodef-m-char' ),
					charsLength = $chars.length - 1;

				if ( $chars.length ) {
					$chars.each(
						( index, element ) => {
							var $thisChar = $( element );

							setTimeout(
								() => {
									$thisChar.animate(
									    animationProps.type,
										animationProps.duration,
										animationProps.easing,
										() => {
											if ( index === charsLength ) {
												if ( 1 === animationProps.repeat ) {
													animationLoop(
													    {
                                                            type: { opacity: 0 },
                                                            duration: 1200,
                                                            easing: 'swing',
                                                            delay: 0,
                                                            repeat: 0,
                                                        }
													);
												} else {
													if ( ! qodefTextualSpinner.windowLoaded ) {
														animationLoop(
														    {
                                                                type: { opacity: 1 },
                                                                duration: 1800,
                                                                easing: 'swing',
                                                                delay: 160,
                                                                repeat: 1,
                                                            }
														);
													} else {
														qodefTextualSpinner.fadeOutLoader(
															$holder,
															600,
															0,
															'swing'
														);

														setTimeout(
															() => {
																var $revSlider = $( '.qodef-after-spinner-rev rs-module' );

																if ( $revSlider.length ) {
																	$revSlider.revstart();
																}
															}, 800
														);
													}
												}
											}
										}
									);
								}, index * animationProps.delay
							);
						}
					);
				}
			}

			animationLoop (
			    {
                    type: { opacity: 1 },
                    duration: 1800,
                    easing: 'swing',
                    delay: 160,
                    repeat: 1,
                }
			);
		},
		fadeOutLoader( $holder, speed, delay, easing ) {
			speed  = speed ? speed : 500;
			delay  = delay ? delay : 0;
			easing = easing ? easing : 'swing';

			if ( $holder.length ) {
				$holder.delay( delay ).fadeOut( speed, easing );

				$( window ).on(
					'bind',
					'pageshow',
					function( event ) {

						if ( event.originalEvent.persisted ) {
							$holder.fadeOut( speed, easing );
						}
					}
				);
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_instagram_list = {};

	$( document ).ready(
		function () {
			qodefInstagram.init();
		}
	);

	var qodefInstagram = {
		init: function () {
			this.holder = $( '.qodef-instagram-list #sb_instagram' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {

						if ( $( this ).parent().hasClass( 'qodef-instagram-columns' ) ) {
							var $imagesHolder  = $( this ).find( '#sbi_images' ),
								$images        = $imagesHolder.find( '.sbi_item.sbi_type_image, .sbi_item.sbi_type_carousel' ),
								initialPadding = $imagesHolder.css( 'padding' );

							// remove some unnecessary paddings
							$imagesHolder.css('padding', '0');
							$imagesHolder.css('margin', '-' + initialPadding);
							$imagesHolder.css('width', 'calc(100% + ' + ( initialPadding) + ' + ' + ( initialPadding) + ')');

							$images.attr('style', 'padding: ' + initialPadding + '!important');
						} else if ( $( this ).parent().hasClass( 'qodef-instagram-slider' ) ) {
							qodefInstagram.initSlider( $( this ) );
						}
					}
				);
			}
		},
		initSlider: function ( $currentItem, $initAllItems ) {

			var $imagesHolder  = $currentItem.find( '#sbi_images' ),
				$images        = $currentItem.find( '.sbi_item.sbi_type_image' ),
				initialPadding = $imagesHolder.css( 'padding' );

			// remove some unnecessary paddings
			$imagesHolder.css('padding', '0');
			$images.css('padding', '0');

			// items will inherit this margin
			$imagesHolder.attr('style', 'margin-right: ' + (parseInt( initialPadding ) * 2) + 'px !important');

			var sliderOptions = {};

			sliderOptions.spaceBetween      = parseInt( initialPadding ) * 2;
			sliderOptions.customStages      = true;
			sliderOptions.slidesPerView     = $currentItem.data( 'cols' ) !== undefined && $currentItem.data( 'cols' ) !== '' ? $currentItem.data( 'cols' ) : 3;
			sliderOptions.slidesPerView1024 = $currentItem.data( 'cols' ) !== undefined && $currentItem.data( 'cols' ) !== '' ? $currentItem.data( 'cols' ) : 3;
			sliderOptions.slidesPerView680  = $currentItem.data( 'colstablet' ) !== undefined && $currentItem.data( 'colstablet' ) !== '' ? $currentItem.data( 'colstablet' ) : 2;
			sliderOptions.slidesPerView480  = $currentItem.data( 'colsmobile' ) !== undefined && $currentItem.data( 'colsmobile' ) !== '' ? $currentItem.data( 'colsmobile' ) : 1;

			$currentItem.attr( 'data-options', JSON.stringify(sliderOptions) );

			$imagesHolder.addClass( 'swiper-wrapper' );

			if ( $images.length ) {
				$images.each(
					function () {
						$( this ).addClass( 'qodef-e qodef-image-wrapper swiper-slide' );
					}
				);
			}

			if ( typeof qodef.qodefSwiper === 'object' ) {

				if ( false === $initAllItems ) {
					qodef.qodefSwiper.initSlider( $currentItem );
				} else {
					qodef.qodefSwiper.init( $currentItem );
				}
			}
		},
	};

	qodefCore.shortcodes.leroux_core_instagram_list.qodefInstagram = qodefInstagram;
	qodefCore.shortcodes.leroux_core_instagram_list.qodefSwiper    = qodef.qodefSwiper;

})( jQuery );

(function ( $ ) {
	'use strict';

	/*
	 **	Re-init scripts on gallery loaded
	 */
	$( document ).on(
		'yith_wccl_product_gallery_loaded',
		function () {

			if ( typeof qodefCore.qodefWooMagnificPopup === 'function' ) {
				qodefCore.qodefWooMagnificPopup.init();
			}
		}
	);

})( jQuery );

(function ($) {
	'use strict';

	$(document).on(
		'qv_loader_stop qv_variation_gallery_loaded',
		function () {
			qodefYithSelect2.init();
		}
	);

	var qodefYithSelect2 = {
		init: function (settings) {
			this.holder = [];
			this.holder.push(
				{
					holder: $('#yith-quick-view-modal .variations select'),
					options: {
						minimumResultsForSearch: Infinity
					}
				}
			);

			// Allow overriding the default config
			$.extend(this.holder, settings);

			if (typeof this.holder === 'object') {
				$.each(
					this.holder,
					function (key, value) {
						qodefYithSelect2.createSelect2(value.holder, value.options);
					}
				);
			}
		},
		createSelect2: function ($holder, options) {
			if (typeof $holder.select2 === 'function') {
				$holder.select2(options);
			}
		}
	};

})(jQuery);

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_product_category_list                    = {};
	qodefCore.shortcodes.leroux_core_product_category_list.qodefMasonryLayout = qodef.qodefMasonryLayout;
	qodefCore.shortcodes.leroux_core_product_category_list.qodefSwiper        = qodef.qodefSwiper;

})( jQuery );

(function ( $ ) {
	'use strict';

	var shortcode = 'leroux_core_product_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefDropDownCart.init();
		}
	);

	var qodefDropDownCart = {
		init: function () {
			var $holder = $( '.qodef-widget-dropdown-cart-content' );

			if ( $holder.length ) {
				$holder.off().each(
					function () {
						var $thisHolder = $( this );

						qodefDropDownCart.trigger( $thisHolder );

						qodefCore.body.on(
							'added_to_cart removed_from_cart',
							function () {
								qodefDropDownCart.init();
							}
						);
					}
				);
			}
		},
		trigger: function ( $holder ) {
			var $items = $holder.find( '.qodef-woo-mini-cart' );
			if ( $items.length && typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
				qodefCore.qodefPerfectScrollbar.init( $items );
			}
		},
	};

})( jQuery );

(function ($) {
    'use strict';

    $(document).ready(
        function () {
            qodefSideAreaCart.init();
        }
    );

    var qodefSideAreaCart = {
        init: function () {
            var $holder = $('.qodef-widget-side-area-cart-inner');

            if ($holder.length) {
                $holder.off().each(
                    function () {
                        var $thisHolder = $(this);

                        if (qodefCore.windowWidth > 680) {
                            qodefSideAreaCart.trigger($thisHolder);
                            qodefSideAreaCart.start($thisHolder);

                            qodefCore.body.on(
                                'added_to_cart removed_from_cart wc_fragments_refreshed',
                                function () {
                                    qodefSideAreaCart.init();
                                }
                            );

                        }
                    }
                );
            }
        },
        trigger: function ($holder) {
            var $items = $holder.find('.qodef-woo-side-area-cart');
            if ($items.length && typeof qodefCore.qodefPerfectScrollbar === 'object') {
                qodefCore.qodefPerfectScrollbar.init($items);
            }
        },
        start: function ($holder) {
            $holder.on(
                'click',
                '.qodef-m-opener',
                function (e) {
                    e.preventDefault();

                    if (!$holder.hasClass('qodef--opened')) {
                        qodefSideAreaCart.openSideArea($holder);
                        qodefSideAreaCart.trigger($holder);

                        $(document).keyup(
                            function (e) {
                                if (e.keyCode === 27) {
                                    qodefSideAreaCart.closeSideArea($holder);
                                }
                            }
                        );
                    } else {
                        qodefSideAreaCart.closeSideArea($holder);
                    }
                }
            );

            $holder.on(
                'click',
                '.qodef-m-close',
                function (e) {
                    e.preventDefault();
                    qodefSideAreaCart.closeSideArea($holder);
                }
            );
        },
        openSideArea: function ($holder) {
            qodefCore.qodefScroll.disable();

            $holder.addClass('qodef--opened');
            $('#qodef-page-wrapper').prepend('<div class="qodef-woo-side-area-cart-cover"/>');

            $('.qodef-woo-side-area-cart-cover').on(
                'click',
                function (e) {
                    e.preventDefault();

                    qodefSideAreaCart.closeSideArea($holder);
                }
            );
        },
        closeSideArea: function ($holder) {
            if ($holder.hasClass('qodef--opened')) {
                qodefCore.qodefScroll.enable();

                $holder.removeClass('qodef--opened');
                $('.qodef-woo-side-area-cart-cover').remove();
            }
        }
    };

})(jQuery);
(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_clients_list             = {};
	qodefCore.shortcodes.leroux_core_clients_list.qodefSwiper = qodef.qodefSwiper;

})( jQuery );

(function ( $ ) {
	'use strict';

	var shortcode = 'leroux_core_portfolio_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

})( jQuery );

(function ( $ ) {
	'use strict';

	var shortcode = 'leroux_core_team_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_testimonials_list             = {};
	qodefCore.shortcodes.leroux_core_testimonials_list.qodefSwiper = qodef.qodefSwiper;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.leroux_core_thumbnail_slider = {};

	$( document ).ready( function () {
		qodefThumbnailSlider.init();
		qodefActiveItem.init();
	} );

	var qodefThumbnailSlider = {
		thumbnailsSwiper: '',
		$slidesHolder: '',

		init: function () {
			this.holder = $( '.qodef-thumbnail-slider' );

			if ( this.holder.length ) {
				this.holder.each( function () {
					qodefThumbnailSlider.heightCalcs( $( this ) );
					qodefThumbnailSlider.createSlider( $( this ) );
				} );
			}
		},
		heightCalcs: function ( $holder ) {
			var thumbsOuterHolder = $holder.find( '.qodef-m-thumbnails-holder' ),
				thumbsHolder      = $holder.find( '.qodef-m-thumbnails' ),
				thumbs            = $holder.find( '.qodef-m-thumb-item' ),
				maxHeight,
				numberOfVisibleThumbs,
				thumbsHeight;

			if ( thumbs.length ) {
				maxHeight = thumbs.first().outerHeight( true );
				thumbs.each( function () {
					var thisThumb  = $( this ),
						thisHeight = thisThumb.outerHeight();

					if ( maxHeight < thisHeight ) {
						maxHeight = thisHeight;
					}
				} );

				if ( qodef.windowWidth > 1440 || (qodef.windowWidth > 480 && qodef.windowWidth <= 768) ) {
					numberOfVisibleThumbs = 3;
				}

				if ( qodef.windowWidth <= 480 || (qodef.windowWidth > 768 && qodef.windowWidth <= 1440) ) {
					numberOfVisibleThumbs = 2;
				}

				thumbsHeight = numberOfVisibleThumbs * maxHeight;

				thumbsOuterHolder.css(
					'height',
					thumbsHeight + 'px'
				);
				thumbsHolder.css(
					'height',
					thumbsHeight + 'px'
				);
			}
		},
		createSlider: function ( $holder ) {
			var $thumbnailsHolder = $holder.find( '.qodef-m-thumbnails' ),
				thumbnailsOptions = qodefThumbnailSlider.getThumbnailsOptions( $holder );


			qodefThumbnailSlider.thumbnailsSwiper = new Swiper(
				$thumbnailsHolder,
				Object.assign( thumbnailsOptions )
			);

			qodefThumbnailSlider.$slidesHolder = $holder.find( '.qodef-m-slides' );
			var slidesOptions                  = qodefThumbnailSlider.getSlidesOptions( $holder ),
				slidesSwiper                   = new Swiper(
					qodefThumbnailSlider.$slidesHolder,
					Object.assign( slidesOptions )
				);

			slidesSwiper.on(
				'slideChange',
				function ( e ) {
					qodefActiveItem.animateLine( $holder );
				}
			);
		},
		getSlidesOptions: function ( $holder ) {
			var sliderOptions  = typeof $holder.data( 'options' ) !== 'undefined' ? $holder.data( 'options' ) : {},
				autoplay       = sliderOptions.autoplay !== undefined && sliderOptions.autoplay !== '' ? sliderOptions.autoplay : true,
				speed          = sliderOptions.speed !== undefined && sliderOptions.speed !== '' ? parseInt(
					sliderOptions.speed,
					10
				) : 5000,
				speedAnimation = sliderOptions.speedAnimation !== undefined && sliderOptions.speedAnimation !== '' ? parseInt(
					sliderOptions.speedAnimation,
					10
				) : 800;

			if ( autoplay !== false ) {
				autoplay = {
					delay: speed,
					disableOnInteraction: false
				};
			}

			var options = {
				slidesPerView: 1,
				spaceBetween: 0,
				autoplay: autoplay,
				loop: true,
				loopedSlides: 3,
				speed: speedAnimation,
				thumbs: {
					swiper: qodefThumbnailSlider.thumbnailsSwiper,
				},
				effect: 'fade',
				fadeEffect: {
					crossFade: true
				}
			};

			return Object.assign(
				options,
				qodefThumbnailSlider.getSliderDatum( $holder )
			);
		},
		getThumbnailsOptions: function ( $holder ) {
			var sliderOptions  = typeof $holder.data( 'options' ) !== 'undefined' ? $holder.data( 'options' ) : {},
				autoplay       = sliderOptions.autoplay !== undefined && sliderOptions.autoplay !== '' ? sliderOptions.autoplay : true,
				speed          = sliderOptions.speed !== undefined && sliderOptions.speed !== '' ? parseInt(
					sliderOptions.speed,
					10
				) : 5000,
				speedAnimation = sliderOptions.speedAnimation !== undefined && sliderOptions.speedAnimation !== '' ? parseInt(
					sliderOptions.speedAnimation,
					10
				) : 800;

			if ( autoplay !== false && speed !== 5000 ) {
				autoplay = {
					delay: speed
				};
			}

			var options = {
				slidesPerView: 3,
				spaceBetween: 0,
				autoplay: autoplay,
				loop: false,
				loopedSlides: 3,
				freeMode: true,
				speed: speedAnimation,
				watchSlidesVisibility: true,
				watchSlidesProgress: true,
				direction: 'vertical',
				breakpoints: {
					0: {
						slidesPerView: 2,
					},
					481: {
						slidesPerView: 3,
					},
					769: {
						slidesPerView: 2,
					},
					1441: {
						slidesPerView: 3,
					}
				}
			};

			return Object.assign(
				options,
				qodefThumbnailSlider.getSliderDatum( $holder )
			);
		},
		getSliderDatum: function ( $holder ) {
			var dataList    = $holder.data(),
				returnValue = {};

			for ( var property in dataList ) {
				if ( dataList.hasOwnProperty( property ) ) {
					// It's required to be different from data options because da options are all options from shortcode element
					if ( property !== 'options' && typeof dataList[property] !== 'undefined' && dataList[property] !== '' ) {
						returnValue[property] = dataList[property];
					}
				}
			}

			return returnValue;
		},
	};

	qodefCore.shortcodes.leroux_core_thumbnail_slider.qodefThumbnailSlider = qodefThumbnailSlider;


	var qodefActiveItem = {
		init: function () {
			this.holder = $( '.qodef-thumbnail-slider' );

			if ( this.holder.length ) {
				this.holder.each( function () {

					var holder      = $( this );
					var $thumbnails = holder.find( '.qodef-m-thumbnails-inner' );
					$thumbnails.append( '<span class="qodef-active-line"></span>' );

					qodefActiveItem.animateLine( $( this ) );
				} );
			}
		},

		animateLine: function ( $holder ) {
			var $thumbnails = $holder.find( '.qodef-m-thumbnails-inner' );

			if ( $thumbnails.length ) {

				var activeitem = '.swiper-slide-thumb-active';

				var thumbnailLine = $thumbnails.find( '.qodef-active-line' ),
					thumbnail     = $thumbnails.find( '> .qodef-e' ),
					initialOffset;

				if ( thumbnail.filter( activeitem ).length ) {
					initialOffset = thumbnail.filter( activeitem ).offset().top;
					thumbnailLine.css(
						'height',
						thumbnail.filter( activeitem ).outerHeight()
					);
				} else {
					initialOffset = thumbnail.first().offset().top;
					thumbnailLine.css(
						'height',
						thumbnail.first().outerHeight()
					);
				}

				//initial positioning
				thumbnailLine.css(
					'top',
					initialOffset - $thumbnails.offset().top
				);

				//fx on
				thumbnail.mouseenter( function () {
					var thumbnailItem          = $( this ),
						thumbnailHeight        = thumbnailItem.outerHeight(),
						thumbnailsHolderOffset = $thumbnails.offset().top,
						thumbnailItemOffset    = thumbnailItem.offset().top - thumbnailsHolderOffset;

					thumbnailLine.css(
						'height',
						thumbnailHeight
					);
					thumbnailLine.css(
						'top',
						thumbnailItemOffset
					);
				} );

				//fx off
				$thumbnails.mouseleave( function () {
					if ( thumbnail.filter( activeitem ).length ) {
						thumbnailLine.css(
							'height',
							thumbnail.filter( activeitem ).outerHeight()
						);
					} else {
						thumbnailLine.css(
							'height',
							thumbnail.first().outerHeight()
						);
					}

					thumbnailLine.css(
						'top',
						initialOffset - $thumbnails.offset().top
					);
				} );

			}
		}
	};

	qodefCore.shortcodes.leroux_core_thumbnail_slider.qodefActiveItem = qodefActiveItem;
	qodefCore.shortcodes.leroux_core_thumbnail_slider.qodefDrawSvg    = qodefCore.qodefDrawSvg;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefInfoFollow.init();
		}
	);

	$( document ).on(
		'leroux_trigger_get_new_posts',
		function () {
			qodefInfoFollow.init();
		}
	);

	var qodefInfoFollow = {
		init: function () {
			var $gallery = $( '.qodef-hover-animation--follow' );

			if ( $gallery.length ) {
				qodefCore.body.append( '<div class="qodef-e-content-follow"><div class="qodef-e-top-holder"></div><div class="qodef-e-text"></div></div>' );

				var $contentFollow = $( '.qodef-e-content-follow' ),
					$topHolder     = $contentFollow.find( '.qodef-e-top-holder' ),
					$textHolder    = $contentFollow.find( '.qodef-e-text' );

				$gallery.each(
					function () {
						$gallery.find( '.qodef-e-inner' ).each(
							function () {
								var $thisItem = $( this );

								//info element position
								$thisItem.on(
									'mousemove',
									function ( e ) {
										if ( e.clientX + 20 + $contentFollow.width() > qodefCore.windowWidth ) {
											$contentFollow.addClass( 'qodef-right' );
										} else {
											$contentFollow.removeClass( 'qodef-right' );
										}

										$contentFollow.css(
											{
												top: e.clientY + 20,
												left: e.clientX + 20,
											}
										);
									}
								);

								//show/hide info element
								$thisItem.on(
									'mouseenter',
									function () {
										var $thisItemTopHolder  = $( this ).find( '.qodef-e-top-holder' ),
											$thisItemTextHolder = $( this ).find( '.qodef-e-text' );

										if ( $thisItemTopHolder.length ) {
											$topHolder.html( $thisItemTopHolder.html() );
										}

										if ( $thisItemTextHolder.length ) {
											$textHolder.html( $thisItemTextHolder.html() );
										}

										if ( ! $contentFollow.hasClass( 'qodef-is-active' ) ) {
											$contentFollow.addClass( 'qodef-is-active' );
										}
									}
								).on(
									'mouseleave',
									function () {
										if ( $contentFollow.hasClass( 'qodef-is-active' ) ) {
											$contentFollow.removeClass( 'qodef-is-active' );
										}
									}
								);
							}
						);
					}
				);
			}
		},
	};

	qodefCore.shortcodes.leroux_core_portfolio_list.qodefInfoFollow = qodefInfoFollow;

})( jQuery );
