<?php

if ( ! function_exists( 'leroux_core_add_content_side_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function leroux_core_add_content_side_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => LEROUX_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'content-side',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Content side', 'leroux-core' ),
				'description' => esc_html__( 'Content side Settings', 'leroux-core' ),
			)
		);

		if ( $page ) {

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_content_side',
					'title'         => esc_html__( 'Enable Content side', 'leroux-core' ),
					'description'   => esc_html__( 'Use this option to enable/disable page content side', 'leroux-core' ),
					'default_value' => 'no',
				)
			);
		}
	}

	add_action( 'leroux_core_action_default_options_init', 'leroux_core_add_content_side_options', leroux_core_get_admin_options_map_position( 'content-side' ) );
}
