<?php

if( ! function_exists( 'leroux_core_get_content_video_background_option' ) ) {
	function leroux_core_get_content_video_background_option( $page_id = '' ) {
		if( empty( $page_id ) ) {
			$page_id = get_the_ID();
		}

		$content_video_background = get_post_meta( $page_id, 'qodef_page_background_video', true );

		if( ! empty( $content_video_background ) ) {
			return $content_video_background;
		}

		return false;
	}
}

if( ! function_exists( 'leroux_core_is_content_video_background_enabled' ) ) {
	function leroux_core_is_content_video_background_enabled() {
		$content_video_background = leroux_core_get_content_video_background_option();

		return ! empty( $content_video_background );
	}
}

if ( ! function_exists( 'leroux_core_add_content_video_background_to_body_classes' ) ) {
	function leroux_core_add_content_video_background_to_body_classes( $classes ) {
		$classes[] = leroux_core_is_content_video_background_enabled() ? 'qodef-content-video-background--enabled' : '';

		return $classes;
	}

	add_filter( 'body_class', 'leroux_core_add_content_video_background_to_body_classes' );
}

if ( ! function_exists( 'leroux_core_render_content_video_background' ) ) {
	function leroux_core_render_content_video_background() {
		if( leroux_core_is_content_video_background_enabled() ) {
			$params['video_src'] = leroux_core_get_content_video_background_option();

			leroux_core_template_part( 'content-video-background', 'templates/content-video-background', '', $params );
		}
	}

	add_action( 'leroux_action_after_body_tag_open', 'leroux_core_render_content_video_background', 0 );
}