<?php

if ( ! function_exists( 'leroux_core_set_page_content_styles' ) ) {
	/**
	 * Function that generates module inline styles
	 *
	 * @param string $style
	 *
	 * @return string
	 */
	function leroux_core_set_page_content_styles( $style ) {
		$styles = array();
		$page_template = get_page_template_slug();

		$content_margin = apply_filters( 'leroux_core_filter_content_margin', 0 );
		
		if( ! empty( $page_template ) && 'page-blank-template.php' === $page_template && ! is_search() ) {
			$content_margin = 0;
		}

		if ( 0 !== $content_margin ) {
			$styles['margin-top'] = '-' . intval( $content_margin ) . 'px';
		}

		if ( ! empty( $styles ) ) {
			$style .= qode_framework_dynamic_style( '#qodef-page-outer', $styles );
		}


		$style_mobile          = array();
		$content_margin_mobile = apply_filters( 'leroux_core_filter_content_margin_mobile', 0 );

		if ( 0 !== $content_margin_mobile ) {
			$style_mobile['margin-top'] = '-' . intval( $content_margin_mobile ) . 'px';
		}

        $is_mobile_disabled = leroux_core_get_post_value_through_levels( 'qodef_disable_content_behind_header_below_1024' );
        if ( $is_mobile_disabled === 'yes' ) {
            $style_mobile['margin-top'] = '0';
        }

		if ( ! empty( $style_mobile ) ) {
			$style .= qode_framework_dynamic_style_responsive( '#qodef-page-outer', $style_mobile, '', '1024' );
		}

		return $style;
	}

	add_filter( 'leroux_filter_add_inline_style', 'leroux_core_set_page_content_styles' );
}
