<?php

if ( ! function_exists( 'leroux_core_add_fonts_options' ) ) {
	/**
	 * Function that add options for this module
	 */
	function leroux_core_add_fonts_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => LEROUX_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'fonts',
				'title'       => esc_html__( 'Fonts', 'leroux-core' ),
				'description' => esc_html__( 'Global Fonts Options', 'leroux-core' ),
				'icon'        => 'fa fa-cog',
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_google_fonts',
					'title'         => esc_html__( 'Enable Google Fonts', 'leroux-core' ),
					'default_value' => 'yes',
					'args'          => array(
						'custom_class' => 'qodef-enable-google-fonts',
					),
				)
			);

			$google_fonts_section = $page->add_section_element(
				array(
					'name'       => 'qodef_google_fonts_section',
					'title'      => esc_html__( 'Google Fonts Options', 'leroux-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_enable_google_fonts' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$page_repeater = $google_fonts_section->add_repeater_element(
				array(
					'name'        => 'qodef_choose_google_fonts',
					'title'       => esc_html__( 'Google Fonts to Include', 'leroux-core' ),
					'description' => esc_html__( 'Choose Google Fonts which you want to use on your website', 'leroux-core' ),
					'button_text' => esc_html__( 'Add New Google Font', 'leroux-core' ),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type'  => 'googlefont',
					'name'        => 'qodef_choose_google_font',
					'title'       => esc_html__( 'Google Font', 'leroux-core' ),
					'description' => esc_html__( 'Choose Google Font', 'leroux-core' ),
					'args'        => array(
						'include' => 'google-fonts',
					),
				)
			);

			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_weight',
					'title'       => esc_html__( 'Google Fonts Weight', 'leroux-core' ),
					'description' => esc_html__( 'Choose a default Google Fonts weights for your website. Impact on page load time', 'leroux-core' ),
					'options'     => array(
						'100'  => esc_html__( '100 Thin', 'leroux-core' ),
						'100i' => esc_html__( '100 Thin Italic', 'leroux-core' ),
						'200'  => esc_html__( '200 Extra-Light', 'leroux-core' ),
						'200i' => esc_html__( '200 Extra-Light Italic', 'leroux-core' ),
						'300'  => esc_html__( '300 Light', 'leroux-core' ),
						'300i' => esc_html__( '300 Light Italic', 'leroux-core' ),
						'400'  => esc_html__( '400 Regular', 'leroux-core' ),
						'400i' => esc_html__( '400 Regular Italic', 'leroux-core' ),
						'500'  => esc_html__( '500 Medium', 'leroux-core' ),
						'500i' => esc_html__( '500 Medium Italic', 'leroux-core' ),
						'600'  => esc_html__( '600 Semi-Bold', 'leroux-core' ),
						'600i' => esc_html__( '600 Semi-Bold Italic', 'leroux-core' ),
						'700'  => esc_html__( '700 Bold', 'leroux-core' ),
						'700i' => esc_html__( '700 Bold Italic', 'leroux-core' ),
						'800'  => esc_html__( '800 Extra-Bold', 'leroux-core' ),
						'800i' => esc_html__( '800 Extra-Bold Italic', 'leroux-core' ),
						'900'  => esc_html__( '900 Ultra-Bold', 'leroux-core' ),
						'900i' => esc_html__( '900 Ultra-Bold Italic', 'leroux-core' ),
					),
				)
			);

			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_subset',
					'title'       => esc_html__( 'Google Fonts Style', 'leroux-core' ),
					'description' => esc_html__( 'Choose a default Google Fonts style for your website. Impact on page load time', 'leroux-core' ),
					'options'     => array(
						'latin'        => esc_html__( 'Latin', 'leroux-core' ),
						'latin-ext'    => esc_html__( 'Latin Extended', 'leroux-core' ),
						'cyrillic'     => esc_html__( 'Cyrillic', 'leroux-core' ),
						'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'leroux-core' ),
						'greek'        => esc_html__( 'Greek', 'leroux-core' ),
						'greek-ext'    => esc_html__( 'Greek Extended', 'leroux-core' ),
						'vietnamese'   => esc_html__( 'Vietnamese', 'leroux-core' ),
					),
				)
			);

			$page_repeater = $page->add_repeater_element(
				array(
					'name'        => 'qodef_custom_fonts',
					'title'       => esc_html__( 'Custom Fonts', 'leroux-core' ),
					'description' => esc_html__( 'Add custom fonts', 'leroux-core' ),
					'button_text' => esc_html__( 'Add New Custom Font', 'leroux-core' ),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_ttf',
					'title'      => esc_html__( 'Custom Font TTF', 'leroux-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_otf',
					'title'      => esc_html__( 'Custom Font OTF', 'leroux-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_woff',
					'title'      => esc_html__( 'Custom Font WOFF', 'leroux-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_woff2',
					'title'      => esc_html__( 'Custom Font WOFF2', 'leroux-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_custom_font_name',
					'title'      => esc_html__( 'Custom Font Name', 'leroux-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'leroux_core_action_after_page_fonts_options_map', $page );
		}
	}

	add_action( 'leroux_core_action_default_options_init', 'leroux_core_add_fonts_options', leroux_core_get_admin_options_map_position( 'fonts' ) );
}
