<?php

if ( ! function_exists( 'leroux_core_add_centered_header_meta' ) ) {
	/**
	 * Function that add additional header layout meta box options
	 *
	 * @param object $page
	 */
	function leroux_core_add_centered_header_meta( $page ) {

		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_centered_header_section',
				'title'      => esc_html__( 'Centered Header', 'leroux-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => 'centered',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_centered_header_height',
				'title'       => esc_html__( 'Header Height', 'leroux-core' ),
				'description' => esc_html__( 'Enter header height', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_centered_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'leroux-core' ),
				'description' => esc_html__( 'Enter header background color', 'leroux-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_centered_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'leroux-core' ),
				'description' => esc_html__( 'Enter header border color', 'leroux-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_centered_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'leroux-core' ),
				'description' => esc_html__( 'Enter header border width size', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_centered_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'leroux-core' ),
				'description' => esc_html__( 'Choose header border style', 'leroux-core' ),
				'options'     => leroux_core_get_select_type_options_pool( 'border_style' ),
			)
		);
	}

	add_action( 'leroux_core_action_after_page_header_meta_map', 'leroux_core_add_centered_header_meta' );
}
