<?php

if ( ! function_exists( 'leroux_core_add_standard_extended_header_global_option' ) ) {
	/**
	 * This function set header type value for global header option map
	 */
	function leroux_core_add_standard_extended_header_global_option( $header_layout_options ) {
		$header_layout_options['standard-extended'] = array(
			'image' => LEROUX_CORE_HEADER_LAYOUTS_URL_PATH . '/standard-extended/assets/img/standard-extended-header.png',
			'label' => esc_html__( 'Standard Extended', 'leroux-core' ),
		);

		return $header_layout_options;
	}

	add_filter( 'leroux_core_filter_header_layout_option', 'leroux_core_add_standard_extended_header_global_option' );
}

if ( ! function_exists( 'leroux_core_register_standard_extended_header_layout' ) ) {
	/**
	 * Function which add header layout into global list
	 *
	 * @param array $header_layouts
	 *
	 * @return array
	 */
	function leroux_core_register_standard_extended_header_layout( $header_layouts ) {
		$header_layouts['standard-extended'] = 'LerouxCore_Standard_Extended_Header';

		return $header_layouts;
	}

	add_filter( 'leroux_core_filter_register_header_layouts', 'leroux_core_register_standard_extended_header_layout' );
}

if ( ! function_exists( 'leroux_core_register_extended_dropdown_menu' ) ) {
	/**
	 * Function which add additional main menu navigation into global list
	 *
	 * @param array $menus
	 *
	 * @return array
	 */
	function leroux_core_register_extended_dropdown_menu( $menus ) {
		$menus['extended-dropdown-menu'] = esc_html__( 'Extended Dropdown', 'leroux-core' );

		return $menus;
	}

	add_filter( 'leroux_filter_register_navigation_menus', 'leroux_core_register_extended_dropdown_menu' );
}

if ( ! function_exists( 'leroux_core_get_extended_dropdown_menu' ) ) {
	/**
	 * This function is used to wait header-function.php file to init header object and then to init hook registration function above
	 */
	function leroux_core_get_extended_dropdown_menu() {
		$page_id                = qode_framework_get_page_id();
		$show_extended_dropdown = leroux_core_get_post_value_through_levels( 'qodef_standard_extended_show_extended_dropdown', $page_id );

		if ( $show_extended_dropdown == 'yes' ) {
			$params       = array();
			$opener_title = leroux_core_get_post_value_through_levels( 'qodef_standard_extended_extended_dropdown_opener_label', $page_id );

			$params['opener_title'] = ! empty( $opener_title ) ? $opener_title : esc_html__( 'All Categories', 'leroux-core' );

			leroux_core_template_part( 'header/layouts/standard-extended', 'templates/extended-dropdown', '', $params );
		}
	}
}
