<?php

if ( ! function_exists( 'leroux_core_add_tabbed_header_meta' ) ) {
	/**
	 * Function that add additional header layout meta box options
	 *
	 * @param object $page
	 */
	function leroux_core_add_tabbed_header_meta( $page ) {

		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_tabbed_header_section',
				'title'      => esc_html__( 'Tabbed Header', 'leroux-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => 'tabbed',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_tabbed_header_height',
				'title'       => esc_html__( 'Header Height', 'leroux-core' ),
				'description' => esc_html__( 'Enter header height', 'leroux-core' ),
				'args'        => array(
					'suffix' => 'px',
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_tabbed_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'leroux-core' ),
				'description' => esc_html__( 'Enter header background color', 'leroux-core' ),
			)
		);
	}

	add_action( 'leroux_core_action_after_page_header_meta_map', 'leroux_core_add_tabbed_header_meta' );
}
