<?php

if ( ! function_exists( 'leroux_core_add_testimonials_list_variation_info_beside' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function leroux_core_add_testimonials_list_variation_info_beside( $variations ) {
		$variations['info-beside'] = esc_html__( 'Info Beside', 'leroux-core' );

		return $variations;
	}

	add_filter( 'leroux_core_filter_testimonials_list_layouts', 'leroux_core_add_testimonials_list_variation_info_beside' );
}

if ( ! function_exists( 'leroux_core_add_testimonials_list_options_info_beside' ) ) {
	/**
	 * Function that add additional options for variation layout
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	function leroux_core_add_testimonials_list_options_info_beside( $options ) {
		$info_beside_options   = array();
		$margin_option        = array(
			'field_type' => 'text',
			'name'       => 'info_beside_content_margin_top',
			'title'      => esc_html__( 'Content Top Margin', 'leroux-core' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'info-beside',
						'default_value' => 'default',
					),
				),
			),
			'group'      => esc_html__( 'Layout', 'leroux-core' ),
		);
		$info_beside_options[] = $margin_option;

		return array_merge( $options, $info_beside_options );
	}

	add_filter( 'leroux_core_filter_testimonials_list_extra_options', 'leroux_core_add_testimonials_list_options_info_beside' );
}
