<?php

if ( ! function_exists( 'leroux_core_add_testimonials_list_variation_vertical' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function leroux_core_add_testimonials_list_variation_vertical( $variations ) {
		$variations['vertical'] = esc_html__( 'Vertical', 'leroux-core' );

		return $variations;
	}

	add_filter( 'leroux_core_filter_testimonials_list_layouts', 'leroux_core_add_testimonials_list_variation_vertical' );
}

if ( ! function_exists( 'leroux_core_add_testimonials_list_options_vertical' ) ) {
	/**
	 * Function that add additional options for variation layout
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	function leroux_core_add_testimonials_list_options_vertical( $options ) {
		$vertical_options   = array();
		$margin_option        = array(
			'field_type' => 'text',
			'name'       => 'vertical_content_margin_top',
			'title'      => esc_html__( 'Content Top Margin', 'leroux-core' ),
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'vertical',
						'default_value' => 'default',
					),
				),
			),
			'group'      => esc_html__( 'Layout', 'leroux-core' ),
		);
		$vertical_options[] = $margin_option;

		return array_merge( $options, $vertical_options );
	}

	add_filter( 'leroux_core_filter_testimonials_list_extra_options', 'leroux_core_add_testimonials_list_options_vertical' );
}
