<?php

if ( ! function_exists( 'leroux_core_add_accordion_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_accordion_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Accordion_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_accordion_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Accordion_Shortcode extends LerouxCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'leroux_core_filter_accordion_layouts', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/accordion' );
			$this->set_base( 'leroux_core_accordion' );
			$this->set_name( esc_html__( 'Accordion', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds accordion holder', 'leroux-core' ) );
			$this->set_is_parent_shortcode( true );
			$this->set_child_elements(
				array(
					'leroux_core_accordion_child',
				)
			);

			$this->set_scripts(
				array(
					'jquery-ui-accordion' => array(
						'registered' => true,
					),
				)
			);

			$options_map = leroux_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'leroux-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'behavior',
					'title'         => esc_html__( 'Behavior', 'leroux-core' ),
					'options'       => array(
						'accordion' => esc_html__( 'Accordion', 'leroux-core' ),
						'toggle'    => esc_html__( 'Toggle', 'leroux-core' ),
					),
					'default_value' => 'accordion',
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'border_color',
                    'title'      => esc_html__( 'Border Color', 'leroux-core' ),
                    'group'      => esc_html__( 'General Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'icon_layout',
                    'title'      => esc_html__( 'Icon Layout', 'leroux-core' ),
                    'options'    => array(
                        'layout-1'  => esc_html__( 'Layout 1', 'leroux-core' ),
                        'layout-2'  => esc_html__( 'Layout 2', 'leroux-core' ),
                    ),
                    'default_value' => 'layout-1',
                    'group'      => esc_html__( 'General Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'title_color',
                    'title'      => esc_html__( 'Title Color', 'leroux-core' ),
                    'group'      => esc_html__( 'Title Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'title_top_padding',
                    'title'      => esc_html__( 'Title Top Padding (px)', 'leroux-core' ),
                    'group'      => esc_html__( 'Title Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'title_bottom_padding',
                    'title'      => esc_html__( 'Title Bottom Padding (px)', 'leroux-core' ),
                    'group'      => esc_html__( 'Title Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'content_color',
                    'title'      => esc_html__( 'Content Color', 'leroux-core' ),
                    'group'      => esc_html__( 'Content Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'content_top_padding',
                    'title'      => esc_html__( 'Content Top Padding', 'leroux-core' ),
                    'group'      => esc_html__( 'Content Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'content_bottom_padding',
                    'title'      => esc_html__( 'Content Bottom Padding', 'leroux-core' ),
                    'group'      => esc_html__( 'Content Style', 'leroux-core' ),
                )
            );
		}

		public static function call_shortcode( $params ) {
			$content = null;

			if ( isset( $params['accordion_titles'] ) && ! empty( $params['accordion_titles'] ) && isset( $params['accordion_contents'] ) && ! empty( $params['accordion_contents'] ) ) {
				$title_tag = isset( $params['accordion_title_tag'] ) && ! empty( $params['accordion_title_tag'] ) ? esc_attr( $params['accordion_title_tag'] ) : '';

				foreach ( $params['accordion_titles'] as $index => $title ) {
					$content .= '[leroux_core_accordion_child title_tag="' . esc_attr( $title_tag ) . '" title="' . esc_attr( $title ) . '"]' . $params['accordion_contents'][ $index ] . '[/leroux_core_accordion_child]';
				}
			}

			$html = qode_framework_call_shortcode( 'leroux_core_accordion', $params, $content );

			return $html;
		}

		public function load_assets() {
			wp_enqueue_script( 'jquery-ui-accordion' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts                   = $this->get_atts();
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
            $atts['holder_styles']  = $this->get_holder_styles( $atts );

			$atts['content'] = preg_replace( '/\[leroux_core_accordion_child/i', '[leroux_core_accordion_child layout="' . $atts['layout'] . '" icon_layout="' . $atts['icon_layout'] . '"', $content );

			return leroux_core_get_template_part( 'shortcodes/accordion', 'variations/' . $atts['layout'] . '/templates/holder', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-accordion';
			$holder_classes[] = 'clear';
			$holder_classes[] = ! empty( $atts['behavior'] ) ? 'qodef-behavior--' . $atts['behavior'] : '';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['icon_layout'] ) ? 'qodef-icon--' . $atts['icon_layout'] : '';

			return implode( ' ', $holder_classes );
		}

        private function get_holder_styles( $atts ) {
            $styles = array();

            if ( ! empty( $atts['border_color'] ) ) {
                $styles[] = '--qodef-accordion-border-color: ' . $atts['border_color'];
            }

            if ( ! empty( $atts['title_color'] ) ) {
                $styles[] = '--qodef-accordion-title-color: ' . $atts['title_color'];
            }

            if ( ! empty( $atts['title_top_padding'] ) ) {
                $styles[] = '--qodef-accordion-title-top-padding: ' . intval( $atts['title_top_padding'] ) . 'px';
            }

            if ( ! empty( $atts['title_bottom_padding'] ) ) {
                $styles[] = '--qodef-accordion-title-bottom-padding: ' . intval( $atts['title_bottom_padding'] ) . 'px';
            }

            if ( ! empty( $atts['content_color'] ) ) {
                $styles[] = '--qodef-accordion-content-color: ' . $atts['content_color'];
            }

            if ( ! empty( $atts['content_top_padding'] ) ) {
                $styles[] = '--qodef-accordion-content-top-padding: ' . intval( $atts['content_top_padding'] ) . 'px';
            }

            if ( ! empty( $atts['content_bottom_padding'] ) ) {
                $styles[] = '--qodef-accordion-content-bottom-padding: ' . intval( $atts['content_bottom_padding'] ) . 'px';
            }

            return $styles;
        }
	}
}
