<?php

if ( ! function_exists( 'leroux_core_add_advanced_image_slider_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_advanced_image_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Advanced_Image_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_advanced_image_slider_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Advanced_Image_Slider_Shortcode extends LerouxCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/advanced-image-slider' );
			$this->set_base( 'leroux_core_advanced_image_slider' );
			$this->set_name( esc_html__( 'Advanced Image Slider', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds advanced image slider', 'leroux-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'images',
					'multiple'   => 'yes',
					'title'      => esc_html__( 'Images', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'image_size',
					'title'       => esc_html__( 'Image Size', 'leroux-core' ),
					'description' => esc_html__( 'For predefined image sizes input thumbnail, medium, large or full. If you wish to set a custom image size, type in the desired image dimensions in pixels (e.g. 400x400).', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'image_action',
					'title'      => esc_html__( 'Image Action', 'leroux-core' ),
					'options'    => array(
						''            => esc_html__( 'No Action', 'leroux-core' ),
						'open-popup'  => esc_html__( 'Open Popup', 'leroux-core' ),
						'custom-link' => esc_html__( 'Custom Link', 'leroux-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'target',
					'title'         => esc_html__( 'Custom Link Target', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
					'dependency'    => array(
						'show' => array(
							'image_action' => array(
								'values'        => 'custom-link',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'slider_loop',
					'title'      => esc_html__( 'Enable Slider Loop', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'yes_no' ),
					'group'      => esc_html__( 'Slider Settings',  'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'slider_autoplay',
					'title'      => esc_html__( 'Enable Slider Autoplay', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'yes_no' ),
					'group'      => esc_html__( 'Slider Settings',  'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'slider_speed',
					'title'       => esc_html__( 'Slide Duration', 'leroux-core' ),
					'description' => esc_html__( 'Default value is 5000 (ms)', 'leroux-core' ),
					'dependency'  => array(
						'hide' => array(
							'slider_autoplay' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
					'group'       => esc_html__( 'Slider Settings',  'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'slider_speed_animation',
					'title'       => esc_html__( 'Slide Animation Duration', 'leroux-core' ),
					'description' => esc_html__( 'Speed of slide animation in milliseconds. Default value is 800.', 'leroux-core' ),
					'group'       => esc_html__( 'Slider Settings',  'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'slider_navigation',
					'title'      => esc_html__( 'Show Slider Navigation', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'yes_no' ),
					'group'       => esc_html__( 'Slider Settings',  'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'slider_pagination',
					'title'      => esc_html__( 'Show Slider Pagination', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'yes_no' ),
					'group'       => esc_html__( 'Slider Settings',  'leroux-core' ),
				)
			);
			$this->map_extra_options();
		}

		public function load_assets() {
			if ( isset( $atts['image_action'] ) && 'open-popup' === $atts['image_action'] ) {
				wp_enqueue_style( 'magnific-popup' );
				wp_enqueue_script( 'jquery-magnific-popup' );
			}
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['item_classes']   = $this->get_item_classes( $atts );
			$atts['slider_attr']    = $this->get_slider_data( $atts );
			$atts['images']         = $this->generate_images_params( $atts );

			return leroux_core_get_template_part( 'shortcodes/advanced-image-slider', 'templates/advanced-image-slider', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-advanced-image-slider';
			$holder_classes[] = 'qodef-swiper-container';
			$holder_classes[] = ! empty( $atts['image_action'] ) && 'open-popup' === $atts['image_action'] ? 'qodef-magnific-popup qodef-popup-gallery' : '';

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes   = $this->init_item_classes();
			$item_classes[] = 'qodef-ais-image-wrapper';
			$item_classes[] = 'swiper-slide';

			return implode( ' ', $item_classes );
		}

		private function get_slider_data( $atts ) {
			$data = array();

			$data['loop']                 = isset( $atts['slider_loop'] ) ? 'no' !== $atts['slider_loop'] : true;
			$data['autoplay']             = isset( $atts['slider_autoplay'] ) ? 'no' !== $atts['slider_autoplay'] : true;
			$data['speed']                = isset( $atts['slider_speed'] ) ? $atts['slider_speed'] : '';
			$data['speedAnimation']       = isset( $atts['slider_speed_animation'] ) ? $atts['slider_speed_animation'] : '';
			$data['centeredSlides']       = true;
			$data['slidesPerView']        = 1.728;

			return json_encode( $data );
		}

		private function generate_images_params( $atts ) {
			$image_ids = array();
			$images    = array();
			$i         = 0;

			if ( ! empty( $atts['images'] ) ) {
				$image_ids = explode( ',', $atts['images'] );
			}

			$image_size = $this->generate_image_size( $atts );

			foreach ( $image_ids as $id ) {
				if ( is_array( wp_get_attachment_image_src( $id ) ) ) {
					$image['image_id']   = intval( $id );
					$image_original      = wp_get_attachment_image_src( $id, 'full' );
					$image['url']        = $this->generate_image_url( $id, $atts, $image_original[0] );
					$image['alt']        = get_post_meta( $id, '_wp_attachment_image_alt', true );
					$image['image_size'] = $image_size;

					$images[$i] = $image;
					$i ++;
				}
			}

			return $images;
		}

		private function generate_image_size( $atts ) {
			$image_size = trim( $atts['image_size'] );
			preg_match_all( '/\d+/', $image_size, $matches ); /* check if numeral width and height are entered */
			if ( in_array( $image_size, array( 'thumbnail', 'thumb', 'medium', 'large', 'full' ), true ) ) {
				return $image_size;
			} elseif ( ! empty( $matches[0] ) ) {
				return array(
					$matches[0][0],
					$matches[0][1],
				);
			} else {
				return 'full';
			}
		}

		private function generate_image_url( $id, $atts, $default ) {
			if ( 'custom-link' === $atts['image_action'] ) {
				$url = get_post_meta( $id, 'qodef_image_gallery_custom_link', true );
				if ( empty( $url ) ) {
					$url = $default;
				}
			} else {
				$url = $default;
			}

			return $url;
		}
	}
}
