<div <?php qode_framework_class_attribute( $holder_classes ); ?>>
	<div class="qodef-slides-holder">
		<?php
			$counter   = 1;
			$max_count = count( $items );
			foreach ( $items as $item ) {
				$item_classes = $this_shortcode->get_slide_classes( $item );

				if ( $counter === 1 ) {
					$item_classes .= ' qodef-first-item';
				}

				if ( $counter === $max_count ) {
					$item_classes .= ' qodef-last-item';
				}
				?>
				<div <?php qode_framework_class_attribute( $item_classes ); ?> <?php qode_framework_inline_style( $this_shortcode->get_slide_styles( $item ) ); ?>>
					<div class="qodef-slide-content">
						<?php if( ! empty( $item['item_intro_image'] ) ) { ?>
							<div class="qodef-e-item-intro-image">
								<?php echo wp_get_attachment_image( $item['item_intro_image'], 'full' ); ?>
								<h2 class="prog"></h2>
							</div>
						<?php } ?>

						<div class="qodef-e-item-content">
							<?php if ( qode_framework_is_installed( 'elementor' ) ) {
								$content = Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $item['item_elementor_template'] );
								echo do_shortcode( $content );
							} ?>
						</div>

						<?php if( $counter === 1 ) { ?>
							<span class="qodef-e-action qodef-scroll--label">
								<span class="qodef-e-text"><?php echo esc_html__( 'Scroll for more', 'leroux-core' ); ?></span>
								<svg xmlns="http://www.w3.org/2000/svg" width="16.922" height="16.922">
									<g>
										<path d="M.5 8.461h15.92121629"/>
										<path d="m8.40969645 16.2929147 7.87080559-7.87080557"/>
										<path d="m8.40898935.55201065 7.87080558 7.87080558"/>
									</g>
								</svg>
							</span>
						<?php } ?>

						<?php if( $counter === $max_count ) { ?>
							<a href="#" class="qodef-e-action qodef-scroll--back">
								<span class="qodef-e-text"><?php echo esc_html__( 'Go back', 'leroux-core' ); ?></span>
								<svg xmlns="http://www.w3.org/2000/svg" width="16.922" height="16.922">
									<g>
										<path d="M.5 8.461h15.92121629"/>
										<path d="m8.40969645 16.2929147 7.87080559-7.87080557"/>
										<path d="m8.40898935.55201065 7.87080558 7.87080558"/>
									</g>
									<g>
										<path d="M.5 8.461h15.92121629"/>
										<path d="m8.40969645 16.2929147 7.87080559-7.87080557"/>
										<path d="m8.40898935.55201065 7.87080558 7.87080558"/>
									</g>
								</svg>
							</a>
						<?php } ?>
					</div>
				</div>
				<?php
				$counter ++;
			}
		?>
	</div>
</div>
