<?php

if ( ! function_exists( 'leroux_core_add_icon_with_text_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_icon_with_text_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Icon_With_Text_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_icon_with_text_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Icon_With_Text_Shortcode extends LerouxCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'leroux_core_filter_icon_with_text_layouts', array() ) );

			$options_map   = leroux_core_get_variations_options_map( $this->get_layouts() );
			$default_value = $options_map['default_value'];

			$this->set_extra_options( apply_filters( 'leroux_core_filter_icon_with_text_extra_options', array(), $default_value ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/icon-with-text' );
			$this->set_base( 'leroux_core_icon_with_text' );
			$this->set_name( esc_html__( 'Icon With Text', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds icon with text element', 'leroux-core' ) );
			$this->set_category( esc_html__( 'Leroux Core', 'leroux-core' ) );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);

			$options_map = leroux_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'leroux-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'skin',
					'title'      => esc_html__( 'Skin', 'leroux-core' ),
					'options'    => array(
						''      => esc_html__( 'Default', 'leroux-core' ),
						'light' => esc_html__( 'Light', 'leroux-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'hover_effect',
					'title'      => esc_html__( 'Hover Effect', 'leroux-core' ),
					'options'    => array(
						''         => esc_html__( 'Default', 'leroux-core' ),
						'contrast' => esc_html__( 'Contrast', 'leroux-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'padding_holder',
					'title'      => esc_html__( 'Padding (10px 20px)', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'icon_margin_right',
					'title'      => esc_html__( 'Icon Margin Right', 'leroux-core' ),
					'dependency' => array(
						'hide' => array(
							'layout' => array(
								'values'        => 'top',
								'default_value' => 'before-content',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'border_top_custom_color',
					'title'      => esc_html__( 'Border Top Color', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'border_right_custom_color',
					'title'      => esc_html__( 'Border Right Color', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'border_bottom_custom_color',
					'title'      => esc_html__( 'Border Bottom Color', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'border_left_custom_color',
					'title'      => esc_html__( 'Border Left Color', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_borders',
					'title'         => esc_html__( 'Enable Borders', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'top_border',
					'title'         => esc_html__( 'Top Border', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'enable_borders' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'right_border',
					'title'         => esc_html__( 'Right Border', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'enable_borders' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'bottom_border',
					'title'         => esc_html__( 'Bottom Border', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'enable_borders' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'left_border',
					'title'         => esc_html__( 'Left Border', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'enable_borders' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'hide_borders_below_1024',
					'title'         => esc_html__( 'Hide Borders Below 1024px', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'enable_borders' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'hide_borders_below_768',
					'title'         => esc_html__( 'Hide Borders Below 768px', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'enable_borders' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'hide_borders_below_680',
					'title'         => esc_html__( 'Hide Borders Below 680px', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'enable_borders' => array(
								'values'        => 'yes',
								'default_value' => 'no',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'link',
					'title'         => esc_html__( 'Link', 'leroux-core' ),
					'default_value' => '',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'target',
					'title'         => esc_html__( 'Link Target', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'icon_type',
					'title'         => esc_html__( 'Icon Type', 'leroux-core' ),
					'options'       => array(
						'icon-pack'   => esc_html__( 'Icon Pack', 'leroux-core' ),
						'custom-icon' => esc_html__( 'Custom Icon', 'leroux-core' ),
						'svg-icon'    => esc_html__( 'SVG path', 'leroux-core' ),
					),
					'default_value' => 'icon-pack',
					'group'         => esc_html__( 'Icon', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'textarea',
					'name'       => 'svg_icon',
					'title'      => esc_html__( 'Icon SVG code', 'leroux-core' ),
					'group'      => esc_html__( 'Icon', 'leroux-core' ),
					'dependency' => array(
						'show' => array(
							'icon_type' => array(
								'values'        => 'svg-icon',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'svg_icon_color',
					'title'      => esc_html__( 'Icon SVG color', 'leroux-core' ),
					'group'      => esc_html__( 'Icon', 'leroux-core' ),
					'dependency' => array(
						'show' => array(
							'icon_type' => array(
								'values'        => 'svg-icon',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'custom_icon',
					'title'      => esc_html__( 'Custom Icon', 'leroux-core' ),
					'group'      => esc_html__( 'Icon', 'leroux-core' ),
					'dependency' => array(
						'show' => array(
							'icon_type' => array(
								'values'        => 'custom-icon',
								'default_value' => 'icon-pack',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'retina_scale',
					'title'         => esc_html__( 'Enable Retina Scaling', 'leroux-core' ),
					'group'         => esc_html__( 'Icon', 'leroux-core' ),
					'options'       => array(
						'no'  => esc_html__( 'No', 'leroux-core' ),
						'yes' => esc_html__( 'Yes', 'leroux-core' ),
					),
					'default_value' => 'no',
					'dependency' => array(
						'show' => array(
							'icon_type' => array(
								'values'        => 'custom-icon',
								'default_value' => 'icon-pack',
							),
						),
					),
				)
			);
			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'leroux_core_icon',
					'exclude'           => array( 'link', 'target', 'margin' ),
					'additional_params' => array(
						'group'      => esc_html__( 'Icon', 'leroux-core' ),
						'dependency' => array(
							'show' => array(
								'icon_type' => array(
									'values'        => 'icon-pack',
									'default_value' => 'icon-pack',
								),
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title',
					'title'      => esc_html__( 'Title', 'leroux-core' ),
					'group'      => esc_html__( 'Content', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h5',
					'group'         => esc_html__( 'Content', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'leroux-core' ),
					'group'      => esc_html__( 'Content', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'leroux-core' ),
					'group'      => esc_html__( 'Content', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'textarea',
					'name'       => 'text',
					'title'      => esc_html__( 'Text', 'leroux-core' ),
					'group'      => esc_html__( 'Content', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'leroux-core' ),
					'group'      => esc_html__( 'Content', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'leroux-core' ),
					'group'      => esc_html__( 'Content', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'appear',
					'title'      => esc_html__( 'Enable Appear Animation', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);
			$this->map_extra_options();
		}

		public function load_assets() {
			$atts = $this->get_atts();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['title_styles']   = $this->get_title_styles( $atts );
			$atts['text_styles']    = $this->get_text_styles( $atts );
			$atts['icon_params']    = $this->generate_icon_params( $atts );
			$atts['holder_styles']  = $this->get_holder_styles( $atts );
			$atts['mask_styles']    = $this->get_mask_styles( $atts );

			return leroux_core_get_template_part( 'shortcodes/icon-with-text', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-icon-with-text';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['icon_type'] ) ? 'qodef--' . $atts['icon_type'] : '';
			$holder_classes[] = 'yes' === $atts['retina_scale'] ? 'qodef--retina' : '';
			$holder_classes[] = ! empty( $atts['hover_effect'] ) ? 'qodef-hover-effect--' . $atts['hover_effect'] : '';
			$holder_classes[] = ! empty( $atts['skin'] ) ? 'qodef-skin--' . $atts['skin'] : '';

			$holder_classes[] = ! empty( $atts['enable_borders'] ) ? 'qodef-borders--' . $atts['enable_borders'] : '';
			$holder_classes[] = ! empty( $atts['top_border'] ) && ( $atts['top_border'] === 'yes' ) ? 'qodef-border--top' : '';
			$holder_classes[] = ! empty( $atts['right_border'] ) && ( $atts['right_border'] === 'yes' ) ? 'qodef-border--right' : '';
			$holder_classes[] = ! empty( $atts['bottom_border'] ) && ( $atts['bottom_border'] === 'yes' ) ? 'qodef-border--bottom' : '';
			$holder_classes[] = ! empty( $atts['left_border'] ) && ( $atts['left_border'] === 'yes' ) ? 'qodef-border--left' : '';
			$holder_classes[] = ! empty( $atts['hide_borders_below_1024'] ) && ( $atts['hide_borders_below_1024'] === 'yes' ) ? 'qodef-hide-borders--1024' : '';
			$holder_classes[] = ! empty( $atts['hide_borders_below_768'] ) && ( $atts['hide_borders_below_768'] === 'yes' ) ? 'qodef-hide-borders--768' : '';
			$holder_classes[] = ! empty( $atts['hide_borders_below_680'] ) && ( $atts['hide_borders_below_680'] === 'yes' ) ? 'qodef-hide-borders--680' : '';

			$holder_classes[] = ( 'yes' === $atts['appear'] ) && ( 'svg-icon' !== $atts['icon_type'] ) ? 'qodef--has-appear' : '';
			$holder_classes[] = ( 'yes' === $atts['appear'] ) && ( 'svg-icon' == $atts['icon_type'] ) ? 'qodef--has-svg-appear' : '';

			$holder_classes = apply_filters( 'leroux_core_filter_icon_with_text_variation_classes', $holder_classes, $atts );

			return implode( ' ', $holder_classes );
		}

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['title_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['title_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['title_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['title_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			return $styles;
		}

		private function get_holder_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['border_top_custom_color'] ) ) {
				$styles[] = 'border-top-color: ' . $atts['border_top_custom_color'];
			}

			if ( ! empty( $atts['border_right_custom_color'] ) ) {
				$styles[] = 'border-right-color: ' . $atts['border_right_custom_color'];
			}

			if ( ! empty( $atts['border_bottom_custom_color'] ) ) {
				$styles[] = 'border-bottom-color: ' . $atts['border_bottom_custom_color'];
			}

			if ( ! empty( $atts['border_left_custom_color'] ) ) {
				$styles[] = 'border-left-color: ' . $atts['border_left_custom_color'];
			}

			if ( ! empty( $atts['padding_holder'] ) ) {
				$styles[] = 'padding: ' . $atts['padding_holder'];
			}

			if ( ! empty( $atts['icon_margin_right'] ) ) {
				if ( qode_framework_string_ends_with_space_units( $atts['icon_margin_right'] ) ) {
					$styles[] = '--qodef-iwt-icon-margin-right: ' . $atts['icon_margin_right'];
				} else {
					$styles[] = '--qodef-iwt-icon-margin-right: ' . intval( $atts['icon_margin_right'] ) . 'px';
				}
			}

			if ( ! empty( $atts['svg_icon_color'] ) ) {
				$styles[] = '--qodef-iwt-svg-icon-color: ' . $atts['svg_icon_color'];
			}

			return $styles;
		}

		private function get_mask_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['padding_holder'] ) ) {
				$styles[] = 'padding: ' . $atts['padding_holder'];
			}

			return $styles;
		}

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['text_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}

		private function generate_icon_params( $atts ) {
			$params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'leroux_core_icon',
					'exclude'        => array( 'link', 'target', 'margin' ),
					'atts'           => $atts,
				)
			);

			return $params;
		}
	}
}
