<?php

if ( ! function_exists( 'leroux_core_add_icon_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function leroux_core_add_icon_widget( $widgets ) {
		$widgets[] = 'LerouxCore_Icon_Widget';

		return $widgets;
	}

	add_filter( 'leroux_core_filter_register_widgets', 'leroux_core_add_icon_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class LerouxCore_Icon_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'leroux_core_icon',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'leroux_core_icon' );
				$this->set_name( esc_html__( 'Leroux Icon', 'leroux-core' ) );
				$this->set_description( esc_html__( 'Add a icon element into widget areas', 'leroux-core' ) );
			}
		}

		public function render( $atts ) {
			echo LerouxCore_Icon_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
