<?php $i = 0; ?>
<?php $j = 0; ?>

<div class="qodef-interactive-banners <?php echo esc_attr($holder_classes); ?>">
	<div class="qodef-ib-images-holder">
		<?php foreach ($items as $item) {
			$item_styles = array();
			if ( ! empty( $item['item_image'] ) ) {
				$item_styles[] = 'background-image: url(' . wp_get_attachment_image_url( $item['item_image'], 'full' ) . ')';
			}
			
			$item_classes = array(
				'qodef-ib-image-holder'
			);
			$item_classes[] = $i == 0 ? 'qodef-active' : '';
			$item_classes[] = ! empty( $item['item_video'] ) ? 'qodef--video-type' : 'qodef--image-type';
			
			?>
			<div <?php qode_framework_class_attribute( implode( ' ', $item_classes ) ); ?> <?php qode_framework_inline_style( $item_styles ); ?> data-index="<?php echo esc_attr($i);?>">
				<?php if( ! empty( $item['item_video'] ) ) { ?>
					<video class="qodef-ib-video" autoplay muted playsinline loop src="<?php echo esc_url( $item['item_video'] ) ?>"></video>
				<?php } ?>
			</div>
			<?php $i++; ?>
			<?php if($i == $number_of_items_numeric){
				break;
			} ?>
		<?php } ?>
	</div>
	<div class="qodef-ib-content-holder">
		<?php foreach ($items as $item) { ?>
			<div class="qodef-ib-item <?php if($j == 0) echo esc_attr('qodef-active'); ?>" data-index="<?php echo esc_attr($j);?>">
				<div class="qodef-ib-image-holder-responsive" style="background-image: url(<?php echo wp_get_attachment_url($item['item_image']); ?>)">
					<?php if( ! empty( $item['item_video'] ) ) { ?>
						<video class="qodef-ib-video qodef-ib-video-responsive" autoplay muted playsinline loop src="<?php echo esc_url( $item['item_video'] ) ?>"></video>
					<?php } ?>
				</div>
				<span class="qodef-ib-item-tag"><?php echo wp_kses_post($item['tag']); ?></span>
				<div class="qodef-ib-item-inner">
					<div class="qodef-ib-item-title">
						<h3> <?php echo wp_kses_post($item['title']); ?> </h3>
					</div>
					<div class="qodef-ib-item-subtitle">
						<p> <?php echo esc_html($item['subtitle']); ?> </p>
					</div>
					<?php if(!empty($item['link'])){?>
						<div class="qodef-ib-item-btn-holder">
							<?php

							if(empty($item['link_target'])){
								$item['link_target'] = '_blank';
							}

							$button_params = array(
								'text' =>  $item['link_text'],
								'link' => $item['link'],
								'target' => $item['link_target'],
								'button_layout' => 'filled',
								'blur_background' => 'yes',
							);

							echo LerouxCore_Button_Shortcode::call_shortcode( $button_params );
							?>
						</div>
					<?php } ?>
				</div>
			</div>
			<?php $j++; ?>
			<?php if($j == $number_of_items_numeric){
				break;
			} ?>
		<?php } ?>
	</div>
	<div class="qodef-ib-grid">
		<?php for( $k = 0; $k < $number_of_items_numeric; $k++ ) { ?>
			<div class="qodef-ib-grid-line">
				<div class="qodef-ib-grid-vertical-line"></div>
			</div>
		<?php } ?>
	</div>
</div>