<?php

if ( ! function_exists( 'leroux_core_add_simple_slider_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_simple_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Simple_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_simple_slider_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Simple_Slider_Shortcode extends LerouxCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/simple-slider' );
			$this->set_base( 'leroux_core_simple_slider' );
			$this->set_name( esc_html__( 'Simple Slider', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds simple slider element', 'leroux-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'skin',
					'title'      => esc_html__( 'Skin', 'leroux-core' ),
					'options'    => array(
						''      => esc_html__( 'Default', 'leroux-core' ),
						'light' => esc_html__( 'Light', 'leroux-core' ),
					),
					'default_value' => ''
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'layout',
					'title'      => esc_html__( 'Layout', 'leroux-core' ),
					'options'    => array(
						'info-below'      => esc_html__( 'Info Below', 'leroux-core' ),
						'info-on-image' => esc_html__( 'Info On Image', 'leroux-core' ),
					),
					'default_value' => 'info-below',
					'group' => esc_html__( 'Layout', 'leroux-core' )
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'title_tag',
					'title'      => esc_html__( 'Title Tag', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => '',
					'group' => esc_html__( 'Layout', 'leroux-core' )
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'enable_borders',
					'title'      => esc_html__( 'Enable borders between items', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'no_yes' ),
					'default_value' => 'no',
					'group' => esc_html__( 'Layout', 'leroux-core' )
				)
			);
			$this->set_option(
                array(
                    'field_type' => 'repeater',
                    'name'       => 'children',
                    'title'      => esc_html__( 'Child elements', 'leroux-core' ),
                    'items'      => array(
                        array(
                            'field_type' => 'image',
                            'name'       => 'item_image',
                            'title'      => esc_html__( 'Image', 'leroux-core' ),
                        ),
                        array(
                            'field_type' => 'text',
                            'name'       => 'item_title',
                            'title'      => esc_html__( 'Title', 'leroux-core' ),
                        ),
                        array(
                            'field_type' => 'text',
                            'name'       => 'item_text',
                            'title'      => esc_html__( 'Text', 'leroux-core' ),
                        ),
	                    array(
		                    'field_type' => 'text',
		                    'name'       => 'item_link',
		                    'title'      => esc_html__( 'Link', 'leroux-core' ),
	                    ),
	                    array(
		                    'field_type' => 'select',
		                    'name'       => 'item_target',
		                    'title'      => esc_html__( 'Target', 'leroux-core' ),
		                    'options'    => leroux_core_get_select_type_options_pool( 'link_target' )
	                    ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'columns',
                    'title'         => esc_html__( 'Number of Columns', 'leroux-core' ),
                    'options'       => leroux_core_get_select_type_options_pool( 'columns_number' ),
                    'default_value' => '4',
                    'group' => esc_html__( 'Slider Settings', 'leroux-core' )
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'select',
                    'name'        => 'space_between_items',
                    'title'       => esc_html__( 'Space Between Items', 'leroux-core' ),
                    'options'     => leroux_core_get_select_type_options_pool( 'items_space', true, array(), array( 'semi-large' => esc_html__( 'Semi-Large (45)', 'leroux-core' ) ) ),
                    'default_value' => 'normal',
                    'group' => esc_html__( 'Slider Settings', 'leroux-core' )
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'partial_columns',
                    'title'      => esc_html__( 'Enable Partial Columns', 'leroux-core' ),
                    'options'    => leroux_core_get_select_type_options_pool( 'no_yes', false ),
                    'group' => esc_html__( 'Slider Settings', 'leroux-core' )
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'partial_columns_value',
                    'title'      => esc_html__( 'Partial Columns Value', 'leroux-core' ),
                    'description'      => esc_html__( 'Value can be between 0 and 1', 'leroux-core' ),
                    'dependency' => array(
                        'show' => array(
                            'partial_columns' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                    'group' => esc_html__( 'Slider Settings', 'leroux-core' )
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'slider_loop',
                    'title'      => esc_html__( 'Enable Slider Loop', 'leroux-core' ),
                    'options'    => leroux_core_get_select_type_options_pool( 'yes_no' ),
                    'group' => esc_html__( 'Slider Settings', 'leroux-core' )
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'slider_autoplay',
                    'title'      => esc_html__( 'Enable Slider Autoplay', 'leroux-core' ),
                    'options'    => leroux_core_get_select_type_options_pool( 'yes_no' ),
                    'group' => esc_html__( 'Slider Settings', 'leroux-core' )
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'slider_speed',
                    'title'       => esc_html__( 'Slide Duration', 'leroux-core' ),
                    'description' => esc_html__( 'Default value is 5000 (ms)', 'leroux-core' ),
                    'group' => esc_html__( 'Slider Settings', 'leroux-core' )
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'slider_speed_animation',
                    'title'       => esc_html__( 'Slide Animation Duration', 'leroux-core' ),
                    'description' => esc_html__( 'Speed of slide animation in milliseconds. Default value is 800.', 'leroux-core' ),
                    'group' => esc_html__( 'Slider Settings', 'leroux-core' )
                )
            );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

            $atts['slider_pagination'] = 'no';
            $atts['slider_navigation'] = 'yes';

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['holder_styles']  = $this->get_holder_styles( $atts );
			$atts['item_classes']   = $this->get_item_classes( $atts );
			$atts['slider_attr']    = $this->get_slider_data( $atts );
            $atts['items']          = $this->parse_repeater_items( $atts['children'] );

			return leroux_core_get_template_part( 'shortcodes/simple-slider', 'templates/simple-slider', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-simple-slider';
			$holder_classes[] = 'qodef-swiper-container';
			$holder_classes[] = ! empty( $atts['skin'] ) && 'light' === $atts['skin'] ? 'qodef-skin--light' : '';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['enable_borders'] ) && 'yes' === $atts['enable_borders'] ? 'qodef-borders--enabled' : '';

			return implode( ' ', $holder_classes );
		}
		
		private function get_holder_styles( $atts ) {
			$styles = array();
			
			if ( ! empty( $atts['space_between_items'] ) && ! empty( $atts['enable_borders'] ) && 'yes' === $atts['enable_borders'] ) {
				$styles[] = '--qode-border-offset: -' . leroux_core_get_space_value( $atts['space_between_items'] ) . 'px';
			}
			
			return $styles;
		}

		public function get_item_classes( $atts ) {
			$item_classes   = $this->init_item_classes();

            $item_classes[] = 'qodef-e';
            $item_classes[] = 'swiper-slide';

			return implode( ' ', $item_classes );
		}

        public function get_slider_data( $atts ) {
            $data = array();

            $data['slidesPerView']  = $atts['columns'];
            if ( $atts['partial_columns'] === 'yes' && $atts['partial_columns_value'] !== '' ) {
                $data['slidesPerView'] =  intval( $atts['columns'] ) + floatval( $atts['partial_columns_value'] );
            }

            $data['spaceBetween']   = isset( $atts['space_between_items'] ) ? ( leroux_core_get_space_value( $atts['space_between_items'] ) * 2 ) : 0; // double half space for slider
            $data['loop']           = isset( $atts['slider_loop'] ) ? 'no' !== $atts['slider_loop'] : true;
            $data['autoplay']       = isset( $atts['slider_autoplay'] ) ? 'no' !== $atts['slider_autoplay'] : true;
            $data['speed']          = isset( $atts['slider_speed'] ) ? $atts['slider_speed'] : '';
            $data['speedAnimation'] = isset( $atts['slider_speed_animation'] ) ? $atts['slider_speed_animation'] : '';

            return json_encode( $data );
        }
	}
}
