<?php

if ( ! function_exists( 'leroux_core_add_textual_list_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_textual_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Textual_List_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_textual_list_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Textual_List_Shortcode extends LerouxCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/textual-list' );
			$this->set_base( 'leroux_core_textual_list' );
			$this->set_name( esc_html__( 'Textual List', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds textual list', 'leroux-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h6',
				)
			);
			$this->set_option( array(
				'field_type' => 'repeater',
				'name'       => 'children',
				'title'      => esc_html__( 'Items', 'leroux-core' ),
				'items'      => array(
					array(
						'field_type'    => 'text',
						'name'          => 'title',
						'title'         => esc_html__( 'Title', 'leroux-core' ),
						'default_value' => ''
					),
                    array(
                        'field_type'    => 'text',
                        'name'          => 'item_link',
                        'title'         => esc_html__( 'Link', 'leroux-core' ),
                        'default_value' => ''
                    ),
					array(
						'field_type' => 'iconpack',
						'name'       => 'main_icon',
						'title'      => esc_html__( 'Icon', 'leroux-core' ),
					)
				)
			) );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'direction',
                    'title'         => esc_html__( 'Direction', 'leroux-core' ),
                    'options'       => array(
                        'vertical'   => esc_html__( 'Vertical', 'leroux-core' ),
                        'horizontal' => esc_html__( 'Horizontal', 'leroux-core' ),
                    ),
                    'default_value' => 'vertical',
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'link_target',
                    'title'         => esc_html__( 'Link Target', 'leroux-core' ),
                    'options'       => leroux_core_get_select_type_options_pool( 'link_target' ),
                    'default_value' => '_self',
                )
            );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'space_between_items',
					'title'      => esc_html__( 'Space Between Items', 'leroux-core' ),
					'group'      => esc_html__( 'Style', 'leroux-core' )
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'items_color',
					'title'      => esc_html__( 'Items Color', 'leroux-core' ),
					'group'      => esc_html__( 'Style', 'leroux-core' )
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'items_font_size',
                    'title'      => esc_html__( 'Items Font Size', 'leroux-core' ),
                    'group'      => esc_html__( 'Style', 'leroux-core' )
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'items_font_weight',
                    'title'      => esc_html__( 'Items Font Weight', 'leroux-core' ),
                    'options'    => leroux_core_get_select_type_options_pool( 'font_weight' ),
                    'group'      => esc_html__( 'Style', 'leroux-core' ),
                )
            );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'icon_right_margin',
					'title'      => esc_html__( 'Icon Right Margin', 'leroux-core' ),
					'group'      => esc_html__( 'Style', 'leroux-core' )
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'icon_font_size',
                    'title'      => esc_html__( 'Icon Font Size', 'leroux-core' ),
                    'group'      => esc_html__( 'Style', 'leroux-core' ),
                )
            );
			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']      = $this->get_holder_classes( $atts );
			$atts['inner_holder_styles'] = $this->get_inner_holder_styles( $atts );
			$atts['item_classes']        = $this->get_item_classes( $atts );
			$atts['title_styles']        = $this->get_title_styles( $atts );
			$atts['icon_styles']         = $this->get_icon_styles( $atts );
			$atts['items']               = $this->parse_repeater_items( $atts['children'] );

			return leroux_core_get_template_part( 'shortcodes/textual-list', 'templates/textual-list', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-textual-list';
            $holder_classes[] = ! empty( $atts['direction'] ) ? 'qodef-direction--' . $atts['direction'] : '';

			return implode( ' ', $holder_classes );
		}
		
		public function get_item_classes( $atts ) {
			$item_classes   = $this->init_item_classes();
			
			$item_classes[] = 'qodef-textual-list-item';
			
			return implode( ' ', $item_classes );
		}
		
		private function get_inner_holder_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['space_between_items'] ) ) {
				if ( qode_framework_string_ends_with_typography_units( $atts['space_between_items'] ) ) {
				    if ( $atts['direction'] === 'horizontal' ) {
                        $styles[] = 'column-gap: ' . $atts['space_between_items'];
                    } else {
                        $styles[] = 'row-gap: ' . $atts['space_between_items'];
                    }
				} else {
                    if ( $atts['direction'] === 'horizontal' ) {
                        $styles[] = 'column-gap: ' . intval( $atts['space_between_items'] ) . 'px';
                    } else {
                        $styles[] = 'row-gap: ' . intval( $atts['space_between_items'] ) . 'px';
                    }
				}
			}
			
			return $styles;
		}
		
		private function get_title_styles( $atts ) {
			$styles = array();
			
			if ( ! empty( $atts['items_color'] ) ) {
				$styles[] = 'color: ' . $atts['items_color'];
			}

            $font_size = $atts['items_font_size'];
            if ( ! empty( $font_size ) ) {
                if ( qode_framework_string_ends_with_typography_units( $font_size ) ) {
                    $styles[] = 'font-size: ' . $font_size;
                } else {
                    $styles[] = 'font-size: ' . intval( $font_size ) . 'px';
                }
            }

            if ( ! empty( $atts['items_font_weight'] ) ) {
                $styles[] = 'font-weight: ' . $atts['items_font_weight'];
            }
			
			return $styles;
		}
		
		private function get_icon_styles( $atts ) {
			$styles = array();
			
			if ( ! empty( $atts['items_color'] ) ) {
				$styles[] = 'color: ' . $atts['items_color'];
			}

            $font_size = $atts['icon_font_size'];
            if ( ! empty( $font_size ) ) {
                if ( qode_framework_string_ends_with_typography_units( $font_size ) ) {
                    $styles[] = 'font-size: ' . $font_size;
                } else {
                    $styles[] = 'font-size: ' . intval( $font_size ) . 'px';
                }
            }
			
			if ( ! empty( $atts['icon_right_margin'] ) ) {
				if ( qode_framework_string_ends_with_typography_units( $atts['icon_right_margin'] ) ) {
					$styles[] = 'margin-right: ' . $atts['icon_right_margin'];
				} else {
					$styles[] = 'margin-right: ' . intval( $atts['icon_right_margin'] ) . 'px';
				}
			}
			
			return $styles;
		}
	}
}
