<?php

if ( ! function_exists( 'leroux_core_add_vertical_timeline_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_vertical_timeline_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Vertical_Timeline_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_vertical_timeline_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Vertical_Timeline_Shortcode extends LerouxCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'leroux_core_filter_vertical_timeline_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'leroux_core_filter_vertical_timeline_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/vertical-timeline' );
			$this->set_base( 'leroux_core_vertical_timeline' );
			$this->set_name( esc_html__( 'Vertical Timeline', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds vertical timeline element', 'leroux-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);

			$options_map = leroux_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'leroux-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array(
						'map_for_page_builder' => $options_map['visibility'],
						'map_for_widget'       => $options_map['visibility'],
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Item Elements', 'leroux-core' ),
					'items'      => array(
						array(
							'field_type' => 'text',
							'name'       => 'left_title',
							'title'      => esc_html__( 'Left Title', 'leroux-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'left_subtitle',
							'title'      => esc_html__( 'Left Subtitle', 'leroux-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'right_title',
							'title'      => esc_html__( 'Right Title', 'leroux-core' ),
						),
						array(
							'field_type' => 'textarea',
							'name'       => 'right_text',
							'title'      => esc_html__( 'Right Text', 'leroux-core' ),
						)
					),
					'group'      => esc_html__( 'Items', 'leroux-core' ),
				)
			);

            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'button_text',
                    'title'      => esc_html__( 'Button Text', 'leroux-core' ),
                    'group'      => esc_html__( 'Additional Content', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name'       => 'button_link',
                    'title'      => esc_html__( 'Button Link', 'leroux-core' ),
                    'group'      => esc_html__( 'Additional Content', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'button_link_target',
                    'title'         => esc_html__( 'Button Link Target', 'leroux-core' ),
                    'options'       => leroux_core_get_select_type_options_pool( 'link_target' ),
                    'default_value' => '_self',
                    'group'      => esc_html__( 'Additional Content', 'leroux-core' ),
                )
            );

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			$atts['this_shortcode'] = $this;

			return leroux_core_get_template_part( 'shortcodes/vertical-timeline', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-vertical-timeline';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';

			return implode( ' ', $holder_classes );
		}
	}
}
