<?php

if ( ! function_exists( 'leroux_core_add_social_share_variation_list' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function leroux_core_add_social_share_variation_list( $variations ) {
		$variations['list'] = esc_html__( 'List', 'leroux-core' );

		return $variations;
	}

	add_filter( 'leroux_core_filter_social_share_layouts', 'leroux_core_add_social_share_variation_list' );
	add_filter( 'leroux_core_filter_social_share_layout_options', 'leroux_core_add_social_share_variation_list' );
}

if ( ! function_exists( 'leroux_core_set_default_social_share_variation_list' ) ) {
	/**
	 * Function that set default variation layout for this module
	 *
	 * @return string
	 */
	function leroux_core_set_default_social_share_variation_list() {
		return 'list';
	}

	add_filter( 'leroux_core_filter_social_share_layout_default_value', 'leroux_core_set_default_social_share_variation_list' );
}
