<?php

if ( ! function_exists( 'leroux_core_add_social_share_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function leroux_core_add_social_share_widget( $widgets ) {
		$widgets[] = 'LerouxCore_Social_Share_Widget';

		return $widgets;
	}

	add_filter( 'leroux_core_filter_register_widgets', 'leroux_core_add_social_share_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class LerouxCore_Social_Share_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'leroux_core_social_share',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'leroux_core_social_share' );
				$this->set_name( esc_html__( 'Leroux Social Share', 'leroux-core' ) );
				$this->set_description( esc_html__( 'Add a social share element into widget areas', 'leroux-core' ) );
			}
		}

		public function render( $atts ) {
			echo LerouxCore_Social_Share_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
