<?php
$image                  = leroux_core_get_post_value_through_levels( 'qodef_spinner_image' );
$image_src              = wp_get_attachment_image_src( $image, 'full' );
$spinner_bg_image       = leroux_core_get_post_value_through_levels( 'qodef_spinner_background_image' );
$spinner_bg_image_url   = leroux_core_get_list_shortcode_item_image_url( 'full', $spinner_bg_image );
$spinner_bg_image_style = ! empty( $spinner_bg_image_url ) ? 'background-image: url( ' . esc_url( $spinner_bg_image_url ) . ')' : '';
?>
<?php if ( ! empty( $spinner_bg_image ) ) : ?>
	<span class="qodef-m-spinner-background-image" <?php qode_framework_inline_style( $spinner_bg_image_style ); ?>>
	</span>
<?php endif; ?>
<?php if ( ! empty( $image_src ) ) : ?>
<span class="qodef-m-spinner-image">
	<img itemprop="image" src="<?php echo esc_url( $image_src[0] ); ?>"
	     width="<?php echo round( $image_src[1] / 2 ); ?>" height="<?php echo round( $image_src[2] / 2 ); ?>"
	     alt="<?php echo esc_attr( $image_src[3] ); ?>"/>
</span>
<?php endif; ?>
<span class="qodef-m-spinner-svg">
	<?php leroux_render_svg_icon( 'preloader' ); ?>
</span>

