<?php
/**
 * Customer on-hold renewal order email.
 *
 * forked from WooCommerce_Subscription\Templates by Prospress
 * @package WooCommerce_Subscriptions/Templates/Emails
 * @version 3.0.0
 */

defined('ABSPATH') || exit;

/*
 * @hooked WC_Emails::email_header() Output the email header
 */
do_action('woocommerce_email_header', $email_heading, $email); ?>

<?php /* translators: %s: Customer first name */ ?>
    <p><?php printf(esc_html__('Hi %s,', 'woocommerce-subscriptions'), esc_html($order->get_billing_first_name())); ?></p>
    <p><?php esc_html_e('Thanks for your recurring donation. It’s on-hold until we confirm that payment has been received. In the meantime, here’s a reminder of your donation:', 'wc-donation-platform'); ?></p>

<?php

/*
 * @hooked WC_Subscriptions_Email::order_download_details() Shows the order details table.
 * @hooked WC_Subscriptions_Email::order_details() Shows the order details table.
 */
do_action('woocommerce_subscriptions_email_order_details', $order, $sent_to_admin, $plain_text, $email);

/*
 * @hooked WC_Emails::order_meta() Shows order meta data.
 */
do_action('woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email);

/*
 * @hooked WC_Emails::customer_details() Shows customer details
 * @hooked WC_Emails::email_address() Shows email address
 */
do_action('woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email);

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ($additional_content) {
    echo wp_kses_post(wpautop(wptexturize($additional_content)));
}

/*
 * @hooked WC_Emails::email_footer() Output the email footer
 */
do_action('woocommerce_email_footer', $email);
