<?php

if ( ! function_exists( 'leroux_get_blog_holder_classes' ) ) {
	/**
	 * Function that return classes for the main blog holder
	 *
	 * @return string
	 */
	function leroux_get_blog_holder_classes() {
		$classes = array();

		if ( is_single() ) {
			$classes[] = 'qodef--single';
		} else {
			$classes[] = 'qodef--list';
		}

		return implode( ' ', apply_filters( 'leroux_filter_blog_holder_classes', $classes ) );
	}
}

if ( ! function_exists( 'leroux_get_blog_list_excerpt_length' ) ) {
	/**
	 * Function that return number of characters for excerpt on blog list page
	 *
	 * @return int
	 */
	function leroux_get_blog_list_excerpt_length() {
		$length = apply_filters( 'leroux_filter_post_excerpt_length', 180 );

		return intval( $length );
	}
}

if ( ! function_exists( 'leroux_post_has_read_more' ) ) {
	/**
	 * Function that checks if current post has read more tag set
	 *
	 * @return int position of read more tag text. It will return false if read more tag isn't set
	 */
	function leroux_post_has_read_more() {
		global $post;

		return ! empty( $post ) ? strpos( $post->post_content, '<!--more-->' ) : false;
	}
}

if ( ! function_exists( 'leroux_blog_single_info_on_image_top_part' ) ) {
	/**
	 * Function that return classes for the page inner div from header.php
	 *
	 * @return string
	 */
	function leroux_blog_single_info_on_image_top_part() {

		if ( is_singular( 'post' ) ) {
			if( 'audio' !== get_post_format() ) {
				leroux_template_part( 'blog', 'templates/parts/post-info/image' );
			}
		}
	}

	add_action( 'leroux_action_before_page_inner', 'leroux_blog_single_info_on_image_top_part' );
}