<?php

if ( ! function_exists( 'leroux_load_page_mobile_header' ) ) {
	/**
	 * Function which loads page template module
	 */
	function leroux_load_page_mobile_header() {
		// Include mobile header template
		echo apply_filters( 'leroux_filter_mobile_header_template', leroux_get_template_part( 'mobile-header', 'templates/mobile-header' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	add_action( 'leroux_action_page_header_template', 'leroux_load_page_mobile_header' );
}

if ( ! function_exists( 'leroux_register_mobile_navigation_menus' ) ) {
	/**
	 * Function which registers navigation menus
	 */
	function leroux_register_mobile_navigation_menus() {
		$navigation_menus = apply_filters( 'leroux_filter_register_mobile_navigation_menus', array( 'mobile-navigation' => esc_html__( 'Mobile Navigation', 'leroux' ) ) );

		if ( ! empty( $navigation_menus ) ) {
			register_nav_menus( $navigation_menus );
		}
	}

	add_action( 'leroux_action_after_include_modules', 'leroux_register_mobile_navigation_menus' );
}
