<?php

if ( ! function_exists( 'leroux_core_add_blog_list_variation_compact' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function leroux_core_add_blog_list_variation_compact( $variations ) {
		$variations['compact'] = esc_html__( 'Compact', 'leroux-core' );

		return $variations;
	}

	add_filter( 'leroux_core_filter_blog_list_layouts', 'leroux_core_add_blog_list_variation_compact' );
}

if ( ! function_exists( 'leroux_core_load_blog_list_variation_compact_assets' ) ) {
	/**
	 * Function that return is global blog asses allowed for variation layout
	 *
	 * @param bool $is_enabled
	 * @param array $params
	 *
	 * @return bool
	 */
	function leroux_core_load_blog_list_variation_compact_assets( $is_enabled, $params ) {

		if ( 'compact' === $params['layout'] ) {
			$is_enabled = true;
		}

		return $is_enabled;
	}

	add_filter( 'leroux_core_filter_load_blog_list_assets', 'leroux_core_load_blog_list_variation_compact_assets', 10, 2 );
}
