<?php

if ( ! function_exists( 'leroux_core_add_content_bottom_meta_box' ) ) {
	/**
	 * Function that add general meta box options for this module
	 *
	 * @param object $page
	 */
	function leroux_core_add_content_bottom_meta_box( $page ) {

		if ( $page ) {

			$content_bottom_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-content-bottom',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'Content Bottom Settings', 'leroux-core' ),
					'description' => esc_html__( 'Content bottom layout settings', 'leroux-core' ),
				)
			);

			$content_bottom_tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_enable_content_bottom',
					'title'       => esc_html__( 'Enable Content Bottom', 'leroux-core' ),
					'description' => esc_html__( 'Use this option to enable/disable page content bottom', 'leroux-core' ),
					'options'     => leroux_core_get_select_type_options_pool( 'no_yes' ),
				)
			);
		}
	}

	add_action( 'leroux_core_action_after_general_meta_box_map', 'leroux_core_add_content_bottom_meta_box' );
}

if ( ! function_exists( 'leroux_core_add_general_page_content_bottom_meta_box_callback' ) ) {
	/**
	 * Function that set current meta box callback as general callback functions
	 *
	 * @param array $callbacks
	 *
	 * @return array
	 */
	function leroux_core_add_general_page_content_bottom_meta_box_callback( $callbacks ) {
		$callbacks['page-content-bottom'] = 'leroux_core_add_content_bottom_meta_box';

		return $callbacks;
	}

	add_filter( 'leroux_core_filter_general_meta_box_callbacks', 'leroux_core_add_general_page_content_bottom_meta_box_callback' );
}
