<?php

if ( ! function_exists( 'leroux_core_is_content_side_enabled' ) ) {
	/**
	 * Function that check is module enabled
	 *
	 * @return bool
	 */
	function leroux_core_is_content_side_enabled() {
		$is_enabled = false;
		$option     = 'no' !== leroux_core_get_post_value_through_levels( 'qodef_enable_content_side' );

		if ( $option ) {
			$is_enabled = true;
		}

		if ( ! $option ) {
			$is_enabled = false;
		}

		return apply_filters( 'leroux_core_filter_enable_content_side', $is_enabled );
	}
}

if ( ! function_exists( 'leroux_core_load_content_side' ) ) {
	/**
	 * Loads content side HTML
	 */
	function leroux_core_load_content_side() {
		if ( leroux_core_is_content_side_enabled() && ! is_404() ) {
			$params         = array();

			$params['sidebar_one'] =  'qodef-content-side-one';
			$params['sidebar_two'] =  'qodef-content-side-two';

			leroux_core_template_part( 'content-side', 'templates/content-side', '', $params );
		}
	}

	add_action( 'leroux_action_after_page_content_holder', 'leroux_core_load_content_side', 9 );
}

if ( ! function_exists( 'leroux_core_get_content_side_config' ) ) {
	/**
	 * Function that return config variables for side area
	 *
	 * @return array
	 */
	function leroux_core_get_content_side_config() {
		// Config variables
		$config = apply_filters(
			'leroux_core_filter_content_side_config',
			array(
				'title_tag'   => 'h5',
				'title_class' => 'qodef-widget-title',
			)
		);

		return $config;
	}
}

if ( ! function_exists( 'leroux_core_register_content_side_sidebars' ) ) {
	/**
	 * Register content side sidebar
	 */
	function leroux_core_register_content_side_sidebars() {
		// Sidebar config variables
		$config = leroux_core_get_content_side_config();

		register_sidebar(
			array(
				'id'            => 'qodef-content-side-one',
				'name'          => esc_html__( 'Content Side Area One', 'leroux-core' ),
				'description'   => esc_html__( 'Widgets added here will appear in content side area one', 'leroux-core' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s" data-area="side-area-one">',
				'after_widget'  => '</div>',
				'before_title'  => '<' . esc_attr( $config['title_tag'] ) . ' class="' . esc_attr( $config['title_class'] ) . '">',
				'after_title'   => '</' . esc_attr( $config['title_tag'] ) . '>',
			)
		);

		register_sidebar(
			array(
				'id'            => 'qodef-content-side-two',
				'name'          => esc_html__( 'Content Side Area Two', 'leroux-core' ),
				'description'   => esc_html__( 'Widgets added here will appear in content side area two', 'leroux-core' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s" data-area="side-area-two">',
				'after_widget'  => '</div>',
				'before_title'  => '<' . esc_attr( $config['title_tag'] ) . ' class="' . esc_attr( $config['title_class'] ) . '">',
				'after_title'   => '</' . esc_attr( $config['title_tag'] ) . '>',
			)
		);
	}

	add_action( 'widgets_init', 'leroux_core_register_content_side_sidebars' );
}

if ( ! function_exists( 'leroux_core_add_content_side_body_class' ) ) {
	/**
	 * Function that add additional class name into global class list for body tag
	 *
	 * @param array $classes
	 *
	 * @return array
	 */
	function leroux_core_add_content_side_body_class( $classes ) {

		$option = leroux_core_get_post_value_through_levels( 'qodef_enable_content_side' );

		if ( 'yes' === $option ) {
			$classes[] = 'qodef-content-side--enabled';
		}

		return $classes;
	}

	add_filter( 'body_class', 'leroux_core_add_content_side_body_class' );
}
