<?php

if ( ! function_exists( 'leroux_core_add_page_footer_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function leroux_core_add_page_footer_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => LEROUX_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'footer',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Footer', 'leroux-core' ),
				'description' => esc_html__( 'Global Footer Options', 'leroux-core' ),
			)
		);

		if ( $page ) {

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_page_footer',
					'title'         => esc_html__( 'Enable Page Footer', 'leroux-core' ),
					'description'   => esc_html__( 'Use this option to enable/disable page footer', 'leroux-core' ),
					'default_value' => 'yes',
				)
			);

			$page_footer_section = $page->add_section_element(
				array(
					'name'       => 'qodef_page_footer_section',
					'title'      => esc_html__( 'Footer Area', 'leroux-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_enable_page_footer' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			// General Footer Area Options

			$page_footer_section->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_uncovering_footer',
					'title'         => esc_html__( 'Enable Uncovering Footer', 'leroux-core' ),
					'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'leroux-core' ),
					'default_value' => 'no',
				)
			);

			// Top Footer Area Section

			$page_footer_section->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_top_footer_area',
					'title'         => esc_html__( 'Enable Top Footer Area', 'leroux-core' ),
					'description'   => esc_html__( 'Use this option to enable/disable top footer area', 'leroux-core' ),
					'default_value' => 'yes',
				)
			);

			$top_footer_area_section = $page_footer_section->add_section_element(
				array(
					'name'       => 'qodef_top_footer_area_section',
					'title'      => esc_html__( 'Top Footer Area', 'leroux-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_enable_top_footer_area' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$top_footer_area_section->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_set_footer_top_area_in_grid',
					'title'         => esc_html__( 'Top Footer Area In Grid', 'leroux-core' ),
					'description'   => esc_html__( 'Enabling this option will set page top footer area to be in grid', 'leroux-core' ),
					'default_value' => 'no',
				)
			);

			$top_footer_area_section->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_set_footer_top_area_columns',
					'title'         => esc_html__( 'Top Footer Area Columns', 'leroux-core' ),
					'description'   => esc_html__( 'Choose number of columns for top footer area', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'columns_number', true, array( '5', '6' ) ),
					'default_value' => '3',
				)
			);

			$top_footer_area_section->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_set_footer_top_column_proportions',
					'title'         => esc_html__( 'Column Proportions', 'leroux-core' ),
					'options'       => array(
						'qodef-equal-width'  => '50% + 50%',
						'qodef-predefined' => esc_html__( 'Predefined', 'leroux-core' ),
					),
					'dependency' => array(
						'show' => array(
							'qodef_set_footer_top_area_columns' => array(
								'values'        => '2',
								'default_value' => '2',
							)
						)
					)
				)
			);

			$top_footer_area_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_set_footer_top_area_grid_gutter',
					'title'       => esc_html__( 'Top Footer Area Grid Gutter', 'leroux-core' ),
					'description' => esc_html__( 'Choose grid gutter size to set space between columns for top footer area', 'leroux-core' ),
					'options'     => leroux_core_get_select_type_options_pool( 'items_space' ),
				)
			);

			$top_footer_area_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_set_footer_top_area_content_alignment',
					'title'       => esc_html__( 'Content Alignment', 'leroux-core' ),
					'description' => esc_html__( 'Set widgets content alignment inside top footer area', 'leroux-core' ),
					'options'     => array(
						''       => esc_html__( 'Default', 'leroux-core' ),
						'left'   => esc_html__( 'Left', 'leroux-core' ),
						'center' => esc_html__( 'Center', 'leroux-core' ),
						'right'  => esc_html__( 'Right', 'leroux-core' ),
					),
				)
			);

			$top_footer_area_styles_section = $top_footer_area_section->add_section_element(
				array(
					'name'  => 'qodef_top_footer_area_styles_section',
					'title' => esc_html__( 'Top Footer Area Styles', 'leroux-core' ),
				)
			);

			$top_footer_area_styles_row = $top_footer_area_styles_section->add_row_element(
				array(
					'name'  => 'qodef_top_footer_area_styles_row',
					'title' => '',
				)
			);

			$top_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_top_footer_area_padding_top',
					'title'      => esc_html__( 'Padding Top', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$top_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_top_footer_area_padding_bottom',
					'title'      => esc_html__( 'Padding Bottom', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$top_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_top_footer_area_side_padding',
					'title'      => esc_html__( 'Side Padding', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$top_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_top_footer_area_background_color',
					'title'      => esc_html__( 'Background Color', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$top_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_top_footer_area_background_image',
					'title'      => esc_html__( 'Background Image', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$top_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_top_footer_area_top_border_color',
					'title'      => esc_html__( 'Top Border Color', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$top_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_top_footer_area_top_border_width',
					'title'      => esc_html__( 'Top Border Width', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
						'suffix'    => esc_html__( 'px', 'leroux-core' ),
					),
				)
			);

			$top_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_top_footer_area_top_border_style',
					'title'      => esc_html__( 'Top Border Style', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'border_style' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$top_footer_area_styles_row_2 = $top_footer_area_styles_section->add_row_element(
				array(
					'name'  => 'qodef_top_footer_area_styles_row_2',
					'title' => '',
				)
			);

			$top_footer_area_styles_row_2->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_top_footer_area_widgets_margin_bottom',
					'title'       => esc_html__( 'Widgets Margin Bottom', 'leroux-core' ),
					'description' => esc_html__( 'Set space value between widgets', 'leroux-core' ),
					'args'        => array(
						'col_width' => 4,
					),
				)
			);

			$top_footer_area_styles_row_2->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_top_footer_area_widgets_title_margin_bottom',
					'title'       => esc_html__( 'Widgets Title Margin Bottom', 'leroux-core' ),
					'description' => esc_html__( 'Set space value between widget title and widget content', 'leroux-core' ),
					'args'        => array(
						'col_width' => 4,
					),
				)
			);

			// Bottom Footer Area Section

			$page_footer_section->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_bottom_footer_area',
					'title'         => esc_html__( 'Enable Bottom Footer Area', 'leroux-core' ),
					'description'   => esc_html__( 'Use this option to enable/disable bottom footer area', 'leroux-core' ),
					'default_value' => 'yes',
				)
			);

			$bottom_footer_area_section = $page_footer_section->add_section_element(
				array(
					'name'       => 'qodef_bottom_footer_area_section',
					'title'      => esc_html__( 'Bottom Footer Area', 'leroux-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_enable_bottom_footer_area' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$bottom_footer_area_section->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_set_footer_bottom_area_in_grid',
					'title'         => esc_html__( 'Bottom Footer Area In Grid', 'leroux-core' ),
					'description'   => esc_html__( 'Enabling this option will set page bottom footer area to be in grid', 'leroux-core' ),
					'default_value' => 'no',
				)
			);

			$bottom_footer_area_section->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_set_footer_bottom_area_columns',
					'title'         => esc_html__( 'Bottom Footer Area Columns', 'leroux-core' ),
					'description'   => esc_html__( 'Choose number of columns for bottom footer area', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'columns_number', true, array( '5', '6' ) ),
					'default_value' => '4',
				)
			);

			$bottom_footer_area_section->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_set_footer_bottom_column_proportions',
					'title'         => esc_html__( 'Column Proportions', 'leroux-core' ),
					'options'       => array(
						'qodef-equal-width'  => '25% + 25% + 25% + 25%',
						'qodef-forty-sixty' => '40% + 20% + 20% + 20%',
					),
					'dependency' => array(
						'show' => array(
							'qodef_set_footer_bottom_area_columns' => array(
								'values'        => '4',
								'default_value' => '4',
							)
						)
					)
				)
			);

			$bottom_footer_area_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_set_footer_bottom_area_grid_gutter',
					'title'       => esc_html__( 'Bottom Footer Area Grid Gutter', 'leroux-core' ),
					'description' => esc_html__( 'Choose grid gutter size to set space between columns for bottom footer area', 'leroux-core' ),
					'options'     => leroux_core_get_select_type_options_pool( 'items_space' ),
				)
			);

			$bottom_footer_area_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_set_footer_bottom_area_content_alignment',
					'title'       => esc_html__( 'Content Alignment', 'leroux-core' ),
					'description' => esc_html__( 'Set widgets content alignment inside bottom footer area', 'leroux-core' ),
					'options'     => array(
						''              => esc_html__( 'Default', 'leroux-core' ),
						'left'          => esc_html__( 'Left', 'leroux-core' ),
						'center'        => esc_html__( 'Center', 'leroux-core' ),
						'right'         => esc_html__( 'Right', 'leroux-core' ),
						'space-between' => esc_html__( 'Space Between', 'leroux-core' ),
					),
				)
			);

			$bottom_footer_area_styles_section = $bottom_footer_area_section->add_section_element(
				array(
					'name'  => 'qodef_bottom_footer_area_styles_section',
					'title' => esc_html__( 'Bottom Footer Area Styles', 'leroux-core' ),
				)
			);

			$bottom_footer_area_styles_row = $bottom_footer_area_styles_section->add_row_element(
				array(
					'name'  => 'qodef_bottom_footer_area_styles_row',
					'title' => '',
				)
			);

			$bottom_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_bottom_footer_area_padding_top',
					'title'      => esc_html__( 'Padding Top', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$bottom_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_bottom_footer_area_padding_bottom',
					'title'      => esc_html__( 'Padding Bottom', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$bottom_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_bottom_footer_area_side_padding',
					'title'      => esc_html__( 'Side Padding', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$bottom_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_bottom_footer_area_background_color',
					'title'      => esc_html__( 'Background Color', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$bottom_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_bottom_footer_area_top_border_color',
					'title'      => esc_html__( 'Top Border Color', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			$bottom_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_bottom_footer_area_top_border_width',
					'title'      => esc_html__( 'Top Border Width', 'leroux-core' ),
					'args'       => array(
						'col_width' => 3,
						'suffix'    => esc_html__( 'px', 'leroux-core' ),
					),
				)
			);

			$bottom_footer_area_styles_row->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_bottom_footer_area_top_border_style',
					'title'      => esc_html__( 'Top Border Style', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'border_style' ),
					'args'       => array(
						'col_width' => 3,
					),
				)
			);

			// Footer Copyright Area Section

			$page_footer_section->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_footer_copyright_area',
					'title'         => esc_html__( 'Enable Footer Copyright Area', 'leroux-core' ),
					'description'   => esc_html__( 'Use this option to enable/disable footer copyright area', 'leroux-core' ),
					'default_value' => 'yes',
				)
			);

			$footer_copyright_area_section = $page_footer_section->add_section_element(
				array(
					'name'       => 'qodef_footer_copyright_area_section',
					'title'      => esc_html__( 'Footer Copyright Area', 'leroux-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_enable_footer_copyright_area' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$footer_copyright_area_section->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_set_footer_copyright_area_in_grid',
					'title'         => esc_html__( 'Footer Copyright Area In Grid', 'leroux-core' ),
					'description'   => esc_html__( 'Enabling this option will set page footer copyright area to be in grid', 'leroux-core' ),
					'default_value' => 'no',
				)
			);

			$footer_copyright_area_section->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_set_footer_copyright_area_columns',
					'title'         => esc_html__( 'Footer Copyright Area Columns', 'leroux-core' ),
					'description'   => esc_html__( 'Choose number of columns for footer copyright area', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'columns_number', true, array( '5', '6' ) ),
					'default_value' => '4',
				)
			);

			$footer_copyright_area_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_set_footer_copyright_area_grid_gutter',
					'title'       => esc_html__( 'Footer Copyright Area Grid Gutter', 'leroux-core' ),
					'description' => esc_html__( 'Choose grid gutter size to set space between columns for footer copyright area', 'leroux-core' ),
					'options'     => leroux_core_get_select_type_options_pool( 'items_space' ),
				)
			);

			$footer_copyright_area_styles_section = $footer_copyright_area_section->add_section_element(
				array(
					'name'  => 'qodef_bottom_footer_area_styles_section',
					'title' => esc_html__( 'Footer Copyright Area Styles', 'leroux-core' ),
				)
			);

			$footer_copyright_area_styles_section->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_copyright_footer_area_background_color',
					'title'      => esc_html__( 'Background Color', 'leroux-core' ),
				)
			);

			$footer_copyright_area_styles_section->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_copyright_footer_area_top_border_color',
					'title'      => esc_html__( 'Top Border Color', 'leroux-core' ),
				)
			);

			$footer_copyright_area_styles_section->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_copyright_footer_area_top_border_width',
					'title'      => esc_html__( 'Top Border Width', 'leroux-core' ),
					'args'       => array(
						'suffix' => esc_html__( 'px', 'leroux-core' ),
					),
				)
			);

			// Hook to include additional options after module options
			do_action( 'leroux_core_action_after_page_footer_options_map', $page );
		}
	}

	add_action( 'leroux_core_action_default_options_init', 'leroux_core_add_page_footer_options', leroux_core_get_admin_options_map_position( 'footer' ) );
}
