<?php

if ( ! function_exists( 'leroux_core_add_general_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function leroux_core_add_general_options( $page ) {

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_main_color',
					'title'       => esc_html__( 'Main Color', 'leroux-core' ),
					'description' => esc_html__( 'Choose the most dominant theme color', 'leroux-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_page_background_color',
					'title'       => esc_html__( 'Page Background Color', 'leroux-core' ),
					'description' => esc_html__( 'Set background color', 'leroux-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_page_background_image',
					'title'       => esc_html__( 'Page Background Image', 'leroux-core' ),
					'description' => esc_html__( 'Set background image', 'leroux-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_repeat',
					'title'       => esc_html__( 'Page Background Image Repeat', 'leroux-core' ),
					'description' => esc_html__( 'Set background image repeat', 'leroux-core' ),
					'options'     => array(
						''          => esc_html__( 'Default', 'leroux-core' ),
						'no-repeat' => esc_html__( 'No Repeat', 'leroux-core' ),
						'repeat'    => esc_html__( 'Repeat', 'leroux-core' ),
						'repeat-x'  => esc_html__( 'Repeat-x', 'leroux-core' ),
						'repeat-y'  => esc_html__( 'Repeat-y', 'leroux-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_size',
					'title'       => esc_html__( 'Page Background Image Size', 'leroux-core' ),
					'description' => esc_html__( 'Set background image size', 'leroux-core' ),
					'options'     => array(
						''        => esc_html__( 'Default', 'leroux-core' ),
						'contain' => esc_html__( 'Contain', 'leroux-core' ),
						'cover'   => esc_html__( 'Cover', 'leroux-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_attachment',
					'title'       => esc_html__( 'Page Background Image Attachment', 'leroux-core' ),
					'description' => esc_html__( 'Set background image attachment', 'leroux-core' ),
					'options'     => array(
						''       => esc_html__( 'Default', 'leroux-core' ),
						'fixed'  => esc_html__( 'Fixed', 'leroux-core' ),
						'scroll' => esc_html__( 'Scroll', 'leroux-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding',
					'title'       => esc_html__( 'Page Content Padding', 'leroux-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'leroux-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding_mobile',
					'title'       => esc_html__( 'Page Content Padding Mobile', 'leroux-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content on mobile screens (1024px and below) in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'leroux-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_boxed',
					'title'         => esc_html__( 'Boxed Layout', 'leroux-core' ),
					'description'   => esc_html__( 'Set boxed layout', 'leroux-core' ),
					'default_value' => 'no',
				)
			);

			$boxed_section = $page->add_section_element(
				array(
					'name'       => 'qodef_boxed_section',
					'title'      => esc_html__( 'Boxed Layout Section', 'leroux-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_boxed' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_boxed_background_color',
					'title'       => esc_html__( 'Boxed Background Color', 'leroux-core' ),
					'description' => esc_html__( 'Set boxed background color', 'leroux-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_boxed_background_pattern',
					'title'       => esc_html__( 'Boxed Background Pattern', 'leroux-core' ),
					'description' => esc_html__( 'Set boxed background pattern', 'leroux-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_boxed_background_pattern_behavior',
					'title'       => esc_html__( 'Boxed Background Pattern Behavior', 'leroux-core' ),
					'description' => esc_html__( 'Set boxed background pattern behavior', 'leroux-core' ),
					'options'     => array(
						'fixed'  => esc_html__( 'Fixed', 'leroux-core' ),
						'scroll' => esc_html__( 'Scroll', 'leroux-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_passepartout',
					'title'         => esc_html__( 'Passepartout', 'leroux-core' ),
					'description'   => esc_html__( 'Enabling this option will display a passepartout around website content', 'leroux-core' ),
					'default_value' => 'no',
				)
			);

			$passepartout_section = $page->add_section_element(
				array(
					'name'       => 'qodef_passepartout_section',
					'title'      => esc_html__( 'Passepartout Section', 'leroux-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_passepartout' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_passepartout_color',
					'title'       => esc_html__( 'Passepartout Color', 'leroux-core' ),
					'description' => esc_html__( 'Choose background color for passepartout', 'leroux-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_passepartout_image',
					'title'       => esc_html__( 'Passepartout Background Image', 'leroux-core' ),
					'description' => esc_html__( 'Set background image for passepartout', 'leroux-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size',
					'title'       => esc_html__( 'Passepartout Size', 'leroux-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout', 'leroux-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'leroux-core' ),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size_responsive',
					'title'       => esc_html__( 'Passepartout Responsive Size', 'leroux-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (1024px and below)', 'leroux-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'leroux-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_content_width',
					'title'         => esc_html__( 'Initial Width of Content', 'leroux-core' ),
					'description'   => esc_html__( 'Choose the initial width of content which is in grid (applies to pages set to "Default Template" and rows set to "In Grid")', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'content_width', false ),
					'default_value' => '1100',
				)
			);

			// Hook to include additional options after module options
			do_action( 'leroux_core_action_after_general_options_map', $page );

			$page->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_custom_js',
					'title'       => esc_html__( 'Custom JS', 'leroux-core' ),
					'description' => esc_html__( 'Enter your custom JavaScript here', 'leroux-core' ),
				)
			);
		}
	}

	add_action( 'leroux_core_action_default_options_init', 'leroux_core_add_general_options', leroux_core_get_admin_options_map_position( 'general' ) );
}
