<?php

if ( ! function_exists( 'leroux_core_add_minimal_header_meta' ) ) {
	/**
	 * Function that add additional header layout meta box options
	 *
	 * @param object $page
	 */
	function leroux_core_add_minimal_header_meta( $page ) {

		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_minimal_header_section',
				'title'      => esc_html__( 'Minimal Header', 'leroux-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => 'minimal',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_minimal_header_in_grid',
				'title'         => esc_html__( 'Content in Grid', 'leroux-core' ),
				'description'   => esc_html__( 'Set content to be in grid', 'leroux-core' ),
				'default_value' => '',
				'options'       => leroux_core_get_select_type_options_pool( 'no_yes' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_height',
				'title'       => esc_html__( 'Header Height', 'leroux-core' ),
				'description' => esc_html__( 'Enter header height', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'leroux-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_minimal_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'leroux-core' ),
				'description' => esc_html__( 'Enter header background color', 'leroux-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_minimal_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'leroux-core' ),
				'description' => esc_html__( 'Enter header border color', 'leroux-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'leroux-core' ),
				'description' => esc_html__( 'Enter header border width size', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_minimal_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'leroux-core' ),
				'description' => esc_html__( 'Choose header border style', 'leroux-core' ),
				'options'     => leroux_core_get_select_type_options_pool( 'border_style' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_minimal_header_hide_menu_opener',
				'title'         => esc_html__( 'Hide Menu Opener', 'leroux-core' ),
				'options'       => leroux_core_get_select_type_options_pool('yes_no'),
				'default_value' => ''
			)
		);
	}

	add_action( 'leroux_core_action_after_page_header_meta_map', 'leroux_core_add_minimal_header_meta' );
}
