<?php

if ( ! function_exists( 'leroux_core_add_standard_extended_header_meta' ) ) {
	/**
	 * Function that add additional header layout meta box options
	 *
	 * @param object $page
	 */
	function leroux_core_add_standard_extended_header_meta( $page ) {
		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_standard_extended_header_section',
				'title'      => esc_html__( 'Standard Extended Header', 'leroux-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => array( 'standard-extended' ),
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type' => 'select',
				'name'       => 'qodef_standard_extended_show_extended_dropdown',
				'title'      => esc_html__( 'Show Extended Dropdown', 'leroux-core' ),
				'options'    => leroux_core_get_select_type_options_pool( 'yes_no' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_extended_extended_dropdown_opener_label',
				'title'       => esc_html__( 'Extended Dropdown Opener Label', 'leroux-core' ),
				'description' => esc_html__( 'Set Extended Dropdown Opener Label, or leave empty for default value.', 'leroux-core' ),
				'dependency'  => array(
					'show' => array(
						'show_extended_dropdown' => array(
							'values'        => array( '', 'yes' ),
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_standard_extended_header_in_grid',
				'title'         => esc_html__( 'Content in Grid', 'leroux-core' ),
				'description'   => esc_html__( 'Set content to be in grid', 'leroux-core' ),
				'default_value' => '',
				'options'       => leroux_core_get_select_type_options_pool( 'no_yes' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_extended_header_height',
				'title'       => esc_html__( 'Header Height', 'leroux-core' ),
				'description' => esc_html__( 'Enter header height', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_extended_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'leroux-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_extended_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'leroux-core' ),
				'description' => esc_html__( 'Enter header background color', 'leroux-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_extended_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'leroux-core' ),
				'description' => esc_html__( 'Enter header border color', 'leroux-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_extended_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'leroux-core' ),
				'description' => esc_html__( 'Enter header border width size', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_standard_extended_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'leroux-core' ),
				'description' => esc_html__( 'Choose header border style', 'leroux-core' ),
				'options'     => leroux_core_get_select_type_options_pool( 'border_style' ),
			)
		);
	}

	add_action( 'leroux_core_action_after_page_header_meta_map', 'leroux_core_add_standard_extended_header_meta' );
}
