<?php

if ( ! function_exists( 'leroux_core_add_standard_header_options' ) ) {
	/**
	 * Function that add additional header layout options
	 *
	 * @param object $page
	 * @param array $general_header_tab
	 */
	function leroux_core_add_standard_header_options( $page, $general_header_tab ) {

		$section = $general_header_tab->add_section_element(
			array(
				'name'        => 'qodef_standard_header_section',
				'title'       => esc_html__( 'Standard Header', 'leroux-core' ),
				'description' => esc_html__( 'Standard header settings', 'leroux-core' ),
				'dependency'  => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => 'standard',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'yesno',
				'name'          => 'qodef_standard_header_in_grid',
				'title'         => esc_html__( 'Content in Grid', 'leroux-core' ),
				'description'   => esc_html__( 'Set content to be in grid', 'leroux-core' ),
				'default_value' => 'no',
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_height',
				'title'       => esc_html__( 'Header Height', 'leroux-core' ),
				'description' => esc_html__( 'Enter header height', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'leroux-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_menu_item_side_padding',
				'title'       => esc_html__( 'Menu item Side Padding', 'leroux-core' ),
				'description' => esc_html__( 'Enter side padding for menu items', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'teinte-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_menu_item_side_padding_responsive',
				'title'       => esc_html__( 'Menu item Side Padding Responsive', 'leroux-core' ),
				'description' => esc_html__( 'Enter side padding for menu items on screens of 1440px and lower', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'teinte-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'leroux-core' ),
				'description' => esc_html__( 'Enter header background color', 'leroux-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'leroux-core' ),
				'description' => esc_html__( 'Enter header border color', 'leroux-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'leroux-core' ),
				'description' => esc_html__( 'Enter header border width size', 'leroux-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_standard_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'leroux-core' ),
				'description' => esc_html__( 'Choose header border style', 'leroux-core' ),
				'options'     => leroux_core_get_select_type_options_pool( 'border_style' ),
			)
		);
		
		$section->add_field_element(
			array(
				'field_type'    => 'yesno',
				'name'          => 'qodef_standard_header_enable_top_border',
				'title'         => esc_html__( 'Enable Header Top Border', 'leroux-core' ),
				'default_value' => 'no',
				'description'   => esc_html__( 'By default only bottom border will be shown. Enable this option if you want top border as well', 'leroux-core' ),
			)
		);
		
		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_top_offset',
				'title'       => esc_html__( 'Header Top Offset', 'leroux-core' ),
				'args'        => array(
					'suffix'  => esc_html__( 'px', 'leroux-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_standard_header_menu_position',
				'title'         => esc_html__( 'Menu position', 'leroux-core' ),
				'default_value' => 'right',
				'options'       => array(
					'left'   => esc_html__( 'Left', 'leroux-core' ),
					'center' => esc_html__( 'Center', 'leroux-core' ),
					'right'  => esc_html__( 'Right', 'leroux-core' ),
				),
			)
		);
	}

	add_action( 'leroux_core_action_after_header_options_map', 'leroux_core_add_standard_header_options', 10, 2 );
}
