<?php

if ( ! function_exists( 'leroux_core_add_tabbed_header_global_option' ) ) {
	/**
	 * This function set header type value for global header option map
	 */

	function leroux_core_add_tabbed_header_global_option( $header_layout_options ) {
		$header_layout_options['tabbed'] = array(
			'image' => LEROUX_CORE_HEADER_LAYOUTS_URL_PATH . '/tabbed/assets/img/tabbed-header.png',
			'label' => esc_html__( 'Tabbed', 'leroux-core' ),
		);

		return $header_layout_options;
	}

	add_filter( 'leroux_core_filter_header_layout_option', 'leroux_core_add_tabbed_header_global_option' );
}

if ( ! function_exists( 'leroux_core_register_tabbed_header_layout' ) ) {
	/**
	 * Function which add header layout into global list
	 *
	 * @param array $header_layouts
	 *
	 * @return array
	 */
	function leroux_core_register_tabbed_header_layout( $header_layouts ) {
		$header_layouts['tabbed'] = 'LerouxCore_Tabbed_Header';

		return $header_layouts;
	}

	add_filter( 'leroux_core_filter_register_header_layouts', 'leroux_core_register_tabbed_header_layout' );
}
