<?php

if ( ! function_exists( 'leroux_core_add_vertical_sliding_header_meta' ) ) {
	/**
	 * Function that add additional header layout meta box options
	 *
	 * @param object $page
	 */
	function leroux_core_add_vertical_sliding_header_meta( $page ) {

		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_vertical_sliding_header_section',
				'title'      => esc_html__( 'Vertical Sliding Header', 'leroux-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => 'vertical-sliding',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_vertical_sliding_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'leroux-core' ),
				'description' => esc_html__( 'Enter header background color', 'leroux-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_vertical_sliding_header_blur_background',
				'title'       => esc_html__( 'Blur Background', 'leroux-core' ),
				'description' => esc_html__( 'Enabled blurred header background', 'leroux-core' ),
				'options'     => leroux_core_get_select_type_options_pool( 'no_yes' )
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'yesno',
				'name'        => 'qodef_vertical_sliding_header_content_behind_header',
				'title'       => esc_html__( 'Content Behind Header', 'leroux-core' ),
				'description' => esc_html__( 'Choose to put content behind header', 'leroux-core' ),
				'default_value' => 'no'
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_vertical_sliding_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'leroux-core' ),
				'description' => esc_html__( 'Choose header border color', 'leroux-core' )
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_vertical_sliding_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'leroux-core' ),
				'description' => esc_html__( 'Choose header border width', 'leroux-core' ),
				'args'       => array(
					'suffix'    => 'px',
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_vertical_sliding_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'leroux-core' ),
				'description' => esc_html__( 'Choose header border style', 'leroux-core' ),
				'options' => leroux_core_get_select_type_options_pool( 'border_style' )
			)
		);
	}

	add_action( 'leroux_core_action_after_page_header_meta_map', 'leroux_core_add_vertical_sliding_header_meta' );
}

if ( ! function_exists( 'leroux_core_add_vertical_sliding_header_logo_meta_options' ) ) {
	/**
	 * Function that add additional header logo meta box options
	 *
	 * @param object $page
	 * @param array $header_page
	 * @param array $logo_image_section
	 */
	function leroux_core_add_vertical_sliding_header_logo_meta_options( $page, $header_page, $logo_image_section ) {

		if ( $header_page ) {
			$logo_image_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_logo_vertical_sliding',
					'title'       => esc_html__( 'Logo - Vertical Sliding', 'leroux-core' ),
					'description' => esc_html__( 'Choose vertical sliding area logo image', 'leroux-core' ),
					'multiple'    => 'no',
				)
			);
		}
	}

	add_action( 'leroux_core_action_after_header_logo_image_section_meta_map', 'leroux_core_add_vertical_sliding_header_logo_meta_options', 10, 3 );
}
