<?php

if ( ! function_exists( 'leroux_core_add_clients_list_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_clients_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Clients_List_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_clients_list_shortcode' );
}

if ( class_exists( 'LerouxCore_List_Shortcode' ) ) {
	class LerouxCore_Clients_List_Shortcode extends LerouxCore_List_Shortcode {

		public function __construct() {
			$this->set_post_type( 'clients' );
			$this->set_post_type_additional_taxonomies( array( 'clients-category' ) );
			$this->set_layouts( apply_filters( 'leroux_core_filter_clients_list_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'leroux_core_filter_clients_list_extra_options', array() ) );
			$this->set_hover_animation_options( apply_filters( 'leroux_core_filter_clients_list_hover_animation_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_CPT_URL_PATH . '/clients/shortcodes/clients-list' );
			$this->set_base( 'leroux_core_clients_list' );
			$this->set_name( esc_html__( 'Clients List', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of clients', 'leroux-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);
			$this->map_list_options(
				array(
					'exclude_behavior' => array( 'masonry', 'justified-gallery' ),
					'exclude_option'   => array( 'images_proportion' ),
				)
			);
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->map_layout_options(
				array(
					'layouts'          => $this->get_layouts(),
					'hover_animations' => $this->get_hover_animation_options(),
					'exclude_option'   => array( 'title_tag', 'text_transform' ),
				)
			);
			$this->set_option(
				array(
					'name'        => 'retina_scaling',
					'field_type'  => 'select',
					'title'       => esc_html__( 'Enable Retina Scaling', 'leroux-core' ),
					'options'     => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'description' => esc_html__( 'Uploaded Client Images should be two times the size.', 'masterds-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'initial_opacity',
					'title'         => esc_html__( 'Initial Opacity', 'leroux-core' ),
					'description'   => esc_html__( 'Enter value for initial image opacity. Value can be between 0 and 1', '' ),
					'default_value' => '1',
					'dependency'    => array(
						'show' => array(
							'hover_animation_image-only' => array(
								'values'        => 'fade',
								'default_value' => '',
							),
						),
					),
					'group'         => esc_html__( 'Layout', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'hover_opacity',
					'title'         => esc_html__( 'Hover Opacity', 'leroux-core' ),
					'description'   => esc_html__( 'Enter value for image opacity when hovered. Value can be between 0 and 1', '' ),
					'default_value' => '.5',
					'dependency'    => array(
						'show' => array(
							'hover_animation_image-only' => array(
								'values'        => 'fade',
								'default_value' => '',
							),
						),
					),
					'group'         => esc_html__( 'Layout', 'leroux-core' ),
				)
			);
            $this->set_option(
                array(
                    'field_type'    => 'text',
                    'name'          => 'box_height',
                    'title'         => esc_html__( 'Box Height (px)', 'leroux-core' ),
                    'default_value' => '',
                    'dependency'    => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'boxed',
                                'default_value' => '',
                            ),
                        ),
                    ),
                    'group'         => esc_html__( 'Layout', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'color',
                    'name'          => 'box_background_color',
                    'title'         => esc_html__( 'Box Background Color', 'leroux-core' ),
                    'default_value' => '',
                    'dependency'    => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'boxed',
                                'default_value' => '',
                            ),
                        ),
                    ),
                    'group'         => esc_html__( 'Layout', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'color',
                    'name'          => 'box_border_color',
                    'title'         => esc_html__( 'Box Border Color', 'leroux-core' ),
                    'default_value' => '',
                    'dependency'    => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'boxed',
                                'default_value' => '',
                            ),
                        ),
                    ),
                    'group'         => esc_html__( 'Layout', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'box_height_1440',
                    'title'       => esc_html__( 'Box Height 1440', 'leroux-core' ),
                    'description' => esc_html__( 'Set responsive style value for screen size 1440', 'leroux-core' ),
                    'group'       => esc_html__( 'Responsive Style', 'leroux-core' ),
                    'dependency'    => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'boxed',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'box_height_1366',
                    'title'       => esc_html__( 'Box Height 1366', 'leroux-core' ),
                    'description' => esc_html__( 'Set responsive style value for screen size 1366', 'leroux-core' ),
                    'group'       => esc_html__( 'Responsive Style', 'leroux-core' ),
                    'dependency'    => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'boxed',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'box_height_1024',
                    'title'       => esc_html__( 'Box Height 1024', 'leroux-core' ),
                    'description' => esc_html__( 'Set responsive style value for screen size 1024', 'leroux-core' ),
                    'group'       => esc_html__( 'Responsive Style', 'leroux-core' ),
                    'dependency'    => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'boxed',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'box_height_768',
                    'title'       => esc_html__( 'Box Height 768', 'leroux-core' ),
                    'description' => esc_html__( 'Set responsive style value for screen size 768', 'leroux-core' ),
                    'group'       => esc_html__( 'Responsive Style', 'leroux-core' ),
                    'dependency'    => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'boxed',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'box_height_680',
                    'title'       => esc_html__( 'Box Height 680', 'leroux-core' ),
                    'description' => esc_html__( 'Set responsive style value for screen size 680', 'leroux-core' ),
                    'group'       => esc_html__( 'Responsive Style', 'leroux-core' ),
                    'dependency'    => array(
                        'show' => array(
                            'layout' => array(
                                'values'        => 'boxed',
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type'] = $this->get_post_type();

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

            $atts['unique_class']        = 'qodef-clients-list-' . rand( 0, 1000 );
			$atts['holder_classes']      = $this->get_holder_classes( $atts );
			$atts['holder_styles']       = $this->get_holder_styles( $atts );
			$atts['holder_inner_styles'] = $this->get_holder_inner_styles( $atts );
			$atts['item_classes']        = $this->get_item_classes( $atts );
			$atts['slider_attr']         = $this->get_slider_data( $atts );
			$atts['query_result']        = new WP_Query( leroux_core_get_query_params( $atts ) );
            $this->set_responsive_styles( $atts );

			return leroux_core_get_template_part( 'post-types/clients/shortcodes/clients-list', 'templates/content', $atts['behavior'], $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-clients-list';
            $holder_classes[] = $atts['unique_class'];

			$list_classes            = $this->get_list_classes( $atts );
			$hover_animation_classes = $this->get_hover_animation_classes( $atts );
			$holder_classes          = array_merge( $holder_classes, $list_classes, $hover_animation_classes );

			return implode( ' ', $holder_classes );
		}

		private function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_list_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		private function get_holder_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['initial_opacity'] ) ) {
				$styles[] = '--qodef-client-initial-opacity: ' . min( $atts['initial_opacity'], 1 );
			}

			if ( ! empty( $atts['hover_opacity'] ) ) {
				$styles[] = '--qodef-client-hover-opacity: ' . min( $atts['hover_opacity'], 1 );
			}

			if ( ! empty( $atts['box_border_color'] ) ) {
				$styles[] = '--qodef-client-box-border-color: ' . $atts['box_border_color'];
			}

			return $styles;
		}

        private function get_holder_inner_styles( $atts ) {
            $styles = array();

            if ( ! empty( $atts['box_height'] ) ) {
                $styles[] = 'height: ' . intval( $atts['box_height'] ) . 'px';
            }

            if ( ! empty( $atts['box_background_color'] ) ) {
                $styles[] = 'background-color: ' . $atts['box_background_color'];
            }

            return $styles;
        }

        private function set_responsive_styles( $atts ) {

		    if ( $atts['layout'] === 'boxed' ) {

                $unique_class = '.' . $atts['unique_class'] . ' .qodef-e-inner';
                $screen_sizes = array( '1440', '1366', '1024', '768', '680' );
                $option_keys  = array( 'box_height' );

                foreach ( $screen_sizes as $screen_size ) {
                    $styles = array();

                    foreach ( $option_keys as $option_key ) {
                        $option_value = $atts[ $option_key . '_' . $screen_size ];
                        $style_key    = str_replace( 'box_', '', $option_key );

                        if ( '' !== $option_value ) {
                            if ( qode_framework_string_ends_with_typography_units( $option_value ) ) {
                                $styles[ $style_key ] = $option_value . '!important';
                            } else {
                                $styles[ $style_key ] = intval( $option_value ) . 'px !important';
                            }
                        }
                    }

                    if ( ! empty( $styles ) ) {
                        add_filter(
                            'leroux_core_filter_add_responsive_' . $screen_size . '_inline_style_in_footer',
                            function ( $style ) use ( $unique_class, $styles ) {
                                $style .= qode_framework_dynamic_style( $unique_class, $styles );

                                return $style;
                            }
                        );
                    }
                }
            }
        }
	}
}
