<?php

if ( ! function_exists( 'leroux_core_add_testimonials_meta_box' ) ) {
	/**
	 * Function that adds fields for testimonials
	 */
	function leroux_core_add_testimonials_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'testimonials' ),
				'type'  => 'meta',
				'slug'  => 'testimonials',
				'title' => esc_html__( 'Testimonials Parameters', 'leroux-core' ),
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_testimonials_title',
					'title'      => esc_html__( 'Title', 'leroux-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'textarea',
					'name'       => 'qodef_testimonials_text',
					'title'      => esc_html__( 'Text', 'leroux-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_testimonials_author',
					'title'      => esc_html__( 'Author', 'leroux-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_testimonials_author_job',
					'title'      => esc_html__( 'Author Job Title', 'leroux-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_testimonials_rating',
					'title'      => esc_html__( 'Rating', 'leroux-core' ),
					'options'    => array(
						'' => esc_html__( 'No Rating', 'leroux-core' ),
						'1' => esc_html__( 'One Star', 'leroux-core' ),
						'2' => esc_html__( 'Two Stars', 'leroux-core' ),
						'3' => esc_html__( 'Three Stars', 'leroux-core' ),
						'4' => esc_html__( 'Four Stars', 'leroux-core' ),
						'5' => esc_html__( 'Five Stars', 'leroux-core' ),
					),
					'default_value' => ''
				)
			);
			
			$page->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_testimonials_signature_graphic',
					'title'      => esc_html__( 'Author Signature Graphic', 'leroux-core' ),
				)
			);

            $page->add_field_element(
                array(
                    'field_type' => 'color',
                    'name'       => 'qodef_testimonials_background_color',
                    'title'      => esc_html__( 'Background Color', 'leroux-core' ),
                    'description' => esc_html__( 'Choose color that will be used as background of testimonial item in Testimonials List - Info Beside layout', 'leroux-core' ),
                )
            );

			// Hook to include additional options after module options
			do_action( 'leroux_core_action_after_testimonials_meta_box_map', $page );
		}
	}

	add_action( 'leroux_core_action_default_meta_boxes_init', 'leroux_core_add_testimonials_meta_box' );
}
