<?php

if ( ! function_exists( 'leroux_core_register_covers_header_search_layout' ) ) {
	/**
	 * Function that add variation layout into global list
	 *
	 * @param array $search_layouts
	 *
	 * @return array
	 */
	function leroux_core_register_covers_header_search_layout( $search_layouts ) {
		$search_layouts['covers-header'] = 'LerouxCore_Covers_Header_Search';

		return $search_layouts;
	}

	add_filter( 'leroux_core_filter_register_search_layouts', 'leroux_core_register_covers_header_search_layout' );
}

if ( ! function_exists( 'leroux_core_set_search_covers_header_styles' ) ) {
	/**
	 * Function that generates module inline styles
	 *
	 * @param string $style
	 *
	 * @return string
	 */
	function leroux_core_set_search_covers_header_styles( $style ) {
		$styles = array();

		$is_top_area_enabled = leroux_core_get_post_value_through_levels( 'qodef_top_area_header' );

		if ( $is_top_area_enabled === 'yes' ) {

			$top_area_height = leroux_core_get_post_value_through_levels( 'qodef_top_area_header_height' );

			if ( empty( $top_area_height ) ) {
				$top_area_height = 40;
			}

			$styles['top'] = '-' . intval( $top_area_height ) . 'px';
			$styles['height'] = 'calc( 100% + ' . intval( $top_area_height ) . 'px )' ;
		}

		$style .= qode_framework_dynamic_style( array( '.qodef-search-cover-form'),	$styles );

		return $style;
	}

	add_filter( 'leroux_filter_add_inline_style', 'leroux_core_set_search_covers_header_styles' );
}
