<?php

if ( ! function_exists( 'leroux_core_add_charts_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param $shortcodes array
	 *
	 * @return array
	 */
	function leroux_core_add_charts_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Charts_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_charts_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Charts_Shortcode extends LerouxCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'leroux_core_filter_charts_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'leroux_core_filter_charts_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/charts' );
			$this->set_base( 'leroux_core_charts' );
			$this->set_name( esc_html__( 'Charts', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds charts element', 'leroux-core' ) );
			$this->set_category( esc_html__( 'Leroux Core', 'leroux-core' ) );

			$no_of_datasets = 3;
			$no_of_points   = 12;

			$this->set_scripts(
				array(
					'charts' => array(
						'registered' => false,
						'url'        => LEROUX_CORE_INC_URL_PATH . '/shortcodes/charts/assets/js/plugins/charts.min.js',
						'dependency' => ( 'jquery' )
					)
				)
			);

			// first point group w/o dependency
			$points_array[] = array(
				'field_type' => 'select',
				'title'      => esc_html__( 'Use Point Group 1', 'leroux-core' ),
				'name'       => 'points_1',
				'options'    => leroux_core_get_select_type_options_pool( 'yes_no' ),
				'group'      => esc_html__( 'Points', 'leroux-core' ),
			);

			$points_array[] = array(
				'field_type' => 'color',
				'title'      => esc_html__( 'Point 1 Color', 'leroux-core' ),
				'name'       => 'point_1_color',
				'group'      => esc_html__( 'Points', 'leroux-core' ),
			);

			$points_array[] = array(
				'field_type' => 'text',
				'title'      => esc_html__( 'Point 1 Label', 'leroux-core' ),
				'name'       => 'point_1_label',
				'group'      => esc_html__( 'Points', 'leroux-core' ),
			);

			// from second to twelfth w/ dependency
			for ( $i = 1; $i <= $no_of_points; $i ++ ) {
				$points_array[] = array(
					'field_type' => 'select',
					'title'      => esc_html__( 'Use Point Group ', 'leroux-core' ) . $i,
					'name'       => 'points_' . $i,
					'options'    => leroux_core_get_select_type_options_pool( 'no_yes' ),
					'group'      => esc_html__( 'Points', 'leroux-core' ),
				);

				$points_array[] = array(
					'field_type' => 'color',
					'title'      => esc_html__( 'Point ', 'leroux-core' ) . $i . esc_html__( ' Color', 'leroux-core' ),
					'name'       => 'point_' . $i . '_color',
					'group'      => esc_html__( 'Points', 'leroux-core' ),
					'dependency' => array(
						'show' => array(
							'points_' . $i => array(
								'values'        => 'yes',
								'default_value' => ''
							)
						)
					)
				);

				$points_array[] = array(
					'field_type' => 'text',
					'title'      => esc_html__( 'Point ', 'leroux-core' ) . $i . esc_html__( ' Label', 'leroux-core' ),
					'name'       => 'point_' . $i . '_label',
					'group'      => esc_html__( 'Points', 'leroux-core' ),
					'dependency' => array(
						'show' => array(
							'points_' . $i => array(
								'values'        => 'yes',
								'default_value' => ''
							)
						)
					)
				);
			}

			/*
	        * dataset tabs begin
		    */

			for ( $i = 1; $i <= $no_of_datasets; $i ++ ) { // no of datasets

				$dataset_array[] = array(
					'field_type' => 'text',
					'title'      => esc_html__( 'Dataset ', 'leroux-core' ) . $i . esc_html__( ' Label', 'leroux-core' ),
					'name'       => 'dataset_' . $i . '_label',
					'group'      => esc_html__( 'Dataset ', 'leroux-core' ) . $i,
				);

				$dataset_array[] = array(
					'field_type' => 'color',
					'title'      => esc_html__( 'Dataset ', 'leroux-core' ) . $i . esc_html__( ' Color', 'leroux-core' ),
					'name'       => 'dataset_' . $i . '_color',
					'group'      => esc_html__( 'Dataset ', 'leroux-core' ) . $i,
					'dependency' => array(
						'show' => array(
							'color_scheme' => array(
								'values'        => 'dataset',
								'default_value' => ''
							)
						)
					)
				);

				for ( $j = 1; $j <= $no_of_points; $j ++ ) { // no of points in dataset
					$dataset_array[] = array(
						'field_type' => 'text',
						'title'      => esc_html__( 'Point ', 'leroux-core' ) . $j . esc_html__( ' Value', 'leroux-core' ),
						'name'       => 'point_' . $i . '_' . $j,
						'group'      => esc_html__( 'Dataset ', 'leroux-core' ) . $i,
						'dependency' => array(
							'show' => array(
								'points_' . $j => array(
									'values'        => 'yes',
									'default_value' => ''
								)
							)
						)
					);
				}
			}

			$this->set_option(
				array(
					'field_type'    => 'select',
					'title'         => esc_html__( 'Type', 'leroux-core' ),
					'name'          => 'type',
					'options'       => array(
						'line'          => esc_html__( 'Line', 'leroux-core' ),
						'bar'           => esc_html__( 'Vertical Bars', 'leroux-core' ),
						'horizontalBar' => esc_html__( 'Horizontal Bars', 'leroux-core' ),
						'radar'         => esc_html__( 'Radar', 'leroux-core' ),
						'pie'           => esc_html__( 'Pie', 'leroux-core' ),
						'doughnut'      => esc_html__( 'Doughnut', 'leroux-core' ),
					),
                    'default_value' => 'line',
				)
			);

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'title'         => esc_html__( 'Line Tension', 'leroux-core' ),
                    'name'          => 'line_tension',
                    'options'       => array(
                        'smooth' => esc_html__( 'Smooth', 'leroux-core' ),
                        'sharp'  => esc_html__( 'Sharp', 'leroux-core' ),
                    ),
                    'default_value' => 'smooth',
                    'dependency' => array(
                        'show' => array(
                            'type' => array(
                                'values'        => 'line',
                                'default_value' => 'line',
                            ),
                        ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'title'         => esc_html__( 'Fill Shape', 'leroux-core' ),
                    'name'          => 'fill_shape',
                    'options'       => leroux_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                    'dependency' => array(
                        'show' => array(
                            'type' => array(
                                'values'        => 'line',
                                'default_value' => 'line',
                            ),
                        ),
                    ),
                )
            );
			
			$this->set_option(
				array(
					'field_type'    => 'text',
					'title'         => esc_html__( 'Size', 'leroux-core' ),
					'name'          => 'chart_size',
					'dependency' => array(
						'show' => array(
							'type' => array(
								'values'        => array( 'pie', 'doughnut' ),
								'default_value' => 'line',
							),
						),
					),
				)
			);

            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'horizontal_alignment',
                    'title'      => esc_html__( 'Horizontal Alignment', 'leroux-core' ),
                    'options'    => array(
                        ''       => esc_html__( 'Default', 'leroux-core' ),
                        'left'   => esc_html__( 'Left', 'leroux-core' ),
                        'center' => esc_html__( 'Center', 'leroux-core' ),
                        'right'  => esc_html__( 'Right', 'leroux-core' ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'vertical_alignment',
                    'title'      => esc_html__( 'Vertical Alignment', 'leroux-core' ),
                    'options'    => array(
                        ''       => esc_html__( 'Default', 'leroux-core' ),
                        'top'    => esc_html__( 'Top', 'leroux-core' ),
                        'middle' => esc_html__( 'Middle', 'leroux-core' ),
                        'bottom' => esc_html__( 'Bottom', 'leroux-core' ),
                    ),
                )
            );

			$this->set_option(
				array(
					'field_type' => 'select',
					'title'      => esc_html__( 'Color Scheme', 'leroux-core' ),
					'name'       => 'color_scheme',
					'options'    => array(
						'dataset' => esc_html__( 'One Color per Dataset', 'leroux-core' ),
						'point'   => esc_html__( 'One Color per Point Group', 'leroux-core' ),
					)
				)
			);

            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name'       => 'skin',
                    'title'      => esc_html__( 'Skin', 'leroux-core' ),
                    'options'    => leroux_core_get_select_type_options_pool( 'shortcode_skin' ),
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'title'         => esc_html__( 'Hide xAxes', 'leroux-core' ),
                    'name'          => 'hide_xaxes',
                    'options'       => leroux_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'title'         => esc_html__( 'Hide yAxes', 'leroux-core' ),
                    'name'          => 'hide_yaxes',
                    'options'       => leroux_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'yes',
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'title'         => esc_html__( 'Hide Legend', 'leroux-core' ),
                    'name'          => 'hide_legend',
                    'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'select',
                    'title'      => esc_html__( 'Legend Position', 'leroux-core' ),
                    'name'       => 'legend_position',
                    'options'    => array(
                        'top'    => esc_html__( 'Top', 'leroux-core' ),
                        'right'  => esc_html__( 'Right', 'leroux-core' ),
                        'bottom' => esc_html__( 'Bottom', 'leroux-core' ),
                        'left'   => esc_html__( 'Left', 'leroux-core' ),
                    ),
                    'dependency' => array(
                        'hide' => array(
                            'hide_legend' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                )
            );

            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'title'         => esc_html__( 'Custom Legend', 'leroux-core' ),
                    'name'          => 'custom_legend',
                    'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                    'dependency' => array(
                        'show' => array(
                            'hide_legend' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                )
            );

            // from second to twelfth w/ dependency
            for ( $i = 1; $i <= $no_of_points; $i ++ ) {

                $custom_legend_array[] = array(
                    'field_type' => 'text',
                    'title'      => esc_html__( 'Custom ', 'leroux-core' ) . $i . esc_html__( ' Legend Text', 'leroux-core' ),
                    'name'       => 'custom_' . $i . '_legend',
                    'dependency' => array(
                        'show' => array(
                            'custom_legend' => array(
                                'values'        => 'yes',
                                'default_value' => 'no'
                            )
                        )
                    )
                );
            }

            foreach ( $custom_legend_array as $value ) {
                $this->set_option( $value );
            }
			foreach ( $points_array as $value ) {
				$this->set_option( $value );
			}
			foreach ( $dataset_array as $value ) {
				$this->set_option( $value );
			}

			$this->map_extra_options();
		}

		public function load_assets() {
			wp_enqueue_script( 'charts' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

            $atts['holder_classes'] = $this->get_holder_classes( $atts );

			$no_of_datasets = 3;
			$no_of_points   = 12;

			$atts['this_shortcode'] = $this;
			$atts['canvas_styles'] = $this->get_canvas_styles( $atts );
			for ( $i = 1; $i <= $no_of_datasets; $i ++ ) {
				$atts[ 'dataset_' . $i . '_values' ] = $this->get_dataset_values( $atts, $i, $no_of_points );
			}

			$atts['no_of_used_datasets'] = $this->get_no_of_used_datasets( $atts, $no_of_datasets );
			$atts['point_group_labels']  = $this->get_point_group_labels( $atts, $no_of_points );
			$atts['point_group_colors']  = $this->get_point_group_colors( $atts, $no_of_points );


			$html = '';
            $html .= '<div ' . qode_framework_get_class_attribute( $atts['holder_classes'] ) . ' ';
			
			$chart_size = in_array( $atts['type'], array( 'pie', 'doughnut' ) ) && ! empty( $atts['chart_size'] ) ? intval( $atts['chart_size'] ) : '';

			// inline data begin
			$html .= ' ' . $this->get_data_attribute( 'type', $atts['type'] );
			if( ! empty( $chart_size ) ) {
				$html .= ' ' . $this->get_data_attribute( 'size', $chart_size );
			}
			$html .= ' ' . $this->get_data_attribute( 'no_of_used_datasets', $atts['no_of_used_datasets'] );
			for ( $i = 1; $i <= $atts['no_of_used_datasets']; $i ++ ) {
				$html .= ' ' . $this->get_data_attribute( 'dataset_' . $i, $atts[ 'dataset_' . $i . '_values' ] );
			}
			$html .= ' ' . $this->get_data_attribute( 'point_group_labels', $atts['point_group_labels'] );
			$html .= ' ' . $this->get_data_attribute( 'point_group_colors', $atts['point_group_colors'] );
			for ( $i = 1; $i <= $atts['no_of_used_datasets']; $i ++ ) {
				$html .= ' ' . $this->get_data_attribute( 'dataset_' . $i . '_label', $atts[ 'dataset_' . $i . '_label' ] );
				$html .= ' ' . $this->get_data_attribute( 'dataset_' . $i . '_color', $atts[ 'dataset_' . $i . '_color' ] );
			}
			$html .= ' ' . $this->get_data_attribute( 'color_scheme', $atts['color_scheme'] );
            $html .= ' ' . $this->get_data_attribute( 'line_tension', $atts['line_tension'] );
            $html .= ' ' . $this->get_data_attribute( 'fill_shape', $atts['fill_shape'] );
			$html .= ' ' . $this->get_data_attribute( 'legend_position', $atts['legend_position'] );
            $html .= ' ' . $this->get_data_attribute( 'hide_xaxes', $atts['hide_xaxes'] );
            $html .= ' ' . $this->get_data_attribute( 'hide_yaxes', $atts['hide_yaxes'] );
            $html .= ' ' . $this->get_data_attribute( 'hide_legend', $atts['hide_legend'] );
            $html .= ' ' . $this->get_data_attribute( 'skin', $atts['skin'] );

			// inline data end

			$html .= '>';
			$html .= leroux_core_get_template_part( 'shortcodes/charts', 'templates/charts', '', $atts );
			$html .= '</div>';

			return $html;
		}

        private function get_holder_classes( $atts ) {
            $holder_classes = $this->init_holder_classes();

            $holder_classes[] = 'qodef-charts';
            $holder_classes[] = ! empty( $atts['skin'] ) ? 'qodef-skin--' . $atts['skin'] : '';
            $holder_classes[] = ! empty( $atts['custom_legend'] ) ? 'qodef-custom-legend--' . $atts['custom_legend'] : '';
            $holder_classes[] = ! empty( $atts['horizontal_alignment'] ) ? 'qodef-alignment-horizontal--' . $atts['horizontal_alignment'] : 'qodef-alignment-horizontal--right';
            $holder_classes[] = ! empty( $atts['vertical_alignment'] ) ? 'qodef-alignment-vertical--' . $atts['vertical_alignment'] : 'qodef-alignment-vertical--middle';

            return implode( ' ', $holder_classes );
        }
		
		private function get_canvas_styles( $atts ) {
			$styles = array();
			
			if ( in_array( $atts['type'], array( 'pie', 'doughnut' ) ) && ! empty( $atts['chart_size'] ) ) {
				$styles[] = 'width: ' . intval( $atts['chart_size'] ) . 'px';
				$styles[] = 'height: ' . intval( $atts['chart_size'] ) . 'px';
			}
			
			return $styles;
		}

		/*
	 * convert dataset values from shortcode into usable string
	 *
	 * @params $params - mixed, shortcode params
	 * @params $dataset - integer, current dataset, since function is being called from loop
	 * @params $no_of_points - integer, total number of points
	 *
	 * @return string
	 */
		private function get_dataset_values( $atts, $dataset, $no_of_points ) {
			$dataset_values = array();

			for ( $i = 1; $i <= $no_of_points; $i ++ ) {

				if ( $atts[ 'point_' . $dataset . '_' . $i ] != '' ) {
					$dataset_values[] = $atts[ 'point_' . $dataset . '_' . $i ];
				}
			}

			$dataset_values = implode( ',', $dataset_values );

			return $dataset_values;
		}

		/*
		 * create data attribute for inline print in html
		 *
		 * @params $title - string, name of the data attribute
		 * @params $raw_attribute - string, value of the data attribute
		 *
		 * @return string
		 */
		private function get_data_attribute( $title, $raw_attribute ) {

			$data_attribute = 'data-' . $title . '="' . $raw_attribute . '"';

			return $data_attribute;
		}

		/*
		 * determine how many datasets are being used in shortcode
		 *
		 * @params $params - mixed, shortcode params
		 * @params $no_of_datasets - integer, total number of datasets available in shortcode interface
		 *
		 * @return integer
		 */
		private function get_no_of_used_datasets( $atts, $no_of_datasets ) {
			for ( $i = $no_of_datasets; $i >= 1; $i -- ) {
				if ( $atts[ 'dataset_' . $i . '_values' ] != '' ) {
					return $i;
				}
			}
		}

		/*
		 *
		 */
		private function get_point_group_labels( $atts, $no_of_labels ) {
			$point_group_labels = array();

			for ( $i = 1; $i <= $no_of_labels; $i ++ ) {

				if ( $atts[ 'point_' . $i . '_label' ] != '' ) {
					$point_group_labels[] = $atts[ 'point_' . $i . '_label' ];
				}
			}

			$point_group_labels = implode( ',', $point_group_labels );

			return $point_group_labels;
		}

		/*
		 *
		 */
		private function get_point_group_colors( $atts, $no_of_labels ) {
			$point_group_colors = array();

			for ( $i = 1; $i <= $no_of_labels; $i ++ ) {

				if ( $atts[ 'point_' . $i . '_color' ] != '' ) {
					$point_group_colors[] = $atts[ 'point_' . $i . '_color' ];
				}
			}

			$point_group_colors = implode( ',', $point_group_colors );

			return $point_group_colors;
		}
	}
}
