<?php

if ( ! function_exists( 'leroux_core_add_counter_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_counter_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Counter_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_counter_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Counter_Shortcode extends LerouxCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'leroux_core_filter_counter_layouts', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/counter' );
			$this->set_base( 'leroux_core_counter' );
			$this->set_name( esc_html__( 'Counter', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays counter with provided parameters', 'leroux-core' ) );

			$options_map = leroux_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'leroux-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'start_digit',
					'title'         => esc_html__( 'Start Digit', 'leroux-core' ),
					'default_value' => 1,
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'end_digit',
					'title'         => esc_html__( 'End Digit', 'leroux-core' ),
					'default_value' => 15,
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'step_digit',
					'title'      => esc_html__( 'Step Between Digits', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'step_delay',
					'title'      => esc_html__( 'Step Delay', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'digit_label',
					'title'      => esc_html__( 'Digit Label', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'digit_font_size',
					'title'      => esc_html__( 'Digit Font Size', 'leroux-core' ),
					'group'      => esc_html__( 'Digit Style', 'leroux-core' ),
				)
			);
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name'       => 'digit_color',
                    'title'      => esc_html__( 'Digit Color', 'leroux-core' ),
                    'group'      => esc_html__( 'Digit Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'digit_font_size_1440',
                    'title'       => esc_html__( 'Digit Font Size 1440', 'leroux-core' ),
                    'description' => esc_html__( 'Set responsive style value for screen size 1440', 'leroux-core' ),
                    'group'       => esc_html__( 'Digit Responsive Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'digit_font_size_1024',
                    'title'       => esc_html__( 'Digit Font Size 1024', 'leroux-core' ),
                    'description' => esc_html__( 'Set responsive style value for screen size 1024', 'leroux-core' ),
                    'group'       => esc_html__( 'Digit Responsive Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'digit_font_size_768',
                    'title'       => esc_html__( 'Digit Font Size 768', 'leroux-core' ),
                    'description' => esc_html__( 'Set responsive style value for screen size 768', 'leroux-core' ),
                    'group'       => esc_html__( 'Digit Responsive Style', 'leroux-core' ),
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'text',
                    'name'        => 'digit_font_size_680',
                    'title'       => esc_html__( 'Digit Font Size 680', 'leroux-core' ),
                    'description' => esc_html__( 'Set responsive style value for screen size 680', 'leroux-core' ),
                    'group'       => esc_html__( 'Digit Responsive Style', 'leroux-core' ),
                )
            );
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'icon_type',
					'title'         => esc_html__( 'Icon Type', 'leroux-core' ),
					'options'       => array(
						'image' => esc_html__( 'Image', 'leroux-core' ),
						'svg-icon' => esc_html__( 'SVG path', 'leroux-core' ),
					),
					'default_value' => 'image',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'image',
					'name'          => 'image',
					'title'         => esc_html__( 'Icon', 'leroux-core' ),
					'dependency' => array(
						'show' => array(
							'icon_type' => array(
								'values'        => 'image',
								'default_value' => 'image',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'textarea',
					'name'       => 'svg_icon',
					'title'      => esc_html__( 'Icon SVG code', 'leroux-core' ),
					'dependency' => array(
						'show' => array(
							'icon_type' => array(
								'values'        => 'svg-icon',
								'default_value' => 'image',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'icon_color',
					'title'      => esc_html__( 'Icon Color', 'leroux-core' ),
					'dependency' => array(
						'show' => array(
							'icon_type' => array(
								'values'        => 'svg-icon',
								'default_value' => 'image',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'image_margin_bottom',
					'title'         => esc_html__( 'Icon Margin Bottom', 'leroux-core' ),
					'group'         => esc_html__( 'Icon Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'leroux-core' ),
					'default_value' => esc_html__( 'Title Text', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h5',
					'group'         => esc_html__( 'Title Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'leroux-core' ),
					'group'      => esc_html__( 'Title Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'leroux-core' ),
					'group'      => esc_html__( 'Title Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'text',
					'title'         => esc_html__( 'Text', 'leroux-core' ),
					'default_value' => esc_html__( 'Contrary to popular belief, Lorem Ipsum is not simply random text.', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'leroux-core' ),
					'group'      => esc_html__( 'Text Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'leroux-core' ),
					'group'      => esc_html__( 'Text Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'content_alignment',
					'title'         => esc_html__( 'Alignment', 'leroux-core' ),
					'options' => array(
						'left' => esc_html__( 'Left', 'leroux-core' ),
						'center' => esc_html__( 'Center', 'leroux-core' ),
						'right' => esc_html__( 'Right', 'leroux-core' ),
					),
					'default_value' => 'left',
				)
			);
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'leroux_core_counter', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['unique_class']   = 'qodef-counter-' . rand( 0, 1000 );
			$atts['data_attrs']     = $this->get_data_attrs( $atts );
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['digit_styles']   = $this->get_digit_styles( $atts );
			$atts['title_styles']   = $this->get_title_styles( $atts );
			$atts['text_styles']    = $this->get_text_styles( $atts );
			$atts['image_styles']   = $this->get_image_styles( $atts );
			$this->set_responsive_digit_styles( $atts );

			return leroux_core_get_template_part( 'shortcodes/counter', 'variations/' . $atts['layout'] . '/templates/counter', '', $atts );
		}

		private function get_data_attrs( $atts ) {
			$data = array();

			if ( ! empty( $atts['start_digit'] ) ) {
				$data['data-start-digit'] = $atts['start_digit'];
			}

			if ( ! empty( $atts['end_digit'] ) ) {
				$data['data-end-digit'] = $atts['end_digit'];
			}

			if ( ! empty( $atts['step_digit'] ) ) {
				$data['data-step-digit'] = $atts['step_digit'];
			}

			if ( ! empty( $atts['step_delay'] ) ) {
				$data['data-step-delay'] = $atts['step_delay'];
			}

			if ( ! empty( $atts['digit_label'] ) ) {
				$data['data-digit-label'] = $atts['digit_label'];
			}

			return $data;
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-counter';
			$holder_classes[] = $atts['unique_class'];
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';

			$holder_classes[] = 'qodef-aligned--' . $atts['content_alignment'];

			return implode( ' ', $holder_classes );
		}

		private function get_digit_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['digit_font_size'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['digit_font_size'], true ) ) {
					$styles[] = 'font-size: ' . $atts['digit_font_size'];
				} else {
					$styles[] = 'font-size: ' . intval( $atts['digit_font_size'] ) . 'px';
				}
			}

			if ( ! empty( $atts['digit_color'] ) ) {
				$styles[] = 'color: ' . $atts['digit_color'];
			}

			return $styles;
		}

		private function set_responsive_digit_styles( $atts ) {
			$unique_class = '.' . $atts['unique_class'] . ' .qodef-m-digit';
            $screen_sizes = array( '1440', '1024', '768', '680' );

            foreach ( $screen_sizes as $screen_size ) {
                $styles = array();

                if ( ! empty( $atts['digit_font_size_' . $screen_size] ) ) {
                    if ( qode_framework_string_ends_with_typography_units( $atts['digit_font_size_' . $screen_size] ) ) {
                        $styles['font-size'] = $atts['digit_font_size_' . $screen_size] . '!important';
                    } else {
                        $styles['font-size'] = intval( $atts['digit_font_size_' . $screen_size] ) . 'px !important';
                    }
                }

                if ( ! empty( $styles ) ) {
                    add_filter(
                        'leroux_core_filter_add_responsive_' . $screen_size . '_inline_style_in_footer',
                        function ( $style ) use ( $unique_class, $styles ) {
                            $style .= qode_framework_dynamic_style( $unique_class, $styles );

                            return $style;
                        }
                    );
                }
            }
		}

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['title_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['title_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['title_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['title_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			return $styles;
		}

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['text_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}
		
		private function get_image_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['image_margin_bottom'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['image_margin_bottom'] ) ) {
					$styles[] = 'margin-bottom: ' . $atts['image_margin_bottom'];
				} else {
					$styles[] = 'margin-bottom: ' . intval( $atts['image_margin_bottom'] ) . 'px';
				}
			}
			
			if ( '' !== $atts['icon_color'] ) {
				$styles[] = 'color: ' . $atts['icon_color'];
			}

			return $styles;
		}
	}
}
