<?php

if ( ! function_exists( 'leroux_core_add_custom_font_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function leroux_core_add_custom_font_widget( $widgets ) {
		$widgets[] = 'LerouxCore_Custom_Font_Widget';

		return $widgets;
	}

	add_filter( 'leroux_core_filter_register_widgets', 'leroux_core_add_custom_font_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class LerouxCore_Custom_Font_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'leroux_core_custom_font',
				)
			);
			if ( $widget_mapped ) {
				$this->set_base( 'leroux_core_custom_font' );
				$this->set_name( esc_html__( 'Leroux Custom Font', 'leroux-core' ) );
				$this->set_description( esc_html__( 'Add a custom font element into widget areas', 'leroux-core' ) );
			}
		}

		public function render( $atts ) {
			echo LerouxCore_Custom_Font_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
