<?php

if ( ! function_exists( 'leroux_core_add_horizontal_accordion_showcase_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_horizontal_accordion_showcase_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Horizontal_Accordion_Showcase_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_horizontal_accordion_showcase_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Horizontal_Accordion_Showcase_Shortcode extends LerouxCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/horizontal-accordion-showcase' );
			$this->set_base( 'leroux_core_horizontal_accordion_showcase' );
			$this->set_name( esc_html__( 'Horizontal Accordion Showcase', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds Horizontal Accordion Showcase element', 'leroux-core' ) );
			$this->set_category( esc_html__( 'Leroux Core', 'leroux-core' ) );

			$this->set_scripts(
				array(
					'jquery-ui-accordion' => array(
						'registered' => true,
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'full_height',
					'title'         => esc_html__( 'Enable Full Height', 'cuthbert-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'tab_label_bottom_position',
					'title'      => esc_html__( 'Tab Label Bottom Position', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'tab_background_color',
					'title'      => esc_html__( 'Title Background Color', 'leroux-core' ),
				)
			);

			$elementor_sections = array();

			if ( qode_framework_is_installed( 'elementor' ) ) {
				$elementor_sections = leroux_core_generate_elementor_templates_control( $this );
			}

			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Item Elements', 'leroux-core' ),
					'items'      => array(
						array(
							'field_type' => 'text',
							'name'       => 'item_tab_label',
							'title'      => esc_html__( 'Tab Label', 'leroux-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_title',
							'title'      => esc_html__( 'Title', 'leroux-core' ),
							'dependency' => array(
								'show' => array(
									'item_content_template' => array(
										'values'        => 'predefined_template',
										'default_value' => 'predefined_template',
									),
								),
							),
						),
						array(
							'field_type' => 'textarea',
							'name'       => 'item_text',
							'title'      => esc_html__( 'Text', 'leroux-core' ),
							'dependency' => array(
								'show' => array(
									'item_content_template' => array(
										'values'        => 'predefined_template',
										'default_value' => 'predefined_template',
									),
								),
							),
						),
						array(
							'field_type' => 'image',
							'name'       => 'item_image',
							'title'      => esc_html__( 'Image', 'leroux-core' ),
							'dependency' => array(
								'show' => array(
									'item_content_template' => array(
										'values'        => 'predefined_template',
										'default_value' => 'predefined_template',
									),
								),
							),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_button_text',
							'title'      => esc_html__( 'Button Text', 'leroux-core' ),
							'dependency' => array(
								'show' => array(
									'item_content_template' => array(
										'values'        => 'predefined_template',
										'default_value' => 'predefined_template',
									),
								),
							),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_button_link',
							'title'      => esc_html__( 'Button Link', 'leroux-core' ),
							'dependency' => array(
								'show' => array(
									'item_content_template' => array(
										'values'        => 'predefined_template',
										'default_value' => 'predefined_template',
									),
								),
							),
						),
						array(
							'field_type' => 'select',
							'name'       => 'item_button_target',
							'title'      => esc_html__( 'Button Target', 'leroux-core' ),
							'options'    => leroux_core_get_select_type_options_pool( 'link_target' ),
							'dependency' => array(
								'show' => array(
									'item_content_template' => array(
										'values'        => 'predefined_template',
										'default_value' => 'predefined_template',
									),
								),
							),
						),
						array(
							'field_type'    => 'select',
							'name'          => 'item_content_template',
							'title'         => esc_html__( 'Item Content Template', 'leroux-core' ),
							'options'       => array(
								'predefined_template' => esc_html__( 'Predefined Template', 'leroux-core' ),
								'elementor_template'  => esc_html__( 'Elementor Template', 'leroux-core' ),
							),
							'default_value' => 'predefined_template',
						),
						array(
							'field_type'    => 'select',
							'name'          => 'item_elementor_template',
							'title'         => esc_html__( 'Elementor Template', 'leroux-core' ),
							'options'       => $elementor_sections,
							'default_value' => '0',
							'dependency'    => array(
								'show' => array(
									'item_content_template' => array(
										'values'        => 'elementor_template',
										'default_value' => 'predefined_template',
									),
								),
							),
						),
					),
					'group'      => esc_html__( 'Items', 'leroux-core' ),
				)
			);
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'leroux_core_horizontal_accordion_showcase', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function load_assets() {
			wp_enqueue_script( 'jquery-ui-tabs' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['holder_styles']  = $this->get_holder_styles( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			$atts['this_shortcode'] = $this;

			return leroux_core_get_template_part( 'shortcodes/horizontal-accordion-showcase', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-horizontal-accordion-showcase';
			$holder_classes[] = ! empty( $atts['full_height'] ) && ( 'yes' === $atts['full_height'] ) ? 'qodef--full-height' : 'qodef--min-height';

			return implode( ' ', $holder_classes );
		}

		private function get_holder_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['tab_label_bottom_position'] ) ) {
				if ( qode_framework_string_ends_with_space_units( $atts['tab_label_bottom_position'] ) ) {
					$styles[] = '--qodef-tab-label-bottom: ' . $atts['tab_label_bottom_position'];
				} else {
					$styles[] = '--qodef-tab-label-bottom: ' . intval( $atts['tab_label_bottom_position'] ) . 'px';
				}
			}

			if ( ! empty( $atts['tab_background_color'] ) ) {
				$styles[] = '--qode-label-background: ' . $atts['tab_background_color'];
			}

			return $styles;
		}

		public function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}

			return $styles;
		}
	}
}
