<?php if ( ! empty( $items ) ): ?>
	<?php foreach ( $items as $item ): ?>
		<?php
		$params['item']       = $item;
		$params['mobile']     = true;
		$template_class       = 'elementor_template' === $item['item_content_template'] ? 'qodef-m-content--elementor' : 'qodef-m-content--predefined';
		$item_content_classes = array( 'qodef-m-content', $template_class );
		?>
		<div class="qodef-m-header">
			<?php
			leroux_core_template_part( 'shortcodes/horizontal-accordion-showcase', 'templates/parts/tab-label', '', $params );
			
			leroux_core_template_part( 'shortcodes/horizontal-accordion-showcase', 'templates/parts/tab-arrow', '', $params );
			?>
		</div>
		<div class="qodef-m-content" id="qodef-tab--<?php echo esc_attr( $item['_id'] ); ?>">
			<?php
			if ( qode_framework_is_installed( 'elementor' ) && 'elementor_template' === $item['item_content_template'] ) {
				$content = Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $item['item_elementor_template'] );
				echo do_shortcode( $content );
			} else { ?>
				<div class="qodef-m-content-inner">
					<div class="qodef-m-content-left">
						<div class="qodef-m-content-left-top">
							<?php
							// include item title
							leroux_core_template_part( 'shortcodes/horizontal-accordion-showcase', 'templates/parts/title', '', $params );
							?>
						</div>
						<div class="qodef-m-content-left-bottom">
							<?php
							// include item text
							leroux_core_template_part( 'shortcodes/horizontal-accordion-showcase', 'templates/parts/text', '', $params );

							// include item button
							leroux_core_template_part( 'shortcodes/horizontal-accordion-showcase', 'templates/parts/button', '', $params );
							?>
						</div>
					</div>
					<div class="qodef-m-content-right">
						<?php leroux_core_template_part( 'shortcodes/horizontal-accordion-showcase', 'templates/parts/image', '', $params ); ?>
					</div>
				</div>
			<?php }
			?>
		</div>
	<?php endforeach; ?>
<?php endif; ?>
