<?php

if ( ! function_exists( 'leroux_core_add_horizontal_showcase_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_horizontal_showcase_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Horizontal_Showcase_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_horizontal_showcase_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Horizontal_Showcase_Shortcode extends LerouxCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/horizontal-showcase' );
			$this->set_base( 'leroux_core_horizontal_showcase' );
			$this->set_name( esc_html__( 'Horizontal Showcase', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds horizontal showcase holder', 'leroux-core' ) );
			$this->set_scripts(
				array_merge(
					array(
						'SmoothScrollbar'        => array(
							'registered' => false,
							'url'        => LEROUX_CORE_SHORTCODES_URL_PATH . '/horizontal-showcase/assets/js/plugins/smooth-scrollbar.js',
							'dependency' => array( 'jquery' ),
						),
						'HorizontalScrollPlugin' => array(
							'registered' => false,
							'url'        => LEROUX_CORE_SHORTCODES_URL_PATH . '/horizontal-showcase/assets/js/plugins/HorizontalScrollPlugin.js',
							'dependency' => array( 'jquery' ),
						),
						'overscroll'             => array(
							'registered' => false,
							'url'        => LEROUX_CORE_SHORTCODES_URL_PATH . '/horizontal-showcase/assets/js/plugins/overscroll.js',
							'dependency' => array( 'jquery' ),
						),
					),
					apply_filters(
						'leroux_core_filter_horizontal_showcase_register_assets',
						array()
					)
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);

			$elementor_sections = array();

			if ( qode_framework_is_installed( 'elementor' ) ) {
				$elementor_sections = leroux_core_generate_elementor_templates_control( $this );
			}

			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Slides', 'leroux-core' ),
					'items'      => array(
						array(
							'field_type' => 'image',
							'name'       => 'item_intro_image',
							'title'      => esc_html__( 'Image', 'leroux-core' )
						),
						array(
							'field_type'    => 'select',
							'name'          => 'item_elementor_template',
							'title'         => esc_html__( 'Elementor Template', 'leroux-core' ),
							'options'       => $elementor_sections,
							'default_value' => '0'
						),
					),
				)
			);
			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['this_shortcode'] = $this;

			return leroux_core_get_template_part( 'shortcodes/horizontal-showcase', 'templates/horizontal-showcase', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-horizontal-showcase qodef-custom-horizontal-slider';

			return implode( ' ', $holder_classes );
		}

		public function get_modified_title( $item ) {
			$title = $item['item_title'];

			if ( ! empty( $item['item_line_break_positions'] ) ) {
				$split_title          = explode( ' ', $title );
				$line_break_positions = explode( ',', str_replace( ' ', '', $item['item_line_break_positions'] ) );

				foreach ( $line_break_positions as $position ) {
					$position = intval( $position );
					if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
						$split_title[ $position - 1 ] = $split_title[ $position - 1 ] . '<br />';
					}
				}

				$title = implode( ' ', $split_title );
			}

			return $title;
		}

		public function get_slide_classes( $slide_atts ) {
			$classes = array( 'qodef-m-item', 'qodef-horizontal-slide' );

			if ( ! empty( $slide_atts['item_size_type'] ) ) {
				$classes[] = 'qodef-size-type--' . $slide_atts['item_size_type'];
			}

			return implode( ' ', $classes );
		}

		public function get_slide_styles( $slide_atts ) {
			$styles = array();

			if ( ! empty( $slide_atts['background_color'] ) ) {
				$styles[] = 'background-color: ' . $slide_atts['background_color'];
			}

			return $styles;
		}
	}
}
