<?php

if ( ! function_exists( 'leroux_core_add_image_hotspots_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_image_hotspots_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Image_Hotspots_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_image_hotspots_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Image_Hotspots_Shortcode extends LerouxCore_Shortcode {
		var $breakpoints = array( 1920, 1440, 1024, 768, 680 ); // match array in scss file: _image-hotspots-default.scss

		public function __construct() {
			$this->set_extra_options( apply_filters( 'leroux_core_filter_image_hotspots_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/image-hotspots' );
			$this->set_base( 'leroux_core_image_hotspots' );
			$this->set_name( esc_html__( 'Image Hotspots', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays image hotspots', 'leroux-core' ) );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'main_image',
					'title'      => esc_html__( 'Image', 'leroux-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Spots', 'leroux-core' ),
					'items'      => $this->get_repeater_options(),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'pin_background_color',
					'title'      => esc_html__( 'Pin Holder Background Color', 'leroux-core' ),
					'group'      => esc_html__( 'Pin Style', 'leroux-core' ),
				)
			);


			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h6',
					'group'         => esc_html__( 'Title Style', 'leroux-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'leroux-core' ),
					'group'      => esc_html__( 'Title Style', 'leroux-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'leroux-core' ),
					'group'      => esc_html__( 'Text Style', 'leroux-core' ),
				)
			);


			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();
			
			$atts['holder_classes']   = $this->get_holder_classes( $atts );
			$atts['items']            = $this->parse_repeater_items( $atts['children'] );
			$atts['this_shortcode']   = $this;

			return leroux_core_get_template_part( 'shortcodes/image-hotspots', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-image-hotspots';
			$holder_classes[] = ! empty ( $atts['image_type'] ) ? 'qodef-has--' . $atts['image_type'] : '';

			return implode( ' ', $holder_classes );
		}
		
		public function get_repeater_options() {
			$options            = array();
			$breakpoints        = $this->breakpoints;
			
			$options[] = array(
				'field_type'    => 'text',
				'name'          => 'item_title',
				'title'         => esc_html__( 'Title', 'leroux-core' ),
			);
		
			$options[] = array(
				'field_type'    => 'textarea',
				'name'          => 'item_text',
				'title'         => esc_html__( 'Text', 'leroux-core' ),
			);

            $options[] = array(
                'field_type'    => 'image',
                'name'          => 'item_custom_icon',
                'title'         => esc_html__( 'Custom Icon', 'leroux-core' ),
            );
			
			$options[] = array(
				'field_type' => 'textarea',
				'name'       => 'item_custom_image_svg',
				'title'      => esc_html__( 'Thumb Image SVG', 'leroux-core' ),
			);
			
			$options[] =array(
				'field_type' => 'color',
				'name'       => 'item_custom_image_svg_color',
				'title'      => esc_html__( 'Thumb Image SVG Color', 'leroux-core' ),
			);

            $options[] = array(
                'field_type'    => 'select',
                'name'          => 'item_horizontal_position',
                'title'         => esc_html__( 'Item Horizontal Position', 'leroux-core' ),
                'options' => array(
                    'left' => esc_html__('Left', 'deon-core'),
                    'right' => esc_html__('Right', 'deon-core'),
                ),
                'default_value' => 'left',
            );

			foreach ( $breakpoints as $breakpoint ) {
                $title_label = $breakpoints[0] === $breakpoint ? esc_html__( 'Item Vertical Offset', 'leroux-core' ) : sprintf( '%s ' . $breakpoint . ' %s', esc_html__( 'Item Vertical Offset Below', 'leroux-core' ), esc_html__( 'px', 'leroux-core' ) );
				
				$options[] = array(
					'field_type' => 'text',
					'name'       => 'item_vertical_offset_'  . $breakpoint,
					'title'      => $title_label,
				);
			}
			
			foreach ( $breakpoints as $breakpoint ) {
                $title_label = $breakpoints[0] === $breakpoint ? esc_html__( 'Item Horizontal Offset', 'leroux-core' ) : sprintf( '%s ' . $breakpoint . ' %s', esc_html__( 'Item Horizontal Offset', 'leroux-core' ), esc_html__( 'px', 'leroux-core' ) );
				
				$options[] = array(
					'field_type' => 'text',
					'name'       => 'item_horizontal_offset_'  . $breakpoint,
					'title'      => $title_label,
				);
			}
			
			foreach ( $breakpoints as $breakpoint ) {
                $title_label = $breakpoints[0] === $breakpoint ? esc_html__( 'Item Info Distance', 'leroux-core' ) : sprintf( '%s ' . $breakpoint . ' %s', esc_html__( 'Item Info Distance Below', 'leroux-core' ), esc_html__( 'px', 'leroux-core' ) );
				
				$options[] = array(
					'field_type' => 'text',
					'name'       => 'item_info_distance_'  . $breakpoint,
					'title'      => $title_label,
				);
			}
			
			return $options;
		}

		public function get_item_classes( $atts, $item ) {
			$item_classes = $this->init_item_classes();

			$item_classes[] = 'qodef-e-item';
			$item_classes[] = ! empty( $item['item_vertical_position'] ) ? 'qodef-vertical--' . $item['item_vertical_position'] : '';
			$item_classes[] = ! empty( $item['item_horizontal_position'] ) ? 'qodef-item-position--' . $item['item_horizontal_position'] : '';

			return implode( ' ', $item_classes );
		}
		
		public function get_item_styles( $item) {
			$styles      = array();
			$breakpoints = $this->breakpoints;
			
			$safe_horizontal_breakpoint = $breakpoints[0];
			$safe_vertical_breakpoint   = $breakpoints[0];
            $safe_distance_breakpoint   = $breakpoints[0];
			foreach ( $breakpoints as $breakpoint ) {
				if ( ! empty( $item['item_horizontal_offset_' . $breakpoint] ) ) {
					if ( qode_framework_string_ends_with_space_units( $item['item_horizontal_offset_' . $breakpoint] ) ) {
						$styles[] = '--qode-hotspot-left-' . $breakpoint . ':' . $item['item_horizontal_offset_' . $breakpoint];
					} else {
						$styles[] = '--qode-hotspot-left-' . $breakpoint . ':' . $item['item_horizontal_offset_' . $breakpoint] . 'px';
					}
					$safe_horizontal_breakpoint = $breakpoint;
				} else if ( ! empty( $item['item_horizontal_offset_' . $safe_horizontal_breakpoint] ) ) {
					if ( qode_framework_string_ends_with_space_units( $item['item_horizontal_offset_' . $safe_horizontal_breakpoint] ) ) {
						$styles[] = '--qode-hotspot-left-' . $breakpoint . ':' . $item['item_horizontal_offset_' . $safe_horizontal_breakpoint];
					} else {
						$styles[] = '--qode-hotspot-left-' . $breakpoint . ':' . $item['item_horizontal_offset_' . $safe_horizontal_breakpoint] . 'px';
					}
				} else {
					$styles[] = '--qode-hotspot-left-' . $breakpoint . ':0';
				}
				
				if ( ! empty( $item['item_vertical_offset_' . $breakpoint] ) ) {
					if ( qode_framework_string_ends_with_space_units( $item['item_vertical_offset_' . $breakpoint] ) ) {
						$styles[] = '--qode-hotspot-top-' . $breakpoint . ':' . $item['item_vertical_offset_' . $breakpoint];
					} else {
						$styles[] = '--qode-hotspot-top-' . $breakpoint . ':' . $item['item_vertical_offset_' . $breakpoint] . 'px';
					}
					$safe_vertical_breakpoint = $breakpoint;
				} else if ( ! empty( $item['item_vertical_offset_' . $safe_vertical_breakpoint] ) ) {
					if ( qode_framework_string_ends_with_space_units( $item['item_vertical_offset_' . $safe_vertical_breakpoint] ) ) {
						$styles[] = '--qode-hotspot-top-' . $breakpoint . ':' . $item['item_vertical_offset_' . $safe_vertical_breakpoint];
					} else {
						$styles[] = '--qode-hotspot-top-' . $breakpoint . ':' . $item['item_vertical_offset_' . $safe_vertical_breakpoint] . 'px';
					}
				} else {
					$styles[] = '--qode-hotspot-top-' . $breakpoint . ':0';
				}
				
				if ( ! empty( $item['item_info_distance_' . $breakpoint] ) ) {
					if ( qode_framework_string_ends_with_space_units( $item['item_info_distance_' . $breakpoint] ) ) {
						$styles[] = '--qode-hotspot-distance-' . $breakpoint . ':' . $item['item_info_distance_' . $breakpoint];
					} else {
						$styles[] = '--qode-hotspot-distance-' . $breakpoint . ':' . $item['item_info_distance_' . $breakpoint] . 'px';
					}
					$safe_distance_breakpoint = $breakpoint;
				} else if ( ! empty( $item['item_info_distance_' . $safe_distance_breakpoint] ) ) {
					if ( qode_framework_string_ends_with_space_units( $item['item_info_distance_' . $safe_distance_breakpoint] ) ) {
						$styles[] = '--qode-hotspot-distance-' . $breakpoint . ':' . $item['item_info_distance_' . $safe_distance_breakpoint];
					} else {
						$styles[] = '--qode-hotspot-distance-' . $breakpoint . ':' . $item['item_info_distance_' . $safe_distance_breakpoint] . 'px';
					}
				} else {
					$styles[] = '--qode-hotspot-distance-' . $breakpoint . ':0';
				}
			}
			
			return $styles;
		}

		public function get_item_line_styles( $item ) {

			$styles = array();

			if ( ! empty( $item['info_distance'] ) ) {

				if ( 'left' == $item['item_horizontal_position'] ) {
					$styles[] = 'padding-right: ' . $item['info_distance'];
				} else {
					$styles[] = 'padding-left: ' . $item['info_distance'];
				}
			}

			return implode( ';', $styles );
		}

		public function get_title_styles( $atts ) {

			$styles = array();

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			return $styles;
		}

		public function get_text_styles( $atts ) {

			$styles = array();

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}
	}
}
