<?php

if ( ! function_exists( 'leroux_core_add_interactive_banners_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param $shortcodes array
	 *
	 * @return array
	 */
	function leroux_core_add_interactive_banners_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Interactive_Banners_Shortcode';
		
		return $shortcodes;
	}
	
	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_interactive_banners_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Interactive_Banners_Shortcode extends LerouxCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'leroux_core_filter_interactive_banners_layouts', array() ) );

			$options_map   = leroux_core_get_variations_options_map( $this->get_layouts() );
			$default_value = $options_map['default_value'];

			$this->set_extra_options( apply_filters( 'leroux_core_filter_interactive_banners_extra_options', array(), $default_value ) );

			parent::__construct();
		}
		
		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/interactive-banners' );
			$this->set_base( 'leroux_core_interactive_banners' );
			$this->set_name( esc_html__( 'Interactive Banners', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays interactive banners with provided parameters', 'leroux-core' ) );
			$this->set_category( esc_html__( 'Leroux Core', 'leroux-core' ) );

			$options_map = leroux_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'leroux-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array(
						'map_for_page_builder' => $options_map['visibility'],
					),
				)
			);

			$this->set_option( array(
               'field_type'    => 'select',
               'name'          => 'number_of_items',
               'title'         => esc_html__( 'Number Of Items', 'leroux-core' ),
               'options'       => array(
                   'four' => esc_html__( 'Four', 'leroux-core' ),
                   'five'    => esc_html__( 'Five', 'leroux-core' )
               ),
               'default_value' => 'five'
            ) );
			$this->set_option( array(
               'field_type' => 'repeater',
               'name'       => 'children',
               'title'      => esc_html__( 'Items', 'leroux-core' ),
               'items'      => array(
		           array(
		               'field_type'    => 'text',
		               'name'          => 'title',
		               'title'         => esc_html__( 'Title', 'leroux-core' ),
		               'default_value' => ''
		           ),
		           array(
		               'field_type'    => 'text',
		               'name'          => 'subtitle',
		               'title'         => esc_html__( 'Subtitle', 'leroux-core' ),
		               'default_value' => ''
		           ),
		           array(
		               'field_type'    => 'text',
		               'name'          => 'link',
		               'title'         => esc_html__( 'Link', 'leroux-core' ),
		               'default_value' => ''
		           ),
		           array(
		               'field_type'    => 'text',
		               'name'          => 'link_text',
		               'title'         => esc_html__( 'Link Text', 'leroux-core' ),
		               'default_value' => ''
		           ),
		           array(
		               'field_type'    => 'select',
		               'name'          => 'link_target',
		               'title'         => esc_html__( 'Link Target', 'leroux-core' ),
		               'options'       => leroux_core_get_select_type_options_pool( 'link_target' ),
		               'default_value' => '_self'
		           ),
		           array(
		               'field_type'    => 'text',
		               'name'          => 'tag',
		               'title'         => esc_html__( 'Tag', 'leroux-core' ),
		               'default_value' => ''
		           ),
		           array(
		               'field_type' => 'image',
		               'name'       => 'item_image',
		               'title'      => esc_html__( 'Background Image', 'leroux-core' )
		           ),
		           array(
			           'field_type'    => 'text',
			           'name'          => 'item_video',
			           'title'         => esc_html__( 'Background Video', 'leroux-core' ),
			           'default_value' => ''
		           ),
               )
			) );
		}
		
		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();
			
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['number_of_items_numeric'] = $atts['number_of_items'] == 'four' ? 4 : 5;
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['this_shortcode'] = $this;

			return leroux_core_get_template_part( 'shortcodes/interactive-banners', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}
		
		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();
			
			$holder_classes[] = ! empty( $atts['number_of_items'] ) ? ' qodef-interactive-banners-' . $atts['number_of_items'] : ' qodef-interactive-banners-five';
			
			return implode( ' ', $holder_classes );
		}
	}
}