<?php

if ( ! function_exists( 'leroux_core_add_section_title_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_section_title_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Section_Title_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_section_title_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Section_Title_Shortcode extends LerouxCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/section-title' );
			$this->set_base( 'leroux_core_section_title' );
			$this->set_name( esc_html__( 'Section Title', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds section title element', 'leroux-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'leroux-core' ),
					'default_value' => esc_html__( 'Title Text', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'line_break_positions',
					'title'       => esc_html__( 'Positions of Line Break', 'leroux-core' ),
					'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'leroux-core' ),
					'group'       => esc_html__( 'Title Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'disable_title_break_words',
					'title'         => esc_html__( 'Disable Title Line Break', 'leroux-core' ),
					'description'   => esc_html__( 'Enabling this option will disable title line breaks for screen size 1024 and lower', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Title Style', 'leroux-core' ),
				)
			);
            $this->set_option( 
                array(
                'field_type'  => 'text',
                'name'        => 'title_emphasize_words',
                'title'       => esc_html__( 'Emphasize Words', 'leroux-core' ),
                'description' => esc_html__( 'Enter the positions of the words you would like to Emphasize. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to be emphasized, you would enter "1,3,4"', 'leroux-core' ),
                'group'       => esc_html__( 'Title Style', 'leroux-core' )
                )
            );
            $this->set_option(
                array(
                    'field_type'  => 'color',
                    'name'        => 'emphasized_words_color',
                    'title'       => esc_html__( 'Emphasized Words Color', 'leroux-core' ),
                    'group'       => esc_html__( 'Title Style', 'leroux-core' )
                )
            );
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Title Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'leroux-core' ),
					'group'      => esc_html__( 'Title Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link',
					'title'      => esc_html__( 'Title Custom Link', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'target',
					'title'         => esc_html__( 'Custom Link Target', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'text',
					'title'         => esc_html__( 'Text', 'leroux-core' ),
					'default_value' => esc_html__( 'Contrary to popular belief, Lorem Ipsum is not simply random text.', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'leroux-core' ),
					'group'      => esc_html__( 'Text Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'leroux-core' ),
					'group'      => esc_html__( 'Text Style', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'content_alignment',
					'title'      => esc_html__( 'Content Alignment', 'leroux-core' ),
					'options'    => array(
						''       => esc_html__( 'Default', 'leroux-core' ),
						'left'   => esc_html__( 'Left', 'leroux-core' ),
						'center' => esc_html__( 'Center', 'leroux-core' ),
						'right'  => esc_html__( 'Right', 'leroux-core' ),
					),
				)
			);
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['title']          = $this->get_modified_title( $atts );
			$atts['title_styles']   = $this->get_title_styles( $atts );
			$atts['text_styles']    = $this->get_text_styles( $atts );

			return leroux_core_get_template_part( 'shortcodes/section-title', 'templates/section-title', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-section-title';
			$holder_classes[] = ! empty( $atts['content_alignment'] ) ? 'qodef-alignment--' . $atts['content_alignment'] : 'qodef-alignment--left';
			$holder_classes[] = 'yes' === $atts['disable_title_break_words'] ? 'qodef-title-break--disabled' : '';

			return implode( ' ', $holder_classes );
		}

        private function get_modified_title( $atts ) {
            $title = $atts['title'];

            if ( ! empty( $title ) ) {
                $split_title = explode( ' ', $title );

                if ( ! empty( $atts['title_emphasize_words'] ) ) {
                    $title_emphasize_words = explode( ',', str_replace( ' ', '', $atts['title_emphasize_words'] ) );

                    foreach ( $title_emphasize_words as $position ) {
                        $position = (int) $position;
                        if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
                            $split_title[ $position - 1 ] = '<span class="qodef-special-style">' . $split_title[ $position - 1 ] . '</span>';
                        }
                    }
                }

                if ( ! empty( $atts['line_break_positions'] ) ) {
                    $line_break_positions = explode( ',', str_replace( ' ', '', $atts['line_break_positions'] ) );

                    foreach ( $line_break_positions as $position ) {
                        $position = (int) $position;
                        if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
                            $split_title[ $position - 1 ] = $split_title[ $position - 1 ] . '<br />';
                        }
                    }
                }

                $title = implode( ' ', $split_title );
            }

            return $title;
        }

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			if ( ! empty( $atts['emphasized_words_color'] ) ) {
				$styles[] = '--qodef-title-emphasized-words-color: ' . $atts['emphasized_words_color'];
			}

			return $styles;
		}

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['text_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}
	}
}
