<?php

if ( ! function_exists( 'leroux_core_add_tabbed_info_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_tabbed_info_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_tabbed_info_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_tabbed_info_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_tabbed_info_Shortcode extends LerouxCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'leroux_core_filter_tabbed_info_layouts', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/tabbed-info' );
			$this->set_base( 'leroux_core_tabbed_info' );
			$this->set_name( esc_html__( 'Tabbed Info', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds tabs info element', 'leroux-core' ) );
			$this->set_category( esc_html__( 'Leroux Core', 'leroux-core' ) );
			$this->set_scripts(
				array(
					'jquery-ui-tabs' => array(
						'registered' => true,
					),
				)
			);

			$options_map = leroux_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'leroux-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Tab Items', 'leroux-core' ),
					'items'      => array(
						array(
							'field_type' => 'text',
							'name'       => 'item_tab_label',
							'title'      => esc_html__( 'Tab Label', 'leroux-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_title',
							'title'      => esc_html__( 'Title', 'leroux-core' ),
						),
                        array(
                            'field_type' => 'text',
                            'name'       => 'item_tagline',
                            'title'      => esc_html__( 'Tagline', 'leroux-core' ),
                        ),
						array(
							'field_type' => 'textarea',
							'name'       => 'item_text',
							'title'      => esc_html__( 'Text', 'leroux-core' ),
						),
						array(
							'field_type' => 'image',
							'name'       => 'item_image',
							'title'      => esc_html__( 'Image', 'leroux-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_button_text',
							'title'      => esc_html__( 'Button Text', 'leroux-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_button_link',
							'title'      => esc_html__( 'Button Link', 'leroux-core' ),
						),
						array(
							'field_type' => 'select',
							'name'       => 'item_button_target',
							'title'      => esc_html__( 'Button Target', 'leroux-core' ),
							'options'    => leroux_core_get_select_type_options_pool( 'link_target' ),
						),
					),
				)
			);
		}

		public function load_assets() {
			wp_enqueue_script( 'jquery-ui-tabs' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			return leroux_core_get_template_part( 'shortcodes/tabbed-info', 'templates/tabbed-info', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-tabbed-info';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';

			return implode( ' ', $holder_classes );
		}
	}
}
