<?php

if ( ! function_exists( 'leroux_core_add_thumbnail_slider_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function leroux_core_add_thumbnail_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'LerouxCore_Thumbnail_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'leroux_core_filter_register_shortcodes', 'leroux_core_add_thumbnail_slider_shortcode' );
}

if ( class_exists( 'LerouxCore_Shortcode' ) ) {
	class LerouxCore_Thumbnail_Slider_Shortcode extends LerouxCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'leroux_core_filter_thumbnail_slider_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'leroux_core_filter_thumbnail_slider_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( LEROUX_CORE_SHORTCODES_URL_PATH . '/vertical-timeline' );
			$this->set_base( 'leroux_core_thumbnail_slider' );
			$this->set_name( esc_html__( 'Thumbnail Slider', 'leroux-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds thumbnail slider element', 'leroux-core' ) );
			$this->set_scripts(
				array(
					'swiper' => array(
						'registered' => true,
						'dependency' => array( 'jquery' )
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'leroux-core' ),
				)
			);

			$options_map = leroux_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'leroux-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array(
						'map_for_page_builder' => $options_map['visibility'],
						'map_for_widget'       => $options_map['visibility'],
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'intro_title',
					'title'      => esc_html__( 'Intro Title', 'leroux-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'intro_title_tag',
					'title'         => esc_html__( 'Intro Title Tag', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h2'
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'thumb_title_tag',
					'title'         => esc_html__( 'Thumbs Title Tag', 'leroux-core' ),
					'options'       => leroux_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h4'
				)
			);

			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Item Elements', 'leroux-core' ),
					'items'      => array(
						array(
							'field_type' => 'image',
							'name'       => 'thumb_image',
							'title'      => esc_html__( 'Thumb Image', 'leroux-core' ),
						),
						array(
							'field_type' => 'textarea',
							'name'       => 'thumb_image_svg',
							'title'      => esc_html__( 'Thumb Image SVG', 'leroux-core' ),
						),
						array(
							'field_type' => 'color',
							'name'       => 'thumb_image_svg_color',
							'title'      => esc_html__( 'Thumb Image SVG Color', 'leroux-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'thumb_title',
							'title'      => esc_html__( 'Thumb Title', 'leroux-core' ),
						),
						array(
							'field_type' => 'textarea',
							'name'       => 'thumb_text',
							'title'      => esc_html__( 'Thumb Text', 'leroux-core' ),
						),
						array(
							'field_type' => 'image',
							'name'       => 'main_image',
							'title'      => esc_html__( 'Main Image', 'leroux-core' ),
						),
					),
					'group'      => esc_html__( 'Items', 'leroux-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'slider_loop',
					'title'      => esc_html__( 'Enable Slider Loop', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'yes_no', false ),
					'group'      => esc_html__( 'Slider Settings', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'slider_autoplay',
					'title'      => esc_html__( 'Enable Slider Autoplay', 'leroux-core' ),
					'options'    => leroux_core_get_select_type_options_pool( 'yes_no', false ),
					'group'      => esc_html__( 'Slider Settings', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'slider_speed',
					'title'       => esc_html__( 'Slide Duration', 'leroux-core' ),
					'description' => esc_html__( 'Default value is 5000 (ms)', 'leroux-core' ),
					'dependency'    => array(
						'hide' => array(
							'slider_autoplay' => array(
								'values'        => 'no',
								'default_value' => 'yes',
							),
						),
					),
					'group'      => esc_html__( 'Slider Settings', 'leroux-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'slider_speed_animation',
					'title'       => esc_html__( 'Slide Animation Duration', 'leroux-core' ),
					'description' => esc_html__( 'Speed of slide animation in milliseconds. Default value is 800.', 'leroux-core' ),
					'group'      => esc_html__( 'Slider Settings', 'leroux-core' ),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['slider_attr']    = $this->get_slider_data( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			$atts['this_shortcode'] = $this;

			return leroux_core_get_template_part( 'shortcodes/thumbnail-slider', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-thumbnail-slider';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';

			return implode( ' ', $holder_classes );
		}

		private function get_slider_data( $atts ) {
			$data = array();

			$data['loop']                 = isset( $atts['slider_loop'] ) ? 'no' !== $atts['slider_loop'] : true;
			$data['autoplay']             = isset( $atts['slider_autoplay'] ) ? 'no' !== $atts['slider_autoplay'] : true;
			$data['speed']                = isset( $atts['slider_speed'] ) ? $atts['slider_speed'] : '';
			$data['speedAnimation']       = isset( $atts['slider_speed_animation'] ) ? $atts['slider_speed_animation'] : '';

			return json_encode( $data );
		}
	}
}
