<div <?php qode_framework_class_attribute( $holder_classes ); ?> <?php qode_framework_inline_attr( $slider_attr, 'data-options' ); ?>>
	<div class="qodef-m-inner">
		<?php if( is_array( $items ) && count( $items ) > 0 ) { ?>
			<div class="qodef-m-left">
				<div class="swiper-container qodef-m-slides">
					<div class="swiper-wrapper">
						<?php foreach( $items as $item ) { ?>
							<div class="qodef-e qodef-e-item swiper-slide">
								<?php echo wp_get_attachment_image( $item['main_image'], 'full' ); ?>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
			<div class="qodef-m-right">
				<div class="qodef-m-right-inner">
					<<?php echo esc_attr( $intro_title_tag ) ?> class="qodef-intro-title">
						<?php echo esc_html( $intro_title ) ?>
					</<?php echo esc_attr( $intro_title_tag ) ?>>
					<div class="qodef-m-thumbnails-holder">
						<div class="qodef-m-thumbnails swiper-container">
							<div class="swiper-wrapper qodef-m-thumbnails-inner">
								<?php foreach( $items as $key => $item ) {
									$counter = $key < 10 ? '0' . ( $key + 1 ) : ( $key + 1 );
									$item['thumb_image_svg_color'] = ! empty( $item['thumb_image_svg_color'] ) ? $item['thumb_image_svg_color'] : '';
								?>
								<div class="qodef-e qodef-m-thumb-item swiper-slide">
									<div class="qodef-m-thumb-image" style="color: <?php echo esc_attr( $item['thumb_image_svg_color'] ); ?>">
										<?php if( ! empty( $item['thumb_image'] ) ) { ?>
											<?php echo wp_get_attachment_image( $item['thumb_image'], 'full' ); ?>
										<?php } ?>
										<?php if( ! empty( $item['thumb_image_svg'] ) ) { ?>
											<?php echo qode_framework_wp_kses_html( 'svg', $item['thumb_image_svg'] ); ?>
										<?php } ?>
									</div>
									<<?php echo esc_attr( $thumb_title_tag ) ?> class="qodef-m-title">
										<span class="qodef-title-number">
											<?php echo esc_html( $counter ); ?>
										</span>
										<?php echo esc_html( $item['thumb_title'] ); ?>
									</<?php echo esc_attr( $thumb_title_tag ) ?>>
									<p class="qodef-m-description">
										<?php echo esc_html( $item['thumb_text'] ); ?>
									</p>
								</div>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php } ?>
	</div>
</div>
